/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.concurrency;

import com.google.common.collect.Iterables;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.MatchGroupElement;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Stream;

@Check(id="cqse-avoid-thread-local-storage", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidThreadLocalStorageCheck
extends CheckImplementationBase {
    private static final String CHECK_NAME = "Avoid thread-local storage";
    private static final int OFFENDING_USE_GROUP = 0;
    private static final TokenPattern NEW_THREAD_LOCAL_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.NEW}).sequence(new Object[]{TokenPattern.text((String)"ThreadLocal")}).group(0).skipNested((Object)ETokenType.LT, (Object)ETokenType.GT, true).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, false);
    private static final TokenPattern THREAD_LOCAL_WITH_INITIAL_PATTERN = new TokenPattern().sequence(new Object[]{TokenPattern.text((String)"ThreadLocal")}).group(0).sequence(new Object[]{ETokenType.DOT}).skipNested((Object)ETokenType.LT, (Object)ETokenType.GT, true).sequence(new Object[]{TokenPattern.text((String)"withInitial")}).sequence(new Object[]{ETokenType.LPAREN});

    public void execute() throws CheckException {
        List selectedEntities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.STATEMENT, EShallowEntityType.ATTRIBUTE));
        for (ShallowEntity selectedEntity : selectedEntities) {
            this.processTokens((List<IToken>)selectedEntity.ownStartTokens());
            this.processTokens((List<IToken>)selectedEntity.ownEndTokens());
        }
    }

    private void processTokens(List<IToken> tokens) {
        Stream.of(NEW_THREAD_LOCAL_PATTERN, THREAD_LOCAL_WITH_INITIAL_PATTERN).flatMap(pattern -> pattern.findAll(tokens).stream()).forEach(this::createAndStoreFinding);
    }

    private void createAndStoreFinding(TokenPatternMatch offendingMatch) {
        MatchGroupElement offendingUse = (MatchGroupElement)Iterables.getOnlyElement((Iterable)offendingMatch.getMatchGroup(0));
        this.buildFinding(CHECK_NAME, this.buildLocation().forTokens(offendingUse.getTokens())).createAndStore();
    }
}

