/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.concurrency;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-use-unlock-in-finally", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class UseUnlockInFinallyCheck
extends CheckImplementationBase {
    private static final String CHECK_NAME = "Use `unlock()` in finally block";
    private static final TokenPattern UNLOCK_CALL_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.DOT}).sequence(new Object[]{TokenPattern.text((String)"unlock")}).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, false);

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity statement) {
        for (UnmodifiableList tokens : statement.ownTokens()) {
            if (!UNLOCK_CALL_PATTERN.matchesAnywhere((List)tokens) || UseUnlockInFinallyCheck.hasEnclosingFinallyStatement(statement)) continue;
            this.buildFinding(CHECK_NAME, this.buildLocation().forEntity(statement)).createAndStore();
        }
    }

    private static boolean hasEnclosingFinallyStatement(ShallowEntity statement) {
        for (ShallowEntity ancestor = statement.getParent(); ancestor != null && ancestor.getType() == EShallowEntityType.STATEMENT; ancestor = ancestor.getParent()) {
            if (!"finally".equals(ancestor.getSubtype())) continue;
            return true;
        }
        return false;
    }
}

