/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.spring;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.java.spring.SpringChecksUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="java:S6810", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AsyncMethodsShouldReturnFutureOrNullCheck
extends CheckImplementationBase {
    private static final Set<String> POSSIBLE_FUTURE_TYPE_NAMES = Set.of("Future", "Async", "Promise");

    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.METHOD).forEach(this::handleMethod);
    }

    private void handleMethod(ShallowEntity method) {
        if (!SpringChecksUtils.isAsyncMethod(method)) {
            return;
        }
        String returnType = LanguageFeatureParser.JAVA.getReturnType(method);
        if (returnType == null || returnType.equals("void")) {
            return;
        }
        if (AsyncMethodsShouldReturnFutureOrNullCheck.findingShouldBeCreated(method, returnType)) {
            this.buildFinding(AsyncMethodsShouldReturnFutureOrNullCheck.createMessage(method), this.buildLocation().forEntityFirstLine(method)).createAndStore();
        }
    }

    private static boolean findingShouldBeCreated(ShallowEntity method, String returnType) {
        return !AsyncMethodsShouldReturnFutureOrNullCheck.isFutureType(returnType) && !AsyncMethodsShouldReturnFutureOrNullCheck.isGenericThatExtendsFuture(method, returnType);
    }

    private static boolean isFutureType(String returnType) {
        return POSSIBLE_FUTURE_TYPE_NAMES.stream().anyMatch(returnType::contains);
    }

    private static boolean isGenericThatExtendsFuture(ShallowEntity method, String returnType) {
        for (ShallowEntity current = method; current != null; current = current.getParent()) {
            UnmodifiableList tokens = current.ownStartTokens();
            List genericDefinitions = TokenStreamUtils.allStartingIndicesOfTypeSequence((List)tokens, (int)0, (int)(tokens.size() - 1), (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.EXTENDS, ETokenType.IDENTIFIER});
            for (Integer index : genericDefinitions) {
                IToken generic = (IToken)tokens.get(index.intValue());
                IToken type = (IToken)tokens.get(index + 2);
                if (!generic.getText().equals(returnType) || !AsyncMethodsShouldReturnFutureOrNullCheck.isFutureType(type.getText())) continue;
                return true;
            }
        }
        return false;
    }

    private static String createMessage(ShallowEntity method) {
        return "Async method `%s` should return void or future".formatted(method.getName());
    }
}

