/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.spring;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.java.spring.SpringChecksUtils;
import java.util.Collection;
import java.util.List;

@Check(id="java:S6817", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DoNotUseAsyncMethodsInConfigurationClassCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.METHOD).forEach(this::handleMethod);
    }

    private void handleMethod(ShallowEntity method) {
        if (SpringChecksUtils.isAsyncMethod(method) && SpringChecksUtils.isConfigurationClass(method.getParent())) {
            this.buildFinding(DoNotUseAsyncMethodsInConfigurationClassCheck.createMessage(method), this.buildLocation().forEntityFirstLine(method)).createAndStore();
        }
    }

    private static String createMessage(ShallowEntity method) {
        return "Async method `%s` declared in configuration class".formatted(method.getName());
    }
}

