/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.spring;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.java.spring.SpringChecksUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="java:S3305", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SpringConfigurationWithAutowiredFieldsCheck
extends CheckImplementationBase {
    private static final TokenPattern REQUIRED_EQUALS_FALSE_PATTERN = TokenPattern.of().tokenTypeAndText(ETokenType.IDENTIFIER, "required").sequence(new Object[]{ETokenType.EQ}).tokenTypeAndText(ETokenType.BOOLEAN_LITERAL, "false");
    private static final String MESSAGE = "Inject this field value directly into `%s`, the only method that uses it";
    private Map<String, Set<ShallowEntity>> attributeToMethodMapping;

    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.TYPE).forEach(this::checkAttributesOfType);
    }

    private void checkAttributesOfType(ShallowEntity type) {
        if (!LanguageFeatureParser.JAVA.hasAnnotation(type, SpringChecksUtils.CONFIGURATION_ANNOTATIONS)) {
            return;
        }
        this.attributeToMethodMapping = new HashMap<String, Set<ShallowEntity>>();
        Set<ShallowEntity> attributes = SpringConfigurationWithAutowiredFieldsCheck.extractInjectedAttributes(type);
        attributes.forEach(attribute -> this.attributeToMethodMapping.put(attribute.getName(), new HashSet()));
        type.getChildren().stream().filter(entity -> entity.getType() == EShallowEntityType.METHOD).forEach(this::chackAttributeUsageInMethod);
        attributes.forEach(this::checkAttributeUsage);
    }

    private static Set<ShallowEntity> extractInjectedAttributes(ShallowEntity type) {
        return type.getChildren().stream().filter(entity -> entity.getType() == EShallowEntityType.ATTRIBUTE).filter(attribute -> LanguageFeatureParser.JAVA.hasAnnotation(attribute, SpringChecksUtils.INJECTION_ANNOTATIONS)).filter(attribute -> !SpringConfigurationWithAutowiredFieldsCheck.isNotRequired(attribute) || !SpringConfigurationWithAutowiredFieldsCheck.isInitialised(attribute)).collect(Collectors.toSet());
    }

    private void chackAttributeUsageInMethod(ShallowEntity method) {
        Set parameters = LanguageFeatureParser.JAVA.getSplitParameterTokens(method).stream().map(List::getLast).map(IToken::getText).collect(Collectors.toSet());
        List childrenTokens = method.getChildren().stream().flatMap(child -> child.includedTokens().stream()).toList();
        for (Integer identifierIndex : TokenStreamUtils.findAll(childrenTokens, (ITokenMatcher)ETokenType.IDENTIFIER)) {
            IToken identifier;
            boolean beforeIdentifierIsDot;
            boolean beforeIdentifierIsThis = identifierIndex - 2 >= 0 && ((IToken)childrenTokens.get(identifierIndex - 2)).getType() == ETokenType.THIS;
            boolean bl = beforeIdentifierIsDot = identifierIndex - 1 >= 0 && ((IToken)childrenTokens.get(identifierIndex - 1)).getType() == ETokenType.DOT;
            if (beforeIdentifierIsDot && !beforeIdentifierIsThis || parameters.contains((identifier = (IToken)childrenTokens.get(identifierIndex)).getText()) || !this.attributeToMethodMapping.containsKey(identifier.getText())) continue;
            this.attributeToMethodMapping.get(identifier.getText()).add(method);
        }
    }

    private void checkAttributeUsage(ShallowEntity attribute) {
        Set<ShallowEntity> methods = this.attributeToMethodMapping.get(attribute.getName());
        if (methods == null || methods.size() != 1) {
            return;
        }
        ShallowEntity method = Objects.requireNonNull((ShallowEntity)CollectionUtils.getAny(methods));
        if (LanguageFeatureParser.JAVA.hasAnnotation(method, SpringChecksUtils.BEAN_ANNOTATIONS)) {
            this.buildFinding(MESSAGE.formatted(method.getName()), this.buildLocation().forEntity(attribute)).createAndStore();
        }
    }

    private static boolean isInitialised(ShallowEntity attribute) {
        return TokenStreamUtils.contains((List)attribute.ownStartTokens(), (ETokenType)ETokenType.EQ);
    }

    private static boolean isNotRequired(ShallowEntity attribute) {
        return LanguageFeatureParser.JAVA.getAnnotations(attribute).stream().filter(annotation -> LanguageFeatureParser.JAVA.isSpecificAnnotation(annotation, SpringChecksUtils.INJECTION_ANNOTATIONS)).anyMatch(annotation -> REQUIRED_EQUALS_FALSE_PATTERN.matchesAnywhere((List)annotation.ownStartTokens()));
    }
}

