/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.streams;

import com.google.common.collect.Sets;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Check(id="cqse-terminal-operation-at-end-of-stream", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class TerminalOperationAtEndOfStreamCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "A Java Stream should have exactly one terminal operation at the end";
    private static final Set<String> STREAM_START_TOKENS = Sets.newHashSet((Object[])new String[]{"stream", "parallelStream"});
    private static final Set<String> STATIC_STREAM_START_TOKENS = Sets.newHashSet((Object[])new String[]{"Stream", "IntStream", "LongStream", "DoubleStream"});
    private static final Set<String> TERMINAL_OPERATION_TOKENS = Sets.newHashSet((Object[])new String[]{"allMatch", "anyMatch", "noneMatch", "collect", "count", "forEach", "min", "max", "reduce", "toArray", "reduce", "forEachOrdered", "findFirst", "sum", "findAny", "contains", "summaryStatistics", "toString"});

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        int offset;
        List<Integer> terminalOperationIndexes;
        List<IToken> tokens = entity.ownTokens().stream().flatMap(Collection::stream).collect(Collectors.toList());
        List<Integer> startOperationIndexes = TerminalOperationAtEndOfStreamCheck.findStartingOperations(tokens);
        if (!startOperationIndexes.isEmpty() && (TerminalOperationAtEndOfStreamCheck.hasMultipleTerminalOperations(tokens, startOperationIndexes, terminalOperationIndexes = TerminalOperationAtEndOfStreamCheck.findTerminalOperationIndexes(tokens, offset = startOperationIndexes.get(0).intValue())) || TerminalOperationAtEndOfStreamCheck.hasNoTerminalOperation(entity, terminalOperationIndexes) || !TerminalOperationAtEndOfStreamCheck.streamsEndWithTerminalOperation(tokens, terminalOperationIndexes))) {
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }

    private static List<Integer> findStartingOperations(List<IToken> tokens) {
        int match;
        ArrayList<Integer> streamStarts = new ArrayList<Integer>();
        List streamStartMatches = TokenStreamTextUtils.findAll(tokens, STREAM_START_TOKENS, (int)0, (int)tokens.size());
        Iterator iterator = streamStartMatches.iterator();
        while (iterator.hasNext()) {
            match = (Integer)iterator.next();
            if (match <= 0 || match >= tokens.size() - 2 || !TokenStreamUtils.containsSequence(tokens, (int)(match - 1), (int)(match + 2), (ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.LPAREN})) continue;
            streamStarts.add(match);
        }
        streamStartMatches = TokenStreamTextUtils.findAll(tokens, STATIC_STREAM_START_TOKENS, (int)0, (int)tokens.size());
        iterator = streamStartMatches.iterator();
        while (iterator.hasNext()) {
            match = (Integer)iterator.next();
            if (match >= tokens.size() - 2 || !TokenStreamUtils.containsSequence(tokens, (int)match, (int)(match + 2), (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.DOT})) continue;
            streamStarts.add(match);
        }
        return streamStarts;
    }

    private static List<Integer> findTerminalOperationIndexes(List<IToken> tokens, int startOffset) {
        List matchedIndices = TokenStreamTextUtils.findAll(tokens, TERMINAL_OPERATION_TOKENS, (int)startOffset, (int)tokens.size());
        ArrayList<Integer> terminalOperationIndexes = new ArrayList<Integer>();
        Iterator iterator = matchedIndices.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            if (index <= 0 || index >= tokens.size() - 1 || tokens.get(index + 1).getType() != ETokenType.LPAREN || tokens.get(index - 1).getType() != ETokenType.DOT) continue;
            terminalOperationIndexes.add(index);
        }
        return terminalOperationIndexes;
    }

    private static boolean hasMultipleTerminalOperations(List<IToken> tokens, List<Integer> startOperationIndexes, List<Integer> terminalOperationIndexes) {
        if (terminalOperationIndexes.size() < 2) {
            return false;
        }
        for (int terminalOperationIndex : terminalOperationIndexes) {
            int closingParentheses = TokenStreamUtils.findMatchingClosingToken(tokens, (int)(terminalOperationIndex + 2), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
            if (tokens.size() >= closingParentheses || tokens.get(closingParentheses + 1).getType() != ETokenType.DOT) continue;
            return true;
        }
        return startOperationIndexes.size() != terminalOperationIndexes.size();
    }

    private static boolean hasNoTerminalOperation(ShallowEntity entity, List<Integer> terminalOperationIndexes) {
        if (!terminalOperationIndexes.isEmpty()) {
            return false;
        }
        ShallowEntity currentEntity = entity;
        while (currentEntity.getParent() != null) {
            if (TerminalOperationAtEndOfStreamCheck.isReturnInLambda(entity, currentEntity) || TerminalOperationAtEndOfStreamCheck.isLambdaExpression(currentEntity) || TerminalOperationAtEndOfStreamCheck.isAssertJOperation(currentEntity)) {
                return false;
            }
            if (currentEntity.getType() == EShallowEntityType.METHOD || currentEntity.getType() == EShallowEntityType.TYPE) {
                return true;
            }
            currentEntity = currentEntity.getParent();
        }
        return true;
    }

    private static boolean isReturnInLambda(ShallowEntity entity, ShallowEntity currentEntity) {
        return currentEntity.getType() == EShallowEntityType.METHOD && currentEntity.getSubtype().equals("lambda") && "return".equals(entity.getName());
    }

    private static boolean isLambdaExpression(ShallowEntity currentEntity) {
        return currentEntity.getSubtype().equals("lambda expression");
    }

    private static boolean isAssertJOperation(ShallowEntity currentEntity) {
        if (!currentEntity.hasChildren()) {
            return false;
        }
        return TokenStreamTextUtils.findFirst((List)currentEntity.includedTokens(), (int)0, (int)((ShallowEntity)currentEntity.getChildren().get(0)).getRelativeStartTokenIndex(), (String)"assertThat") != -1;
    }

    private static boolean streamsEndWithTerminalOperation(List<IToken> tokens, List<Integer> terminalOperationIndexes) {
        boolean result = true;
        for (int terminalOperationIndex : terminalOperationIndexes) {
            int closingParentheses = TokenStreamUtils.findMatchingClosingToken(tokens, (int)(terminalOperationIndex + 2), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
            result &= closingParentheses != -1 && tokens.size() > closingParentheses;
        }
        return result;
    }
}

