/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.tests;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.ECheckTarget;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.EJavaTestFramework;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.clike.CLikeCheckUtils;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

@Check(id="java:S5833", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE}, target={ECheckTarget.TEST_CODE})
public class AssertJContextSetupCheck
extends CheckImplementationBase {
    private static final Predicate<String> IS_ASSERT_J_NON_ASSERTION_METHOD = AssertJContextSetupCheck.isAssertJNonAssertionMethod();
    private static final String FINDING_MESSAGE = "Add an assertion predicate after calling this method";
    private static final JavaMethodCallMatcher ASSERT_J_CALL_MATCHER = JavaMethodCallMatcher.create().onTypes(EJavaTestFramework.ASSERT_J.getAssertionTypes()).withTargetMethodNames(new String[]{"assertThat.*", "assertWith", "then", "given"});

    private static Predicate<String> isAssertJNonAssertionMethod() {
        Set<String> exactMethodNames = Set.of("as", "describedAs", "overridingErrorMessage", "extracting", "withFailMessage", "withRepresentation", "withStrictTypeChecking", "withEqualsForFields", "withEqualsForType", "withErrorMessageForFields", "withErrorMessageForType", "withIgnoredFields", "withIntrospectionStrategy", "withEqualForFields", "withComparatorForFields", "withEqualForType", "withComparatorForType", "withComparedFields", "withThrowableOfType", "withType");
        Set<String> methodPrefixes = Set.of("using", "filteredOn");
        return methodName -> {
            if (exactMethodNames.contains(methodName)) return true;
            if (!methodPrefixes.stream().anyMatch(methodName::startsWith)) return false;
            return true;
        };
    }

    public void execute() throws CheckException {
        if (((List)LanguageFeatureParser.JAVA.getTestFrameworkImports((List)this.getRootChildren()).getCollectionOrEmpty((Object)EJavaTestFramework.ASSERT_J)).isEmpty()) {
            return;
        }
        JavaImportSensitiveTypeResolver typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        for (JavaMethodCallMatcher.MethodCall assertionCall : ASSERT_J_CALL_MATCHER.find(this.context, typeResolver)) {
            this.analyzeAssertJCall(assertionCall);
        }
    }

    private void analyzeAssertJCall(JavaMethodCallMatcher.MethodCall assertJCall) {
        if (CLikeCheckUtils.isReturnStatementOrVariableDeclaration((ShallowEntity)assertJCall.entity())) {
            return;
        }
        List chainedCalls = assertJCall.findChainedCalls();
        if (chainedCalls.isEmpty()) {
            return;
        }
        if (IS_ASSERT_J_NON_ASSERTION_METHOD.test(((JavaMethodCallMatcher.ChainedCall)chainedCalls.getLast()).methodName())) {
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forToken(((JavaMethodCallMatcher.ChainedCall)chainedCalls.getLast()).callToken())).createAndStore();
        }
    }
}

