/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.javascript;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-use-consistent-form-string-literals", languages={ELanguage.JAVASCRIPT}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class UseConsistentFormStringLiteralsCheck
extends CheckImplementationBase {
    @CheckOption(name="Use Single-Quoted String Literals", description="Use Single-Quoted String Literals in Javascript code")
    private boolean useSingleQuotedLiterals = true;
    private String quotationCharacter = "'";
    private String findingMessage = "Use Single-Quoted String Literals";

    public void initialize() {
        if (!this.useSingleQuotedLiterals) {
            this.quotationCharacter = "\"";
            this.findingMessage = "Use Double-Quoted String Literals";
        }
    }

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        List indices = TokenStreamUtils.findAll((List)tokens, (ITokenMatcher)ETokenType.STRING_LITERAL);
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            IToken token = (IToken)tokens.get(index);
            if (token.getText().startsWith(this.quotationCharacter)) continue;
            this.buildFinding(this.findingMessage, this.buildLocation().forToken(token)).createAndStore();
        }
    }
}

