/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.matlab;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-no-if-zero", languages={ELanguage.MATLAB}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NoIfZeroCheck
extends CheckImplementationBase {
    private static final EnumSet<ETokenType> STATEMENT_SEPARATORS = EnumSet.of(ETokenType.EOL, ETokenType.SEMICOLON, ETokenType.COMMA);

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!"if".equals(statement.getSubtype())) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList entityTokens = entity.ownStartTokens();
        if (entityTokens.size() <= 3) {
            return;
        }
        IToken token = (IToken)entityTokens.get(1);
        if (token.getType() != ETokenType.INTEGER_LITERAL || !token.getText().equals("0")) {
            return;
        }
        token = (IToken)entityTokens.get(2);
        if (STATEMENT_SEPARATORS.contains(token.getType())) {
            this.buildFinding("The conditional expression if 0 should be avoided", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

