/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.objc;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternBase;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-objc-comparison-assertion-check", languages={ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ObjcComparisonAssertionCheck
extends CheckImplementationBase {
    private static final TokenPatternBase[] BOOLEAN_ASSERTIONS = new TokenPatternBase[]{TokenPattern.text((String)"XCTAssert"), TokenPattern.text((String)"XCTAssertTrue"), TokenPattern.text((String)"XCTAssertFalse")};
    private static final TokenPattern[] COMPARISON_OPERANDS_PATTERN = new TokenPattern[]{new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).repeated(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER}).notFollowedBy((Object)ETokenType.DOT).notFollowedBy((Object)ETokenType.LPAREN), new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).repeated(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER}).notFollowedBy((Object)ETokenType.DOT).sequence(new Object[]{ETokenType.LPAREN}).skipTo(new Object[]{ETokenType.RPAREN}).notFollowedBy((Object)ETokenType.DOT), new TokenPattern().alternative(new Object[]{ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL})};
    private static final EnumSet<ETokenType> COMPARISON_OPERATORS = EnumSet.of(ETokenType.EQEQ, new ETokenType[]{ETokenType.NOTEQ, ETokenType.LT, ETokenType.LTEQ, ETokenType.GT, ETokenType.GTEQ});
    private static final TokenPattern BOOLEAN_ASSERTION_COMPARISON_EXPRESSION_PATTERN = new TokenPattern().alternative((Object[])BOOLEAN_ASSERTIONS).sequence(new Object[]{ETokenType.LPAREN}).alternative((Object[])COMPARISON_OPERANDS_PATTERN).alternative(new Object[]{COMPARISON_OPERATORS}).alternative((Object[])COMPARISON_OPERANDS_PATTERN).skipTo(new Object[]{ETokenType.RPAREN});
    private static final Set<String> TARGET_FUNCTION_NAMES = Set.of("XCTAssert", "XCTAssertTrue", "XCTAssertFalse");

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (statement.getName() == null || !TARGET_FUNCTION_NAMES.contains(statement.getName())) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (ObjcComparisonAssertionCheck.isComparableAssertionExpression((List<IToken>)tokens)) {
            this.buildFinding("Assertion that is specific to a comparison operator should be used instead of a boolean assertion.", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }

    private static boolean isComparableAssertionExpression(List<IToken> assertExpressionTokens) {
        return BOOLEAN_ASSERTION_COMPARISON_EXPRESSION_PATTERN.matchesAnywhere(assertExpressionTokens);
    }
}

