/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.plsql;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-bulk-collect-without-limit", languages={ELanguage.PLSQL}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidFetchSelectBulkCollectWithoutLimitCheck
extends CheckImplementationBase {
    private static final String FETCH_STATEMENT_TYPE = "fetch";
    private static final String SELECT_STATEMENT_TYPE = "select";
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (FETCH_STATEMENT_TYPE.equals(statement.getSubtype())) {
                this.processEntity(statement);
            }
            if (!SELECT_STATEMENT_TYPE.equals(statement.getName())) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        List sequenceStartIndices = TokenStreamUtils.firstTokenOfClassOrTypeSequence((List)tokens, (ITokenMatcher[])new ITokenMatcher[]{ETokenType.BULK, ETokenType.COLLECT});
        if (sequenceStartIndices.isEmpty()) {
            return;
        }
        String statementType = AvoidFetchSelectBulkCollectWithoutLimitCheck.determineStatementType(entity);
        int sequenceStartIndex = (Integer)sequenceStartIndices.get(0);
        if (statementType.equals(SELECT_STATEMENT_TYPE)) {
            this.buildFinding("Avoid using `" + statementType.toUpperCase() + "` statements with `BULK COLLECT`.", this.buildLocation().forToken((IToken)tokens.get(sequenceStartIndex))).createAndStore();
        } else if (statementType.equals(FETCH_STATEMENT_TYPE) && !TokenStreamUtils.contains(tokens.subList(sequenceStartIndex, tokens.size() - 1), (ETokenType)ETokenType.LIMIT)) {
            this.buildFinding("Avoid using `" + statementType.toUpperCase() + "` statements without a `LIMIT` clause.", this.buildLocation().forToken((IToken)tokens.get(sequenceStartIndex))).createAndStore();
        }
    }

    private static String determineStatementType(ShallowEntity entity) {
        if (SELECT_STATEMENT_TYPE.equals(entity.getName())) {
            return SELECT_STATEMENT_TYPE;
        }
        if (FETCH_STATEMENT_TYPE.equals(entity.getSubtype())) {
            return FETCH_STATEMENT_TYPE;
        }
        LOGGER.error("Could not determine statement type of entity.");
        return "";
    }
}

