/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.python;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.python.PythonMainMethodUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Check(id="cqse-do-not-call-sys-exit", languages={ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DoNotCallSysExitCheck
extends CheckImplementationBase {
    private static final String[] SYS_EXIT_TOKEN_TEXT = new String[]{"sys", ".", "exit"};
    private final Map<Integer, Boolean> entityInMainCache = new HashMap<Integer, Boolean>();

    public void execute() throws CheckException {
        this.entityInMainCache.clear();
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) {
        int callIndex;
        if (!this.isInMainMethod(entity) && (callIndex = TokenStreamTextUtils.findSequence((List)entity.ownStartTokens(), (int)0, (ETokenType)ETokenType.IDENTIFIER, (String[])SYS_EXIT_TOKEN_TEXT)) != -1) {
            this.buildFinding("Prefer throwing exceptions over `sys.exit()` within the code", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }

    private boolean isInMainMethod(ShallowEntity entity) {
        return PythonMainMethodUtils.isInMainMethod(entity, this.entityInMainCache);
    }
}

