/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.matlab;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.simulink.LocalCodeSnippetParser;
import eu.cqse.check.simulink.matlab.SimulinkMatlabCheckUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.StateflowUtils;
import org.jetbrains.annotations.VisibleForTesting;

@Check(id="cqse.maab.na_0017", languages={ELanguage.SIMULINK})
public class SimulinkFunctionCallDepthCheck
extends CheckImplementationBase {
    private static final FindingPropertyList PROPERTIES = FindingPropertyList.singleton((String)"Recommended Action", (String)"Reduce the number of (nested) function calls in the block below the configured threshold.");
    @CheckOption(name="Maximum function call depth", description="Maximum allowed number of function call levels.")
    private int maximumFunctionCallDepth = 3;
    private static final TokenPattern FUNCTION_CALL_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(1).sequence(new Object[]{ETokenType.LPAREN});
    private static final TokenPattern COMMAND_SYNTAX_CALL_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(1).sequence(new Object[]{ETokenType.IDENTIFIER});
    private final LocalCodeSnippetParser matlabParser = new LocalCodeSnippetParser(ELanguage.MATLAB);

    public void execute() throws CheckException {
        PROPERTIES.addProperty("Max. configured call depth", (Object)this.maximumFunctionCallDepth);
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkMatlabCheckUtils.listMatlabFunctionBlocks(model)) {
            for (String script : StateflowUtils.extractMatlabScriptsFromBlock((SimulinkBlock)block)) {
                this.checkFunctionCallDepth(script, this.context.buildLocation().forSimulinkBlock(block));
            }
        }
        for (StateflowState stateflowMatlabFunctionState : StateflowUtils.getStateflowMatlabFunctions((SimulinkModel)model)) {
            String script = StateflowUtils.extractMatlabScriptFromStateflowState((StateflowState)stateflowMatlabFunctionState);
            this.checkFunctionCallDepth(script, this.context.buildLocation().forStateflowNode((StateflowNodeBase)stateflowMatlabFunctionState));
        }
    }

    private void checkFunctionCallDepth(String script, QualifiedNameLocation findingLocation) {
        List<ShallowEntity> entities = this.matlabParser.parseTopLevel(script, this.context.getUniformPath());
        List functions = ShallowEntityTraversalUtils.listEntitiesOfType(entities, (EShallowEntityType)EShallowEntityType.METHOD);
        if (functions.isEmpty()) {
            return;
        }
        HashMap<String, List<String>> callMap = new HashMap<String, List<String>>();
        for (ShallowEntity method : functions) {
            List<String> calledMethods = SimulinkFunctionCallDepthCheck.getCalledMethodNames(method);
            callMap.put(method.getName(), calledMethods);
        }
        List<String> deepFunctionCallTrace = SimulinkFunctionCallDepthCheck.findDeepFunctionCallDepth(callMap, ((ShallowEntity)functions.get(0)).getName(), this.maximumFunctionCallDepth);
        if (!deepFunctionCallTrace.isEmpty()) {
            String functionList = String.join((CharSequence)"->", deepFunctionCallTrace);
            PROPERTIES.addProperty("Function Call Stack", (Object)functionList);
            this.buildFinding("Function call depth of " + deepFunctionCallTrace.size(), (ElementLocation)findingLocation).addFindingProperties(PROPERTIES).createAndStore();
        }
    }

    @VisibleForTesting
    static List<String> findDeepFunctionCallDepth(Map<String, List<String>> callMap, String mainFunctionName, int maximumFunctionCallDepth) {
        Object deepestCall = CollectionUtils.emptyList();
        ArrayDeque<List<String>> stacksToExplore = new ArrayDeque<List<String>>();
        stacksToExplore.add(Collections.singletonList(mainFunctionName));
        while (!stacksToExplore.isEmpty()) {
            List stack = (List)stacksToExplore.pop();
            String lastFunction = (String)CollectionUtils.getLast((List)stack);
            ArrayList calledFunctions = new ArrayList(callMap.getOrDefault(lastFunction, Collections.emptyList()));
            calledFunctions.removeAll(stack);
            int maximumCallSize = Math.max(maximumFunctionCallDepth, deepestCall.size());
            if (calledFunctions.isEmpty() && stack.size() > maximumCallSize) {
                deepestCall = new ArrayList(stack);
            }
            for (String calledFunction : calledFunctions) {
                ArrayList<String> newStack = new ArrayList<String>(stack);
                newStack.add(calledFunction);
                stacksToExplore.add(newStack);
            }
        }
        return deepestCall;
    }

    private static List<String> getCalledMethodNames(ShallowEntity method) {
        ArrayList<String> calledMethods = new ArrayList<String>();
        for (ShallowEntity statement : ShallowEntityTraversalUtils.listEntitiesOfType((Collection)method.getChildren(), (EShallowEntityType)EShallowEntityType.STATEMENT)) {
            List matches = FUNCTION_CALL_PATTERN.findAll((List)statement.includedTokens());
            for (TokenPatternMatch match : matches) {
                String calledMethodName = match.groupString(1);
                calledMethods.add(calledMethodName);
            }
            TokenPatternMatch match = COMMAND_SYNTAX_CALL_PATTERN.matchAtStartOf((List)statement.includedTokens());
            if (match == null) continue;
            String calledMethodName = match.groupString(1);
            calledMethods.add(calledMethodName);
        }
        return calledMethods;
    }
}

