/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.matlab;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.simulink.LocalCodeSnippetParser;
import eu.cqse.check.simulink.matlab.SimulinkMatlabCheckUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.maab.na_0018", languages={ELanguage.SIMULINK})
public class SimulinkNestingInMatlabFunctionBlockCheck
extends CheckImplementationBase {
    @CheckOption(name="Maximum nesting depth of if/else and case statements", description="The maximum nesting depth of if/else and case statements in Matlab Function blocks.")
    private int maximumNestingDepth = 3;
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Further divide the MATLAB Function into sub functions.");
    private static final Set<String> COUNTED_SUBTYPE_NAMES = CollectionUtils.asHashSet((Object[])new String[]{"if", "elseif", "else", "switch"});
    private static final Comparator<Pair<Integer, Integer>> NESTING_DEPTH_PAIR_COMPARATOR = Comparator.comparing(ImmutablePair::getFirst).thenComparing(Comparator.comparing(ImmutablePair::getSecond).reversed());
    private final LocalCodeSnippetParser matlabParser = new LocalCodeSnippetParser(ELanguage.MATLAB);

    public void execute() throws CheckException {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkMatlabCheckUtils.listMatlabFunctionBlocks(model)) {
            for (String script : StateflowUtils.extractMatlabScriptsFromBlock((SimulinkBlock)block)) {
                this.checkNestingDepth(script, this.context.buildLocation().forSimulinkBlock(block));
            }
        }
        for (StateflowState stateflowMatlabFunctionState : StateflowUtils.getStateflowMatlabFunctions((SimulinkModel)model)) {
            String script = StateflowUtils.extractMatlabScriptFromStateflowState((StateflowState)stateflowMatlabFunctionState);
            this.checkNestingDepth(script, this.context.buildLocation().forStateflowNode((StateflowNodeBase)stateflowMatlabFunctionState));
        }
    }

    private void checkNestingDepth(String script, QualifiedNameLocation findingLocation) {
        List<ShallowEntity> entities = this.matlabParser.parseTopLevel(script, this.context.getUniformPath());
        for (ShallowEntity topLevelEntity : entities) {
            Pair<Integer, Integer> maxNestingDepth = SimulinkNestingInMatlabFunctionBlockCheck.getMaxNestingDepth(topLevelEntity);
            if ((Integer)maxNestingDepth.getFirst() <= this.maximumNestingDepth) continue;
            this.buildFinding("Deep nesting in Matlab Function Block in line " + String.valueOf(maxNestingDepth.getSecond()) + " (nesting level " + String.valueOf(maxNestingDepth.getFirst()) + ", max. " + this.maximumNestingDepth + " allowed)", (ElementLocation)findingLocation).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static Pair<Integer, Integer> getMaxNestingDepth(ShallowEntity entity) {
        UnmodifiableList children = entity.getChildren();
        if (children.isEmpty()) {
            return Pair.createPair((Object)0, (Object)entity.getStartLine());
        }
        ArrayList<Pair<Integer, Integer>> childDepths = new ArrayList<Pair<Integer, Integer>>();
        for (ShallowEntity child : entity.getChildren()) {
            childDepths.add(SimulinkNestingInMatlabFunctionBlockCheck.getMaxNestingDepth(child));
        }
        Pair<Integer, Integer> deepestChild = Collections.max(childDepths, NESTING_DEPTH_PAIR_COMPARATOR);
        String subtype = entity.getSubtype();
        if (COUNTED_SUBTYPE_NAMES.contains(subtype)) {
            return Pair.createPair((Object)((Integer)deepestChild.getFirst() + 1), (Object)((Integer)deepestChild.getSecond()));
        }
        return deepestChild;
    }
}

