/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.maab.db_0140", languages={ELanguage.SIMULINK})
public class SimulinkDisplayOfBasicBlockParametersCheck
extends CheckImplementationBase {
    private static final String INHERITED_VALUE = "-1";
    private static final Set<String> INHERITED_PARAMETERS = Set.of("SystemSampleTime", "SampleTime", "PortDimensions", "Dimensions");
    private static final String FILE_CONTAINING_DEFAULT_PARAMETERS_TO_CHECK = "db_0140-default-parameters-to-check.txt";
    private static final List<String> DEFAULT_BLOCK_TO_TYPE_PARAMETERS_MAP = SimulinkDisplayOfBasicBlockParametersCheck.loadDefaultMapping();
    private static final Logger LOGGER = LogManager.getLogger();
    @CheckOption(name="Default parameters by block type", description="List of block types with corresponding parameter names that must be displayed with block annotations (if configured with non-default values).Expected format of this option is a comma separated list of block type to parameter names mapping.Each mapping contains the block type, a colon, and the parameter names separated by space. Example: \"UnitDelay: InitialCondition SampleTime, DiscreteTransferFcn: SampleTime\". See [Configuring Simulink Block Types](./documentation/howto/improving-analysis-results-for-simulink/#configuring-block-types-in-simulink-analyses).", multilineText=true)
    private List<String> blockTypeToParameters = new ArrayList<String>(DEFAULT_BLOCK_TO_TYPE_PARAMETERS_MAP);
    private static final Map<String, Pattern> OVERRIDE_DEFAULT_PARAMETER_VALUES = CollectionUtils.asMap((Pair[])new Pair[]{Pair.createPair((Object)"Switch: InputSameDT", (Object)Pattern.compile("off")), Pair.createPair((Object)"Switch: Criteria", (Object)Pattern.compile("u2 > Threshold")), Pair.createPair((Object)"Lookup_n-D: RndMeth", (Object)Pattern.compile("Simplest")), Pair.createPair((Object)"DataTypeConversion: RndMeth", (Object)Pattern.compile("Floor")), Pair.createPair((Object)"Delay: InitialCondition", (Object)Pattern.compile("0[.0]*")), Pair.createPair((Object)"Concatenate: Mode", (Object)Pattern.compile("Vector|Multidimensional array")), Pair.createPair((Object)"RandomNumber: SampleTime", (Object)Pattern.compile("0\\.1")), Pair.createPair((Object)"RateLimiter: SampleTimeMode", (Object)Pattern.compile("inherited")), Pair.createPair((Object)"TriggerPort: StatesWhenEnabling", (Object)Pattern.compile("held")), Pair.createPair((Object)"UniformRandomNumber: SampleTime", (Object)Pattern.compile("0\\.1")), Pair.createPair((Object)"VariableTransportDelay: MaximumDelay", (Object)Pattern.compile("10")), Pair.createPair((Object)"VariableTransportDelay: VariableDelayType", (Object)Pattern.compile("Variable transport delay"))});
    private Map<String, Set<String>> parametersToCheck;

    public void initialize() {
        this.parametersToCheck = new HashMap<String, Set<String>>();
        for (String typeDefinition : this.blockTypeToParameters) {
            String[] parts = typeDefinition.split(":", 2);
            if (parts.length > 1) {
                this.parametersToCheck.put(parts[0], Set.of(parts[1].trim().split(" +")));
                continue;
            }
            LOGGER.warn("Could not determine parameter names of block type for input: " + typeDefinition);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> loadDefaultMapping() {
        Class<SimulinkDisplayOfBasicBlockParametersCheck> checkClass = SimulinkDisplayOfBasicBlockParametersCheck.class;
        try (InputStream inputStream = checkClass.getResourceAsStream(FILE_CONTAINING_DEFAULT_PARAMETERS_TO_CHECK);){
            if (inputStream == null) {
                LOGGER.error("Could not read file db_0140-default-parameters-to-check.txt to retrieve default block to parameter names mapping. " + checkClass.getSimpleName() + " won't use them during evaluation.");
                List<String> list2 = Collections.emptyList();
                return list2;
            }
            String content = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
            List<String> list = Arrays.asList(content.split("\n"));
            return list;
        }
        catch (IOException e) {
            LOGGER.error("Could not read file db_0140-default-parameters-to-check.txt to retrieve default block to parameter names mapping. " + checkClass.getSimpleName() + " won't use them during evaluation.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null || this.parametersToCheck.isEmpty()) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if ("Model".equals(block.getType()) || !this.parametersToCheck.containsKey(block.getType())) continue;
            Set<String> expectedParameters = this.parametersToCheck.get(block.getType());
            this.checkBlockDisplaysParameters(block, expectedParameters);
        }
    }

    private void checkBlockDisplaysParameters(SimulinkBlock block, Set<String> expectedParameters) {
        String attributesFormatValue = block.getDeclaredParameter("AttributesFormatString");
        for (String parameter : expectedParameters) {
            if (SimulinkDisplayOfBasicBlockParametersCheck.isDefaultValue(block, parameter) || SimulinkDisplayOfBasicBlockParametersCheck.isInheritedValue(block, parameter) || null != attributesFormatValue && attributesFormatValue.contains("%<" + parameter + ">")) continue;
            this.createFinding(block, parameter);
        }
    }

    private void createFinding(SimulinkBlock block, String parameter) {
        String actualValue = block.getParameter(parameter);
        String defaultValue = SimulinkDisplayOfBasicBlockParametersCheck.getDefaultValueForDisplay(block, parameter);
        String message = "Block uses parameter " + MarkupUtils.formatAsSourceCode((String)parameter) + " but fails to display the nondefault value";
        String recommendedActionMessage = "Display the nondefault value of the parameter " + MarkupUtils.formatAsSourceCode((String)parameter) + " using the Block Annotation pane of the Block Properties dialog box.";
        FindingPropertyList properties = new FindingPropertyList();
        properties.addProperty("Recommended Action", (Object)recommendedActionMessage);
        properties.addProperty("Default value", (Object)defaultValue);
        properties.addProperty("Actual value", (Object)actualValue);
        this.buildFinding(message, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(properties).createAndStore();
    }

    private static String getDefaultValueForDisplay(SimulinkBlock block, String parameter) {
        if (block.isOfType("Concatenate") && parameter.equals("ConcatenateDimension")) {
            return SimulinkDisplayOfBasicBlockParametersCheck.getDefaultDimensionOfConcatenateBlock(block).orElse("");
        }
        Pattern overrideDefault = OVERRIDE_DEFAULT_PARAMETER_VALUES.get(block.getType() + ": " + parameter);
        if (overrideDefault != null) {
            return overrideDefault.pattern();
        }
        return block.getModel().getTypeBlockDefaultParameter(block.getType(), parameter);
    }

    private static boolean isDefaultValue(SimulinkBlock block, String parameter) {
        String actualValue = block.getParameter(parameter);
        if (actualValue == null) {
            return true;
        }
        Pattern overrideDefault = OVERRIDE_DEFAULT_PARAMETER_VALUES.get(block.getType() + ": " + parameter);
        if (overrideDefault != null) {
            return overrideDefault.matcher(actualValue).matches();
        }
        String defaultValue = block.getModel().getTypeBlockDefaultParameter(block.getType(), parameter);
        if (block.isOfType("Concatenate") && parameter.equals("ConcatenateDimension")) {
            Optional<String> defaultDimension = SimulinkDisplayOfBasicBlockParametersCheck.getDefaultDimensionOfConcatenateBlock(block);
            if (defaultDimension.isEmpty()) {
                return true;
            }
            defaultValue = defaultDimension.get();
        }
        return null == defaultValue || defaultValue.equals(actualValue);
    }

    private static Optional<String> getDefaultDimensionOfConcatenateBlock(SimulinkBlock block) {
        String mode = block.getParameter("Mode");
        if ("Vector".equals(mode)) {
            return Optional.of("1");
        }
        if ("Multidimensional array".equals(mode)) {
            return Optional.of("2");
        }
        LOGGER.warn(MarkupUtils.formatAsSourceCode((String)block.buildQualifiedName()) + " is a Concatenate block but does not use \"Vector\" or \"Multidimensional array\" mode. Skipping this block.");
        return Optional.empty();
    }

    private static boolean isInheritedValue(SimulinkBlock block, String parameter) {
        String actualValue = block.getParameter(parameter);
        return INHERITED_PARAMETERS.contains(parameter) && INHERITED_VALUE.equals(actualValue);
    }
}

