/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.HashSet;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkBusUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.maab.na_0004", languages={ELanguage.SIMULINK})
public class SimulinkModelAppearanceSettingsCheck
extends CheckImplementationBase {
    @CheckOption(name="Ignored Block Types", description="Appearance of these block types is not checked. The given block types apply to the 'type' property of Simulink blocks or to the 'SourceType' property (for blocks of type 'Reference') See [Configuring Simulink Block Types](./documentation/howto/improving-analysis-results-for-simulink/#configuring-block-types-in-simulink-analyses).", multilineText=true)
    private Set<String> blocksExcludedFromAppearanceSettingsCheck = new HashSet<String>();

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        if (!model.isLibraryModel()) {
            this.checkModelSettings(model);
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (this.isExcluded(block) || block.isOfType("Model")) continue;
            this.checkBlockSettings(block);
        }
    }

    private void checkModelSettings(SimulinkModel model) {
        this.checkModelViewOptions(model);
        this.checkModelBlockDisplayOptions(model);
        this.checkSignalDisplayOptions(model);
    }

    private void checkModelViewOptions(SimulinkModel model) {
        String value = model.getParameter("ModelBrowserInfo", "Visible");
        this.checkDisplayOption(value, "0", "The Model Browser view is enabled", "Deselect Modeling > Environment > Model Browser.", true);
    }

    private void checkModelBlockDisplayOptions(SimulinkModel model) {
        String libraryLinkDisplayValue = model.getParameter("LibraryLinkDisplay");
        if (!"none".equalsIgnoreCase(libraryLinkDisplayValue) && !"disabled".equalsIgnoreCase(libraryLinkDisplayValue)) {
            this.buildFinding("Library Links are not hidden", this.buildLocation().forElement()).addFindingProperties(FindingPropertyList.singleton((String)"Recommended Action", (String)"Select Debug > Information Overlays > Hide All Links.")).createAndStore();
        }
        this.checkDisplayOption(model.getParameter("ShowLinearizationAnnotations"), "on", "Option Linearization Indicators is disabled", "In context menu of the model, enable \"Other Displays\">\"Signals & Ports\">\"Linearization Indicators\".", true);
        this.checkDisplayOption(model.getParameter("ShowModelReferenceBlockIO"), "off", "Option Ref. Model I/O Mismatch is enabled", "Disable Debug > Information Overlays > Ref. Model I/O Mismatch.", true);
        this.checkDisplayOption(model.getParameter("ShowModelReferenceBlockVersion"), "off", "Option Ref. Model Version is enabled", "Disable Debug > Information Overlays > Ref. Model Version.", true);
        this.checkDisplayOption(model.getParameter("SampleTimeColors"), "off", "Option Sample Time Colors is enabled", "Disable Debug > Information Overlays > Sample Time > Colors.", true);
        this.checkDisplayOption(model.getParameter("ShowDesignRanges"), "off", "Option Signal Data Ranges is enabled", "Disable Debug > Information Overlays > Signals > Signal Data Ranges.", true);
        this.checkDisplayOption(model.getParameter("System.ScreenColor"), "white", "Model Canvas Color is not white", "Click the model background and set Canvas Color to white.", true);
    }

    private void checkSignalDisplayOptions(SimulinkModel model) {
        this.checkDisplayOption(model.getParameter("ShowPortDataTypes"), "off", "Options Alias Data Types and/or Base Data Types are enabled", "In Debug > Information Overlays, disable Base Data Types and Alias Data Types.", true);
        this.checkDisplayOption(model.getParameter("ShowStorageClass"), "off", "Option Storage Class is enabled", "In context menu of the model, disable \"Other Displays\">\"Signals & Ports\">\"Storage Class\".", true);
        this.checkDisplayOption(model.getParameter("ShowLineDimensions"), "off", "Option Signal Dimensions is enabled", "In Debug > Information Overlays, disable Signal Dimensions.", true);
        this.checkDisplayOption(model.getParameter("ShowTestPointIcons"), "on", "Option for Log & Testpoint is disabled", "Enable TestPoint in Debug > Information Overlays.", true);
        this.checkDisplayOption(model.getParameter("ShowViewerIcons"), "on", "Option for Viewers is disabled", "Enable Logging & Viewers in Debug > Information Overlays.", true);
        this.checkDisplayOption(model.getParameter("WideLines"), "on", "Option Nonscalar Signals is disabled", "Enable Debug > Information Overlays > Nonscalar Signals.", false);
    }

    private void checkDisplayOption(String modelParameterValue, String desiredValue, String findingMessage, String recommendedAction, boolean expectedValueIsFactoryDefault) {
        if (expectedValueIsFactoryDefault && modelParameterValue == null) {
            return;
        }
        if (!desiredValue.equalsIgnoreCase(modelParameterValue)) {
            this.buildFinding(findingMessage, this.buildLocation().forElement()).addFindingProperties(FindingPropertyList.singleton((String)"Recommended Action", (String)recommendedAction)).createAndStore();
        }
    }

    private void checkBlockSettings(SimulinkBlock block) {
        if (SimulinkBusUtils.isBusElementPort((SimulinkBlock)block)) {
            this.checkBlockSettings(block, "black", "black");
        } else {
            this.checkBlockSettings(block, "black", "white");
        }
        if (block.isOfType("SubSystem") && SimulinkModelAppearanceSettingsCheck.hasValueOtherThan(block.getSystemSectionParameter("ScreenColor"), "white")) {
            this.buildFinding("Subsystem uses non-standard Canvas Color", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(FindingPropertyList.singleton((String)"Recommended Action", (String)"Open the subsystem and set Canvas Color to white.")).createAndStore();
        }
    }

    private void checkBlockSettings(SimulinkBlock block, String foregroundColor, String backgroundColor) {
        if (SimulinkModelAppearanceSettingsCheck.hasValueOtherThan(block.getParameter("ForegroundColor"), foregroundColor) || SimulinkModelAppearanceSettingsCheck.hasValueOtherThan(block.getParameter("BackgroundColor"), backgroundColor) || SimulinkModelAppearanceSettingsCheck.hasValueOtherThan(block.getParameter("DropShadow"), "off")) {
            this.buildFinding("Block uses non-standard appearance settings", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(FindingPropertyList.singleton((String)"Recommended Action", (String)("Click the block and select Format. Set Background to " + backgroundColor + ", Foreground to " + foregroundColor + ", and deselect Shadow."))).createAndStore();
        }
    }

    private static boolean hasValueOtherThan(String actualParameterValue, String expectedValue) {
        return actualParameterValue != null && !expectedValue.equalsIgnoreCase(actualParameterValue);
    }

    private boolean isExcluded(SimulinkBlock block) {
        String blockType = SimulinkUtils.getTypeOrSourceType((SimulinkBlock)block);
        return this.blocksExcludedFromAppearanceSettingsCheck.contains(blockType);
    }
}

