/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.maab.jm_0001", languages={ELanguage.SIMULINK})
public class SimulinkProhibitedStandardBlocksCheck
extends CheckImplementationBase {
    @CheckOption(name="prohibited block types", description="The block types that shall not be used. The given types apply to the 'type' property of simulink blocks or to the 'SourceType' property (for blocks of type Reference) with 'TimeDomain' parameter is not set to Discrete-time. See [Configuring Simulink Block Types](./documentation/howto/improving-analysis-results-for-simulink/#configuring-block-types-in-simulink-analyses).", multilineText=true)
    private List<String> prohibitedBlockTypes = Arrays.asList("AlgebraicConstraint", "Band-Limited White Noise.", "Checks_Gradient", "Checks_Resolution", "Checks_SGap", "Checks_SMax", "Checks_SMin", "Checks_SRange", "Clock", "ComplexToMagnitudeAngle", "ComplexToRealImag", "Counter Free-Running", "Counter Limited", "Demux", "Derivative", "DescriptorStateSpace", "Difference", "DigitalClock", "DiscretePulseGenerator", "Environment Controller", "EntityTransportDelay", "FirstOrderHold", "FromWorkspace", "GotoTagVisibility", "HitCross", "HitCross", "InitialCondition", "Integrator", "Integrator", "MATLABFcn", "MagnitudeAngleToComplex", "ManualSwitch", "ManualSwitch", "PID 1dof", "PID 2dof", "Polyval", "Probe", "Ramp", "RandomNumber", "RealImagToComplex", "SecondOrderIntegrator", "SecondOrderIntegrator", "SignalEditor", "SignalGenerator", "Sin", "Slider Gain", "StateSpace", "Step", "Stop", "Timed Linearization", "TransferFcn", "TransportDelay", "Triggered Linearization", "UniformRandomNumber", "VariableTransportDelay", "VariableTransportDelay", "WaveformGenerator", "ZeroPole", "chirp");
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Replace with equivalent blocks discretized in the s-domain (use the Discretizing library)");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        HashSet<String> prohibitedBlockTypesSet = new HashSet<String>(this.prohibitedBlockTypes);
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            String typeOrSourceType;
            if (Objects.equals(block.getParameter("TimeDomain"), "Discrete-time") || (typeOrSourceType = SimulinkUtils.getTypeOrSourceType((SimulinkBlock)block)) == null || !prohibitedBlockTypesSet.contains(typeOrSourceType)) continue;
            this.buildFinding("Don't use prohibited block type " + typeOrSourceType, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

