/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.HashSet;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.na_0010", languages={ELanguage.SIMULINK})
public class SimulinkUsageBusSignalsCheck
extends CheckImplementationBase {
    private static final String MESSAGE_MUX_DIFFERENT_TYPES = "Inputs to Mux block have differing types: %s";
    private static final FindingPropertyList RECOMMENDED_ACTION_MUX_TYPES = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change the types of the inputs such that they match");
    private static final String MESSAGE_MUX_DEMUX_BUS_INPUT = "Inputs to Mux or Demux blocks shall not be bus signals";
    private static final FindingPropertyList RECOMMENDED_ACTION_MUX_DEMUX_BUS = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change the inputs to vectors or scalars");
    private static final String MESSAGE_CONFIGURATION_PARAMETER = "Vector signals are converted automatically into bus signals";
    private static final FindingPropertyList RECOMMENDED_ACTION_CONFIGURATION_PARAMETER = FindingPropertyList.singleton((String)"Recommended Action", (String)String.format("Set the model configuration parameter %s to %s.", MarkupUtils.formatAsSourceCode((String)"Bus signal treated as vector"), MarkupUtils.formatAsSourceCode((String)"error")));
    private static final String MESSAGE_BUS_INPUT_NOT_SUPPORTED = "Bus input signal not supported by block";
    private static final FindingPropertyList RECOMMENDED_ACTION_NOT_SUPPORTED = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider remodeling to use buses only with bus-supported blocks");
    private static final Set<String> BUS_INPUT_SUPPORTED_BLOCKS = Set.of("Assignment", "BusAssignment", "BusCreator", "BusSelector", "DataStoreWrite", "Delay", "Interpolation_n-D", "ManualSwitch", "Memory", "Merge", "MultiPortSwitch", "RateTransition", "SignalConversion", "SignalSpecification", "Switch", "ToFile", "ToWorkspace", "UnitDelay", "Concatenate", "ZeroOrderHold", "Demux", "EnablePort", "From", "Goto", "GotoTagVisibility", "Ground", "Inport", "Mux", "Outport", "Selector", "SubSystem", "Terminator", "TriggerPort");
    @CheckOption(name="Custom block types which support bus types as input", description="This option allows to specify block types which support bus types as input. The given block types apply to the 'type' property of Simulink blocks or to the 'SourceType' property (for blocks of type 'Reference') See [Configuring Simulink Block Types](./documentation/howto/improving-analysis-results-for-simulink/#configuring-block-types-in-simulink-analyses).", multilineText=true)
    private Set<String> customBlocksWithBusInputSupport = new HashSet<String>();

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        SimulinkResolvedDataTypes resolvedDataTypes = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile().orElse(null);
        if (resolvedDataTypes == null) {
            return;
        }
        if (!model.isLibraryModel()) {
            this.checkModelParameter(model);
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (block.getType() == null) continue;
            this.checkBusInputSignalSupport(block, resolvedDataTypes);
            this.checkMuxAndDemux(block, resolvedDataTypes);
        }
    }

    private void checkModelParameter(SimulinkModel model) {
        if (!"ErrorOnBusTreatedAsVector".equals(model.getParameter("StrictBusMsg"))) {
            this.buildFinding(MESSAGE_CONFIGURATION_PARAMETER, this.buildLocation().forElement()).addFindingProperties(RECOMMENDED_ACTION_CONFIGURATION_PARAMETER).createAndStore();
        }
    }

    private void checkBusInputSignalSupport(SimulinkBlock block, SimulinkResolvedDataTypes resolvedDataTypes) {
        for (SimulinkInPort inport : block.getInPorts()) {
            String portIndex = inport.getIndex();
            String dataType = resolvedDataTypes.getInputDataType(block, portIndex);
            if (dataType == null || !dataType.startsWith("Bus") || this.blockSupportsBusInput(block, portIndex)) continue;
            this.buildFinding(MESSAGE_BUS_INPUT_NOT_SUPPORTED, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_NOT_SUPPORTED).createAndStore();
            return;
        }
    }

    private boolean blockSupportsBusInput(SimulinkBlock block, String portIndex) {
        String blockType = SimulinkUtils.getTypeOrSourceType((SimulinkBlock)block);
        if (BUS_INPUT_SUPPORTED_BLOCKS.contains(blockType) || this.customBlocksWithBusInputSupport.contains(blockType)) {
            return true;
        }
        if ("Reference".equals(block.getType())) {
            String sourceBlock = block.getSourceBlockName();
            return SimulinkUtils.isSubsystem((SimulinkBlock)block) && sourceBlock != null && sourceBlock.contains("/") && !sourceBlock.startsWith("simulink/");
        }
        if ("ModelReference".equals(block.getType())) {
            Object parameterName = "InputPortBusObjects.port0";
            if (StringUtils.isInteger((String)portIndex)) {
                int portNumber = Integer.parseInt(portIndex) - 1;
                parameterName = "InputPortBusObjects.port" + portNumber;
            }
            return block.getParameter((String)parameterName) != null && !block.getParameter((String)parameterName).isEmpty();
        }
        return false;
    }

    private void checkMuxAndDemux(SimulinkBlock block, SimulinkResolvedDataTypes resolvedDataTypes) {
        if (block.isOfType("Mux") || block.isOfType("Demux")) {
            Set inputTypes = resolvedDataTypes.getInputDataTypes(block);
            if (inputTypes.size() > 1 && !inputTypes.contains("Unknown") && !inputTypes.contains("NOT_CONNECTED")) {
                String findingMessage = String.format(MESSAGE_MUX_DIFFERENT_TYPES, String.join((CharSequence)", ", inputTypes));
                this.buildFinding(findingMessage, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_MUX_TYPES).createAndStore();
            }
            if (inputTypes.stream().anyMatch(type -> type.startsWith("Bus"))) {
                this.buildFinding(MESSAGE_MUX_DEMUX_BUS_INPUT, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_MUX_DEMUX_BUS).createAndStore();
            }
        }
    }
}

