/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink.phases;

import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.IExtractedValue;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class SimulinkModelUsedIdentifiersPhase
implements IGlobalExtractionPhase<ModelIdentifiersValue, ModelIdentifiers> {
    public List<ModelIdentifiersValue> extract(ITokenElementContext fileContext) {
        SimulinkModel model = fileContext.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return Collections.emptyList();
        }
        Set<String> usedIdentifiers = SimulinkModelUsedIdentifiersPhase.collectUsedIdentifiers(model);
        Set definedIdentifiers = model.modelWorkspace.getEntryNames();
        return Collections.singletonList(new ModelIdentifiersValue(fileContext.getUniformPath(), new ModelIdentifiers(usedIdentifiers, definedIdentifiers)));
    }

    public ModelIdentifiersValue createValue(String uniformPath, String value, ModelIdentifiers additionalInformation) {
        return new ModelIdentifiersValue(uniformPath, additionalInformation);
    }

    public boolean needsAccessByValue() {
        return false;
    }

    public EnumSet<ELanguage> getLanguages() {
        return EnumSet.of(ELanguage.SIMULINK);
    }

    public EnumSet<ECheckParameter> getRequiredContextParameters() {
        return EnumSet.of(ECheckParameter.RUN_ON_HIDDEN_ELEMENTS);
    }

    private static Set<String> collectUsedIdentifiers(SimulinkModel model) {
        HashSet<String> possibleIdentifiers = new HashSet<String>();
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            possibleIdentifiers.addAll(SimulinkModelUsedIdentifiersPhase.collectBlockParameterIdentifiers(block));
            possibleIdentifiers.addAll(SimulinkModelUsedIdentifiersPhase.collectInOutPortParameterIdentifiers(block));
            possibleIdentifiers.addAll(SimulinkModelUsedIdentifiersPhase.collectLineParameterIdentifiers(block));
        }
        return possibleIdentifiers;
    }

    private static Set<String> collectBlockParameterIdentifiers(SimulinkBlock block) {
        HashSet<String> possibleIdentifiers = new HashSet<String>();
        for (String parameterKey : block.getParameterNames()) {
            if (SimulinkModelUsedIdentifiersPhase.shouldIgnoreBlockParameter(block, parameterKey)) continue;
            String parameterValue = block.getParameter(parameterKey);
            Set<String> possibleIdentifiersForParameter = SimulinkModelUsedIdentifiersPhase.getPossibleIdentifiersFromParameterValue(parameterValue);
            possibleIdentifiers.addAll(possibleIdentifiersForParameter);
        }
        return possibleIdentifiers;
    }

    private static boolean shouldIgnoreBlockParameter(SimulinkBlock block, String parameterKey) {
        if (parameterKey.equals("Name")) {
            return true;
        }
        if (block.isOfType("Reference")) {
            return parameterKey.equals("SourceBlock");
        }
        if (block.isOfType("SubSystem")) {
            return parameterKey.equals("ReferencedSubsystem");
        }
        return false;
    }

    private static Set<String> collectInOutPortParameterIdentifiers(SimulinkBlock block) {
        HashSet<String> possibleIdentifiers = new HashSet<String>();
        Set inAndOutPorts = Stream.concat(block.getInPorts().stream(), block.getOutPorts().stream()).collect(Collectors.toSet());
        for (SimulinkPortBase inOutPort : inAndOutPorts) {
            for (String parameterKey : inOutPort.getParameterNames()) {
                String parameterValue = inOutPort.getParameter(parameterKey);
                Set<String> possibleIdentifiersForParameter = SimulinkModelUsedIdentifiersPhase.getPossibleIdentifiersFromParameterValue(parameterValue);
                possibleIdentifiers.addAll(possibleIdentifiersForParameter);
            }
        }
        return possibleIdentifiers;
    }

    private static Set<String> collectLineParameterIdentifiers(SimulinkBlock block) {
        HashSet<String> possibleIdentifiers = new HashSet<String>();
        for (SimulinkLine line : block.getContainedLines()) {
            for (String parameterKey : line.getParameterNames()) {
                String parameterValue = line.getParameter(parameterKey);
                Set<String> possibleIdentifiersForParameter = SimulinkModelUsedIdentifiersPhase.getPossibleIdentifiersFromParameterValue(parameterValue);
                possibleIdentifiers.addAll(possibleIdentifiersForParameter);
            }
        }
        return possibleIdentifiers;
    }

    public static Set<String> getPossibleIdentifiersFromParameterValue(String parameterValue) {
        HashSet<String> possibleIdentifiers = new HashSet<String>();
        if (parameterValue == null || parameterValue.isEmpty()) {
            return possibleIdentifiers;
        }
        possibleIdentifiers.add(parameterValue);
        List tokens = ScannerUtils.getTokens((String)parameterValue, (ELanguage)ELanguage.MATLAB, (String)parameterValue);
        Set identifier = tokens.stream().filter(token -> token.getType() == ETokenType.IDENTIFIER).map(IToken::getText).collect(Collectors.toSet());
        possibleIdentifiers.addAll(identifier);
        return possibleIdentifiers;
    }

    @IndexValueClass
    public static class ModelIdentifiersValue
    implements IExtractedValue<ModelIdentifiers> {
        private final String uniformPath;
        private final ModelIdentifiers modelIdentifiers;

        private ModelIdentifiersValue(String uniformPath, ModelIdentifiers modelIdentifiers) {
            this.uniformPath = uniformPath;
            this.modelIdentifiers = modelIdentifiers;
        }

        public String getUniformPath() {
            return this.uniformPath;
        }

        public String getValue() {
            return "";
        }

        public ModelIdentifiers getAdditionalInformation() {
            return this.modelIdentifiers;
        }
    }

    @IndexValueClass
    public static class ModelIdentifiers
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Set<String> usedIdentifiers;
        private final Set<String> definedIdentifiers;

        private ModelIdentifiers(Set<String> usedIdentifiers, Set<String> definedIdentifiers) {
            this.usedIdentifiers = new HashSet<String>(usedIdentifiers);
            this.definedIdentifiers = new HashSet<String>(definedIdentifiers);
        }

        public Set<String> getUsedIdentifiers() {
            return this.usedIdentifiers;
        }

        public Set<String> getDefinedIdentifiers() {
            return this.definedIdentifiers;
        }
    }
}

