/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.HashSet;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowData;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;

@Check(id="cqse.jmaab.db_0125", languages={ELanguage.SIMULINK})
public class SimulinkLocalDataOnMachineLevelCheck
extends CheckImplementationBase {
    @CheckOption(name="Check for Stateflow data with Local scope at machine level", description="If set, Simulink models are checked for Stateflow data at machine level declared with Scope as Local.")
    private boolean checkStateFlowDataWithLocalScope = true;
    @CheckOption(name="Check for Stateflow data with Parameter scope at machine level", description="If set, Simulink models are checked for Stateflow data at machine level declared with Scope as Parameter.")
    private boolean checkStateFlowDataWithParameterScope = true;
    @CheckOption(name="Check for Stateflow data with Constant scope at machine level", description="If set, Simulink models are checked for Stateflow data at machine level declared with Scope as Constant.")
    private boolean checkStateFlowDataWithConstantScope = true;
    @CheckOption(name="Check for duplicate Stateflow data names with Local scope at machine level", description="If set, Simulink models are checked for duplicate Stateflow data at machine level declared with Scope as Local.")
    private boolean checkDuplicateStateFlowDataWithLocalScope = true;
    private static final String LOCAL_DATA_SCOPE = "LOCAL_DATA";
    private static final String CONSTANT_DATA_SCOPE = "CONSTANT_DATA";
    private static final String PARAMETER_DATA_SCOPE = "PARAMETER_DATA";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Search in Model Explorer for data objects whose local, constant or parameter scope is defined at the machine level and redefine it at a lower level such as the chart level or below.");
    private static final FindingPropertyList RECOMMENDED_ACTION_DUPLICATE_LOCAL_DATA = FindingPropertyList.singleton((String)"Recommended Action", (String)"Rename or remove one of the duplicate local data objects");

    public void execute() {
        SimulinkModel currentModel = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (currentModel == null) {
            return;
        }
        StateflowMachine machine = currentModel.getStateflowMachine();
        if (machine == null) {
            return;
        }
        UnmodifiableSet dataObjects = machine.getData();
        for (StateflowData dataObject : dataObjects) {
            String scope = dataObject.getDeclaredParameter("scope");
            if (!(this.checkStateFlowDataWithLocalScope && SimulinkLocalDataOnMachineLevelCheck.isLocalScope(scope) || this.checkStateFlowDataWithConstantScope && SimulinkLocalDataOnMachineLevelCheck.isConstantScope(scope)) && (!this.checkStateFlowDataWithParameterScope || !SimulinkLocalDataOnMachineLevelCheck.isParameterScope(scope))) continue;
            this.buildFinding("The data object " + MarkupUtils.formatAsSourceCode((String)dataObject.getName()) + " shall not exist at the machine level because it has a local scope", (ElementLocation)this.buildLocation().forSimulinkBlock((SimulinkBlock)currentModel)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
        if (this.checkDuplicateStateFlowDataWithLocalScope) {
            machine.getCharts().forEach(this::checkForDuplicateDataInChart);
        }
    }

    private void checkForDuplicateDataInChart(StateflowChart stateflowChart) {
        HashSet<String> dataWithLocalScope = new HashSet<String>();
        for (StateflowData stateflowData : stateflowChart.getData()) {
            String scope = stateflowData.getDeclaredParameter("scope");
            if (!SimulinkLocalDataOnMachineLevelCheck.isLocalScope(scope)) continue;
            dataWithLocalScope.add(stateflowData.getName());
        }
        for (StateflowNodeBase stateflowNode : stateflowChart.getNodes()) {
            for (StateflowData stateflowData : stateflowNode.getData()) {
                String scope = stateflowData.getDeclaredParameter("scope");
                String dataObjectName = stateflowData.getName();
                if (!SimulinkLocalDataOnMachineLevelCheck.isLocalScope(scope) || !dataWithLocalScope.contains(dataObjectName)) continue;
                this.buildFinding("Data object " + MarkupUtils.formatAsSourceCode((String)dataObjectName) + " duplicates another data object in the parent Stateflow block", (ElementLocation)this.buildLocation().forStateflowNode(stateflowNode)).addFindingProperties(RECOMMENDED_ACTION_DUPLICATE_LOCAL_DATA).createAndStore();
            }
        }
    }

    private static boolean isLocalScope(String scope) {
        return !StringUtils.isEmpty((String)scope) && LOCAL_DATA_SCOPE.equals(scope);
    }

    private static boolean isConstantScope(String scope) {
        return !StringUtils.isEmpty((String)scope) && CONSTANT_DATA_SCOPE.equals(scope);
    }

    private static boolean isParameterScope(String scope) {
        return !StringUtils.isEmpty((String)scope) && PARAMETER_DATA_SCOPE.equals(scope);
    }
}

