/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.simulink.phases.SimulinkDataDictionaryLoadingPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReferencesPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelBlockIdListingPhase;
import eu.cqse.check.simulink.simulink.utils.ExternalConfigSetUtils;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.builder.SimulinkConfigSet;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowTruthTable;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.hism.hisf_0011", languages={ELanguage.SIMULINK}, phases={SimulinkDataDictionaryLoadingPhase.class, SimulinkFileReferencesPhase.class, SimulinkModelBlockIdListingPhase.class})
public class SimulinkStateflowDebuggingOptionsCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION_WRAP_ON_OVERFLOW = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set the configuration parameter \"Wrap on overflow\" to \"error\"");
    private static final FindingPropertyList RECOMMENDED_ACTION_SIMULATION_RANGE_CHECKING = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set the configuration parameter \"Simulation range checking\" to \"error\"");
    private static final FindingPropertyList RECOMMENDED_ACTION_UNDERSPECIFICATION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set the parameter \"Underspecification\" to \"error\"");
    private static final FindingPropertyList RECOMMENDED_ACTION_OVERSPECIFICATION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set the parameter \"Overspecification\" to \"error\"");
    private static final FindingPropertyList RECOMMENDED_ACTION_DETECT_CYCLES = FindingPropertyList.singleton((String)"Recommended Action", (String)"Enable the \"Diagnostics &gt; Detect Cyclical Behavior\" option in the stateflow chart view");

    public void execute() {
        StateflowMachine stateflowMachine;
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null || model.isLibraryModel() || model.isSubsystem()) {
            return;
        }
        SimulinkConfigSet externalConfigSet = ExternalConfigSetUtils.getExternalConfigSet(model, this.context).orElse(null);
        if (ExternalConfigSetUtils.getParameter(model, externalConfigSet, "IntegerOverflowMsg").filter("Error"::equalsIgnoreCase).isEmpty()) {
            this.buildFinding("The configuration parameter \"Wrap on overflow\" is not set to \"error\"", this.buildLocation().forElement()).addFindingProperties(RECOMMENDED_ACTION_WRAP_ON_OVERFLOW).createAndStore();
        }
        if (ExternalConfigSetUtils.getParameter(model, externalConfigSet, "SignalRangeChecking").filter("Error"::equalsIgnoreCase).isEmpty()) {
            this.buildFinding("The configuration parameter \"Simulation range checking\" is not set to \"error\"", this.buildLocation().forElement()).addFindingProperties(RECOMMENDED_ACTION_SIMULATION_RANGE_CHECKING).createAndStore();
        }
        if ((stateflowMachine = model.getStateflowMachine()) != null && !SimulinkStateflowDebuggingOptionsCheck.isCycleDetectionOn(stateflowMachine)) {
            this.buildFinding("The \"Detect Cyclical Behavior\" option is disabled", this.buildLocation().forElement()).addFindingProperties(RECOMMENDED_ACTION_DETECT_CYCLES).createAndStore();
        }
        this.checkTruthTableDiagnostics(model);
    }

    private void checkTruthTableDiagnostics(SimulinkModel model) {
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!(block instanceof StateflowBlock)) continue;
            StateflowBlock stateflowBlock = (StateflowBlock)block;
            for (StateflowNodeBase node : StateflowUtils.listNodesRecursively((StateflowChart)stateflowBlock.getChart(), (boolean)false)) {
                if (!(node instanceof StateflowTruthTable)) continue;
                this.checkTruthTableParameter(node, "truthTable.diagnostic.overSpecification", "The parameter \"Overspecification\" of truth table is not set to \"error\"", RECOMMENDED_ACTION_OVERSPECIFICATION);
                this.checkTruthTableParameter(node, "truthTable.diagnostic.underSpecification", "The parameter \"Underspecification\" of truth table is not set to \"error\"", RECOMMENDED_ACTION_UNDERSPECIFICATION);
            }
        }
    }

    private void checkTruthTableParameter(StateflowNodeBase node, String parameterName, String findingMessage, FindingPropertyList recommendedAction) {
        String overSpecification = node.getParameter(parameterName);
        if (overSpecification != null && !overSpecification.equals("0")) {
            this.buildFinding(findingMessage, (ElementLocation)this.buildLocation().forStateflowNode(node)).addFindingProperties(recommendedAction).createAndStore();
        }
    }

    private static boolean isCycleDetectionOn(StateflowMachine stateflowMachine) {
        String runTimeCheckValue = stateflowMachine.getParameter("debug.runTimeCheck");
        if (runTimeCheckValue == null || runTimeCheckValue.length() < 6) {
            return true;
        }
        return runTimeCheckValue.charAt(6) == '1';
    }
}

