/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.List;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.maab.jm_0011", languages={ELanguage.SIMULINK})
public class SimulinkStateflowPointerCheck
extends CheckImplementationBase {
    private static final String FINDINGS_MESSAGE = "Use of pointer operation in Stateflow chart";
    private static final FindingPropertyList RECOMMENDED_ACTION_MODIFY = FindingPropertyList.singleton((String)"Recommended Action", (String)"Modify the chart to remove the dependency on pointer operations.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        StateflowMachine machine = model.getStateflowMachine();
        if (machine == null) {
            return;
        }
        for (StateflowChart chart : machine.getCharts(false)) {
            if (!StateflowUtils.hasActionLanguageC((StateflowChart)chart)) continue;
            this.checkElementsOfStateflowChart(chart);
        }
    }

    private void checkElementsOfStateflowChart(StateflowChart chart) {
        for (StateflowNodeBase node : StateflowUtils.listNodesRecursively((StateflowChart)chart, (boolean)false)) {
            if (!this.checkPointerAndAddressOfUsage(node.getParameter("labelString"))) continue;
            this.buildFinding(FINDINGS_MESSAGE, (ElementLocation)this.buildLocation().forStateflowNode(node)).addFindingProperties(RECOMMENDED_ACTION_MODIFY).createAndStore();
        }
        for (StateflowTransition transition : StateflowUtils.getAllTransitions((StateflowChart)chart, (boolean)false)) {
            if (!this.checkPointerAndAddressOfUsage(transition.getLabel())) continue;
            this.buildFinding(FINDINGS_MESSAGE, (ElementLocation)this.buildLocation().forStateflowTransition(transition)).addFindingProperties(RECOMMENDED_ACTION_MODIFY).createAndStore();
        }
    }

    private boolean checkPointerAndAddressOfUsage(String cFragment) {
        if (cFragment == null) {
            return false;
        }
        List tokens = ScannerUtils.getTokens((String)cFragment, (ELanguage)ELanguage.CPP, (String)this.context.getUniformPath());
        return LanguageFeatureParser.CPP.containsPointerOperator(tokens) || LanguageFeatureParser.CPP.containsAddressOfUsage(tokens);
    }
}

