/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.util.simulink.StateflowCheckUtils;
import eu.cqse.check.util.simulink.StateflowStateAction;
import eu.cqse.check.util.simulink.StateflowTransitionParts;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowJunction;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.jc_0741", languages={ELanguage.SIMULINK})
public class SimulinkStateflowUpdateChartTransitionChartsCheck
extends CheckImplementationBase {
    private static final Set<String> DURING_ACTIONS = Set.of("during", "du");
    private static final String FINDING_MESSAGE = "Variable %s is assigned in a during action and used in the condition of an outgoing transition";
    private static final FindingPropertyList RECOMMENDED_ACTION_MODIFY = FindingPropertyList.singleton((String)"Recommended Action", (String)"Either remove the variable from the condition action or from the during state action.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!(block instanceof StateflowBlock)) continue;
            for (StateflowNodeBase node : StateflowUtils.listNodesRecursively((StateflowChart)((StateflowBlock)block).getChart(), (boolean)false)) {
                if (!(node instanceof StateflowState)) continue;
                this.checkState((StateflowState)node);
            }
        }
    }

    private void checkState(StateflowState state) {
        List stateActions = StateflowCheckUtils.splitStateActionsFromStateLabel((StateflowState)state);
        HashSet<String> variables = new HashSet<String>();
        for (StateflowStateAction action : stateActions) {
            if (action.actionDeclaration.stream().noneMatch(actionToken -> DURING_ACTIONS.contains(actionToken.getText()))) continue;
            List actionCode = action.actionCode;
            for (int i = 0; i < actionCode.size(); ++i) {
                IToken token = (IToken)actionCode.get(i);
                if (!token.getType().isIdentifier() || i + 1 >= actionCode.size() || ETokenType.EQ != ((IToken)actionCode.get(i + 1)).getType()) continue;
                variables.add(token.getText());
            }
        }
        if (!variables.isEmpty()) {
            this.usesVariableInOutgoingTransitionCondition((StateflowNodeBase)state, variables, this.buildLocation().forStateflowNode((StateflowNodeBase)state));
        }
    }

    private void usesVariableInOutgoingTransitionCondition(StateflowNodeBase node, Set<String> stateVariables, QualifiedNameLocation findingLocation) {
        for (StateflowTransition transition : node.getOutTransitions()) {
            StateflowTransitionParts transitionParts = StateflowCheckUtils.splitTransitionLabel((StateflowTransition)transition);
            for (IToken token : transitionParts.condition) {
                if (!token.getType().isIdentifier() || !stateVariables.contains(token.getText())) continue;
                this.context.buildFinding(String.format(FINDING_MESSAGE, token.getText()), (ElementLocation)findingLocation).addFindingProperties(RECOMMENDED_ACTION_MODIFY).createAndStore();
                return;
            }
            if (!(transition.getDst() instanceof StateflowJunction)) continue;
            this.usesVariableInOutgoingTransitionCondition(transition.getDst(), stateVariables, findingLocation);
        }
    }
}

