/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collection;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowJunction;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.jc_0797", languages={ELanguage.SIMULINK})
public class SimulinkUnconnectedStateflowObjectsCheck
extends CheckImplementationBase {
    @CheckOption(name="Disallow unconnected transitions (jc_0797_a)", description="If set, transitions without any end states and end junctions are disallowed.")
    private boolean disallowUnconnectedTransitions = true;
    @CheckOption(name="Disallow unconnected states and junctions (jc_0797_b)", description="If set, states and junctions without incoming transitions are disallowed.")
    private boolean disallowUnconnectedStatesAndJunctions = true;
    private static final FindingPropertyList RECOMMENDED_ACTION_UNCONNECTED_TRANSITION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider adding an end state or end junction to the transition.");
    private static final FindingPropertyList RECOMMENDED_ACTION_UNCONNECTED_STATE = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider connecting the state by adding incoming transitions.");
    private static final FindingPropertyList RECOMMENDED_ACTION_UNCONNECTED_JUNCTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider connecting the junction by adding incoming transitions");

    public void execute() {
        if (!this.disallowUnconnectedTransitions && !this.disallowUnconnectedStatesAndJunctions) {
            return;
        }
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null || model.getStateflowMachine() == null) {
            return;
        }
        for (StateflowChart chart : model.getStateflowMachine().getCharts()) {
            StateflowUtils.listNodesRecursively((StateflowChart)chart, (boolean)false).forEach(this::checkStateflowNode);
        }
    }

    private void checkStateflowNode(StateflowNodeBase node) {
        if (this.disallowUnconnectedStatesAndJunctions && node.getInTransitions().isEmpty()) {
            if (SimulinkUnconnectedStateflowObjectsCheck.isStateflowNodeWithExclusiveDecomposition(node)) {
                this.buildFinding("Stateflow state is unconnected", (ElementLocation)this.buildLocation().forStateflowNode(node)).addFindingProperties(RECOMMENDED_ACTION_UNCONNECTED_STATE).createAndStore();
            } else if (node instanceof StateflowJunction) {
                this.buildFinding("Stateflow junction is unconnected", (ElementLocation)this.buildLocation().forStateflowNode(node)).addFindingProperties(RECOMMENDED_ACTION_UNCONNECTED_JUNCTION).createAndStore();
            }
        }
        if (this.disallowUnconnectedTransitions) {
            this.checkStateflowTransitions((Collection<StateflowTransition>)node.getOutTransitions());
        }
    }

    private static boolean isStateflowNodeWithExclusiveDecomposition(StateflowNodeBase node) {
        if (!(node instanceof StateflowState)) {
            return false;
        }
        StateflowState stateNode = (StateflowState)node;
        if ("OR_STATE".equals(stateNode.getParameter("type")) && !stateNode.isAtomicSubChart() && !stateNode.isSubChart()) {
            return stateNode.getNodes().stream().noneMatch(someNode -> "SUBCHART".equals(someNode.getParameter("superState")));
        }
        return false;
    }

    private void checkStateflowTransitions(Collection<StateflowTransition> transitions) {
        for (StateflowTransition transition : transitions) {
            if (transition.getDst() != null || StateflowUtils.isCommented((ParameterizedElement)transition)) continue;
            this.buildFinding("Stateflow transition is unconnected", (ElementLocation)this.buildLocation().forStateflowTransition(transition)).addFindingProperties(RECOMMENDED_ACTION_UNCONNECTED_TRANSITION).createAndStore();
        }
    }
}

