/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.util.simulink.StateflowCheckUtils;
import eu.cqse.check.util.simulink.StateflowStateAction;
import eu.cqse.check.util.simulink.StateflowTransitionParts;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.na_0001", languages={ELanguage.SIMULINK})
public class SimulinkUsageOfStateflowOperatorsCheck
extends CheckImplementationBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String SUB_ID_A_FINDING_MESSAGE = "Operator `&`, `|` or `^` used for non-bit operation: %s";
    private static final FindingPropertyList SUB_ID_A_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider using the operators &, |, and ^  only for bit operations.");
    private static final String SUB_ID_B_FINDING_MESSAGE = "Disallowed operator for inequality operation: %s";
    private static final FindingPropertyList SUB_ID_B_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider using a consistent operator for inequality operations.");
    private static final String SUB_ID_C_FINDING_MESSAGE = "Operator `~` used for negation: %s";
    private static final FindingPropertyList SUB_ID_C_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider using the operator `!` for negations.");
    private static final int MINIMUM_NEGATION_STATEMENT_LENGTH = 2;
    private static final Map<String, ETokenType[]> NOTEQ_OPERATIONS = Map.of("~=", new ETokenType[]{ETokenType.COMP, ETokenType.EQ}, "!=", new ETokenType[]{ETokenType.NOTEQ}, "<>", new ETokenType[]{ETokenType.LT, ETokenType.GT});
    private static final ETokenType[] BINARY_BIT_OPERATIONS = new ETokenType[]{ETokenType.AND, ETokenType.OR, ETokenType.XOR};
    private static final ETokenType ILLEGAL_NEGATION_OPERATION = ETokenType.COMP;
    @CheckOption(name="Sub ID a: Check usage of bitwise operations", description="Check that `&`, `|`, `^` are only used as bit operations.")
    private boolean checkBitOperators = true;
    @CheckOption(name="Sub ID b: Check consistent usage of inequality operators", description="Check that a consistent operator is used for inequality operations.")
    private boolean checkInequalityOperators = true;
    @CheckOption(name="Preferred inequality operator", description="Can be either of `~=`, `!=`, `<>`.")
    private String selectedNotEqOperatorOption = "!=";
    @CheckOption(name="Sub ID c: Check consistent usage of negation operator", description="Check that `!` is used consistently as logical negation operator.")
    private boolean checkNegationOperators = true;

    public void execute() throws CheckException {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        if (this.checkInequalityOperators) {
            this.checkSelectedNotEqualsOperationFromCheckOption();
        }
        for (StateflowChart chart : StateflowUtils.getStateflowChartsFromModel((SimulinkModel)model, (boolean)false)) {
            if (!StateflowUtils.hasActionLanguageC((StateflowChart)chart)) continue;
            boolean cBitOperationsEnabled = StateflowUtils.areCBitwiseOperationsEnabled((StateflowChart)chart);
            this.checkTransitionsForInvalidOperators(chart, cBitOperationsEnabled);
            this.checkNodesForInvalidOperators(chart, cBitOperationsEnabled);
        }
    }

    private void checkSelectedNotEqualsOperationFromCheckOption() {
        this.selectedNotEqOperatorOption = this.selectedNotEqOperatorOption.trim();
        if (!NOTEQ_OPERATIONS.containsKey(this.selectedNotEqOperatorOption)) {
            LOGGER.error("Invalid value for check option 'Preferred inequality operator': " + this.selectedNotEqOperatorOption + ". Using default value '!='");
            this.selectedNotEqOperatorOption = "!=";
        }
    }

    private void checkTransitionsForInvalidOperators(StateflowChart chart, boolean cBitOperationsEnabled) {
        for (StateflowTransition transition : StateflowUtils.getAllTransitionsAsSet((StateflowChart)chart, (boolean)false)) {
            StateflowTransitionParts transitionLabelParts = StateflowCheckUtils.splitTransitionLabel((StateflowTransition)transition);
            QualifiedNameLocation location = this.buildLocation().forStateflowTransition(transition);
            this.checkUsageInvalidOperators(transitionLabelParts.condition, location, cBitOperationsEnabled);
            this.checkUsageInvalidOperators(transitionLabelParts.conditionAction, location, cBitOperationsEnabled);
            this.checkUsageInvalidOperators(transitionLabelParts.transitionAction, location, cBitOperationsEnabled);
        }
    }

    private void checkNodesForInvalidOperators(StateflowChart chart, boolean cBitOperationsEnabled) {
        for (StateflowState state : StateflowUtils.listStatesDepthFirst((StateflowChart)chart, (boolean)false)) {
            for (StateflowStateAction stateAction : StateflowCheckUtils.splitStateActionsFromStateLabel((StateflowState)state)) {
                QualifiedNameLocation location = this.buildLocation().forStateflowNode((StateflowNodeBase)state);
                this.checkUsageInvalidOperators(stateAction.actionCode, location, cBitOperationsEnabled);
            }
        }
    }

    private void checkUsageInvalidOperators(List<IToken> tokens, QualifiedNameLocation location, boolean cBitOperationsEnabled) {
        List tokensByLine = StateflowCheckUtils.splitLines(tokens);
        if (!cBitOperationsEnabled && this.checkBitOperators) {
            this.checkUsageOfBitOperators(tokensByLine, location);
        }
        if (this.checkInequalityOperators) {
            this.checkUsageOfInequalityOperators(tokensByLine, location);
        }
        if (!cBitOperationsEnabled && this.checkNegationOperators) {
            this.checkUsageOfNegationOperators(tokensByLine, location);
        }
    }

    private void checkUsageOfBitOperators(List<List<IToken>> tokensByLine, QualifiedNameLocation location) {
        for (List<IToken> tokens : tokensByLine) {
            if (!TokenStreamUtils.containsAny(tokens, (ETokenType[])BINARY_BIT_OPERATIONS)) continue;
            this.buildFinding(String.format(SUB_ID_A_FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)TokenStreamTextUtils.concatTokenTexts(tokens))), (ElementLocation)location).addFindingProperties(SUB_ID_A_RECOMMENDED_ACTION).createAndStore();
        }
    }

    private void checkUsageOfInequalityOperators(List<List<IToken>> tokensByLine, QualifiedNameLocation location) {
        ETokenType[] selectedNotEqualsTokenSequence = NOTEQ_OPERATIONS.get(this.selectedNotEqOperatorOption);
        List illegalNotEqualOperations = NOTEQ_OPERATIONS.values().stream().filter(tokens -> !Arrays.equals(tokens, selectedNotEqualsTokenSequence)).collect(Collectors.toList());
        for (List<IToken> tokens2 : tokensByLine) {
            for (ETokenType[] illegalTokenSequence : illegalNotEqualOperations) {
                if (!TokenStreamUtils.containsSequence(tokens2, (ETokenType[])illegalTokenSequence)) continue;
                this.buildFinding(String.format(SUB_ID_B_FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)TokenStreamTextUtils.concatTokenTexts(tokens2))), (ElementLocation)location).addFindingProperties(SUB_ID_B_RECOMMENDED_ACTION).createAndStore();
            }
        }
    }

    private void checkUsageOfNegationOperators(List<List<IToken>> tokensByLine, QualifiedNameLocation location) {
        for (List<IToken> tokens : tokensByLine) {
            if (tokens.size() < 2) {
                return;
            }
            for (int i = 1; i < tokens.size(); ++i) {
                if (tokens.get(i - 1).getType() != ILLEGAL_NEGATION_OPERATION || tokens.get(i).getType() == ETokenType.EQ) continue;
                this.buildFinding(String.format(SUB_ID_C_FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)TokenStreamTextUtils.concatTokenTexts(tokens))), (ElementLocation)location).addFindingProperties(SUB_ID_C_RECOMMENDED_ACTION).createAndStore();
            }
        }
    }
}

