/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.sql_like;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-use-case-rather-than-complex-if", languages={ELanguage.PLSQL, ELanguage.ESQL}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class UseCaseRatherThanComplexIf
extends CheckImplementationBase {
    public void execute() throws CheckException {
        this.processEntities(this.context.getAbstractSyntaxTree(this.getCodeViewOption()));
    }

    private void processEntities(List<ShallowEntity> entities) {
        boolean inIfStatement = false;
        ArrayList<Object> ifStatementTokens = new ArrayList<IToken>();
        int numberOfElseIf = 0;
        int numberOfElse = 0;
        String currentVariableInCondition = "";
        for (ShallowEntity entity : entities) {
            switch (entity.getSubtype()) {
                case "if": {
                    this.checkIfCompliant(ifStatementTokens, numberOfElseIf, numberOfElse, inIfStatement);
                    ifStatementTokens = new ArrayList(entity.includedTokens());
                    numberOfElseIf = 0;
                    numberOfElse = 0;
                    currentVariableInCondition = this.extractCheckedVariableName(entity);
                    inIfStatement = true;
                    break;
                }
                case "elseif": 
                case "elsif": 
                case "else if": 
                case "elif": {
                    if (currentVariableInCondition.equals(this.extractCheckedVariableName(entity))) {
                        ++numberOfElseIf;
                    }
                    ifStatementTokens.addAll((Collection<IToken>)entity.includedTokens());
                    break;
                }
                case "else": {
                    ifStatementTokens.addAll((Collection<IToken>)entity.includedTokens());
                    this.checkIfCompliant(ifStatementTokens, numberOfElseIf, ++numberOfElse, true);
                    inIfStatement = false;
                    currentVariableInCondition = "";
                    break;
                }
                default: {
                    this.checkIfCompliant(ifStatementTokens, numberOfElseIf, numberOfElse, inIfStatement);
                    inIfStatement = false;
                    numberOfElseIf = 0;
                    numberOfElse = 0;
                }
            }
            this.processEntities((List<ShallowEntity>)entity.getChildren());
        }
        this.checkIfCompliant(ifStatementTokens, numberOfElseIf, numberOfElse, inIfStatement);
    }

    private String extractCheckedVariableName(ShallowEntity entity) {
        UnmodifiableList ownStartTokens = entity.ownStartTokens();
        Object variableName = ((IToken)ownStartTokens.get(1)).getText();
        if (ownStartTokens.size() > 3 && ETokenType.DOT == ((IToken)ownStartTokens.get(2)).getType()) {
            variableName = (String)variableName + "." + ((IToken)ownStartTokens.get(3)).getText();
        }
        return variableName;
    }

    private void checkIfCompliant(List<IToken> ifStatementTokens, int numberOfElseIf, int numberOfElse, boolean inIfStatement) {
        if (!inIfStatement) {
            return;
        }
        if (numberOfElseIf > 1 || numberOfElse == 1 && numberOfElseIf > 0) {
            this.createFinding(ifStatementTokens);
        }
    }

    private void createFinding(List<IToken> ifStatementTokens) {
        this.buildFinding("Prefer `CASE` over complex `IF` constructs", this.buildLocation().forTokens(ifStatementTokens)).createAndStore();
    }
}

