/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.vb;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Arrays;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="cqse-catch-high-level-vb-exception", languages={ELanguage.VB}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CatchHighLevelVBExceptionCheck
extends CheckImplementationBase {
    private static final int GROUP_NAME = 0;
    private static final TokenPattern CATCH_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.CATCH}).sequence(new Object[]{ETokenType.IDENTIFIER, new TokenPattern().repeated(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER})}).sequence(new Object[]{ETokenType.AS}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0);

    public void execute() throws CheckException {
        List statementsInMethod = ShallowEntityTraversalUtils.findNestedEntities((List)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD, entity -> true, (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statementInMethod : statementsInMethod) {
            if (!"catch".equals(statementInMethod.getSubtype())) continue;
            this.processTokens((List<IToken>)statementInMethod.ownStartTokens());
            this.processTokens((List<IToken>)statementInMethod.ownEndTokens());
        }
    }

    private void processTokens(List<IToken> tokens) {
        for (TokenPatternMatch match : CATCH_PATTERN.findAll(tokens)) {
            List matchedTokens = match.groupTokens(0);
            IToken exceptionToken = (IToken)CollectionUtils.getLast((List)matchedTokens);
            if (!LanguageFeatureParser.CS.isGenericExceptionClass(exceptionToken.getText())) continue;
            this.buildFinding(this.getFindingMessage(Arrays.asList(exceptionToken)), this.buildLocation().forToken(exceptionToken)).createAndStore();
        }
    }

    private String getFindingMessage(List<IToken> tokens) {
        return "Catch clause catches generic exception `" + TokenStreamTextUtils.concatTokenTexts(tokens) + "`";
    }
}

