/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core;

import com.teamscale.wia.ManualTestCase;
import eu.cqse.check.framework.core.LocationBuilder;
import eu.cqse.check.framework.core.LocationBuilderBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.languages.wia.WorkItemShallowParser;
import eu.cqse.check.framework.util.tokens.WiaTokenUtils;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.conqat.engine.commons.findings.location.ManualTestCaseTextRegionLocation;
import org.conqat.engine.commons.findings.location.TeamscaleIssueFieldLocation;
import org.conqat.engine.commons.findings.location.TeamscaleIssueLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableListIterator;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.jspecify.annotations.NonNull;

public class WorkItemLocationBuilder
extends LocationBuilder {
    private final ShallowEntity workItemEntity;
    private final String workItemId;

    public WorkItemLocationBuilder(LocationBuilderBase locationBuilderWithoutDefaultView, ECodeViewOption.ETextViewOption defaultTextView, ShallowEntity workItemEntity, String workItemId) {
        super(locationBuilderWithoutDefaultView, defaultTextView);
        this.workItemEntity = workItemEntity;
        this.workItemId = workItemId;
    }

    public Optional<TeamscaleIssueLocation> forWorkItem() {
        return Optional.of(new TeamscaleIssueLocation(this.uniformPath, this.workItemId));
    }

    public @NonNull Optional<TeamscaleIssueFieldLocation> forAttribute(String attributeName, String attributeText) {
        return this.forAttribute(attributeName, attributeText, 0, attributeText.length() - 1);
    }

    public Optional<TeamscaleIssueFieldLocation> forAttribute(String attributeName, String attributeText, int fieldBeginOffset, int fieldEndOffset) {
        ShallowEntity attributeEntity = this.findAttributeEntity(attributeName);
        LineOffsetConverter lineOffsetConverter = new LineOffsetConverter(attributeText);
        int fieldStartLine = lineOffsetConverter.getLine(fieldBeginOffset);
        int fieldEndLine = lineOffsetConverter.getLine(fieldEndOffset);
        return Optional.of(new TeamscaleIssueFieldLocation(this.uniformPath, this.workItemId, new TeamscaleIssueFieldLocation.RawAndFieldSpecific(attributeEntity.getStartOffset() + fieldBeginOffset, fieldBeginOffset), new TeamscaleIssueFieldLocation.RawAndFieldSpecific(attributeEntity.getStartOffset() + fieldEndOffset, fieldEndOffset), new TeamscaleIssueFieldLocation.RawAndFieldSpecific(attributeEntity.getStartLine(), fieldStartLine), new TeamscaleIssueFieldLocation.RawAndFieldSpecific(attributeEntity.getEndLine(), fieldEndLine), attributeName));
    }

    public Optional<ManualTestCaseTextRegionLocation> forTestStep(ManualTestCase testCase, ManualTestCase.TestStep testStep, int fieldBeginOffset, int fieldEndOffset, boolean stepAction) {
        int stepIndex = testCase.getTestSteps().indexOf((Object)testStep);
        if (stepIndex < 0) {
            throw new IllegalArgumentException(String.format("Test step %s is not included in test case %s", testStep, testCase));
        }
        return this.forTestStep(fieldBeginOffset, fieldEndOffset, stepIndex, stepAction);
    }

    private Optional<ManualTestCaseTextRegionLocation> forTestStep(int fieldBeginOffset, int fieldEndOffset, int stepIndex, boolean stepAction) {
        ShallowEntity stepEntity = this.findTestStepEntity(stepIndex, stepAction);
        List children = stepEntity.getChildrenOfType(EShallowEntityType.ATTRIBUTE);
        CCSMAssert.isTrue((children.size() == 1 ? 1 : 0) != 0, () -> String.format("Expected 1 child of step entity but found %d for entity: %s", children.size(), stepEntity));
        int tokenIndex = TokenStreamUtils.firstTokenMatching((List<IToken>)((ShallowEntity)children.get(0)).ownStartTokens(), (ITokenMatcher)ETokenType.STRING_LITERAL);
        CCSMAssert.isTrue((tokenIndex >= 0 ? 1 : 0) != 0, (String)"Cannot find action/check token within step");
        IToken stepToken = (IToken)((ShallowEntity)children.get(0)).ownStartTokens().get(tokenIndex);
        return this.forTestStepToken(stepToken, stepIndex, fieldBeginOffset, fieldEndOffset, stepAction);
    }

    private Optional<ManualTestCaseTextRegionLocation> forTestStepToken(IToken token, int stepIndex, int fieldBeginOffset, int fieldEndOffset, boolean stepAction) {
        CCSMAssert.isTrue((token.getType() == ETokenType.STRING_LITERAL ? 1 : 0) != 0, () -> String.format("Expected STRING_LITERAL token but got: %s with text '%s'", token.getType(), token.getText()));
        String text = WiaTokenUtils.removeStringQuotes(token.getText());
        LineOffsetConverter lineOffsetConverter = new LineOffsetConverter(text);
        int fieldBeginLine = lineOffsetConverter.getLine(fieldBeginOffset);
        int fieldEndLine = lineOffsetConverter.getLine(fieldEndOffset);
        return Optional.of(WorkItemLocationBuilder.forTestStepTokenRaw(token, this.uniformPath, this.workItemId, stepIndex, fieldBeginOffset, fieldEndOffset, fieldBeginLine, fieldEndLine, stepAction));
    }

    public static ManualTestCaseTextRegionLocation forTestStepRaw(String uniformPath, String workItemId, int stepIndex, int rawTextFieldBeginOffset, int rawTextFieldBeginLine, int fieldBeginOffset, int fieldEndOffset, int fieldBeginLine, int fieldEndLine, boolean stepAction) {
        return WorkItemLocationBuilder.forTestStepRaw(uniformPath, workItemId, stepIndex, stepAction, stepIndex, stepAction, rawTextFieldBeginOffset, rawTextFieldBeginLine, fieldBeginOffset, fieldEndOffset, fieldBeginLine, fieldEndLine);
    }

    public static ManualTestCaseTextRegionLocation forTestStepRaw(String uniformPath, String workItemId, int startStepIndex, boolean startStepAction, int endStepIndex, boolean endStepAction, int rawTextFieldBeginOffset, int rawTextFieldBeginLine, int fieldBeginOffset, int fieldEndOffset, int fieldBeginLine, int fieldEndLine) {
        return new ManualTestCaseTextRegionLocation(uniformPath, workItemId, new TeamscaleIssueFieldLocation.RawAndFieldSpecific(rawTextFieldBeginOffset + fieldBeginOffset, fieldBeginOffset), new TeamscaleIssueFieldLocation.RawAndFieldSpecific(rawTextFieldBeginOffset + fieldEndOffset, fieldEndOffset), new TeamscaleIssueFieldLocation.RawAndFieldSpecific(rawTextFieldBeginLine, fieldBeginLine), new TeamscaleIssueFieldLocation.RawAndFieldSpecific(rawTextFieldBeginLine, fieldEndLine), startStepIndex, startStepAction, endStepIndex, endStepAction, "testSteps", null);
    }

    private static ManualTestCaseTextRegionLocation forTestStepTokenRaw(IToken token, String uniformPath, String workItemId, int stepIndex, int fieldBeginOffset, int fieldEndOffset, int fieldBeginLine, int fieldEndLine, boolean stepAction) {
        return WorkItemLocationBuilder.forTestStepRaw(uniformPath, workItemId, stepIndex, token.getOffset() + 1, token.getLineNumber() + 1, fieldBeginOffset, fieldEndOffset, fieldBeginLine, fieldEndLine, stepAction);
    }

    private ShallowEntity findTestStepEntity(int stepIndex, boolean action) {
        String attributeName = "testSteps";
        ShallowEntity testStepsEntity = this.findAttributeEntity(attributeName);
        ShallowEntity testStepEntity = (ShallowEntity)testStepsEntity.getChildren().get(stepIndex);
        for (ShallowEntity actionOrCheck : testStepEntity.getChildren()) {
            if ("action".equals(actionOrCheck.getName()) != action) continue;
            return actionOrCheck;
        }
        throw new IllegalStateException(String.format("Unable to find test step entity for step %d, action (%s) in root entity %s", stepIndex, action, this.workItemEntity));
    }

    private ShallowEntity findAttributeEntity(String attributeName) {
        List candidates = this.workItemEntity.getChildrenOfType(WorkItemShallowParser.ATTRIBUTE_TYPE);
        for (ShallowEntity workItemAttributeEntity : candidates) {
            String attributeEntityName = workItemAttributeEntity.getName();
            if (!attributeName.equalsIgnoreCase(attributeEntityName)) continue;
            CCSMAssert.isTrue((workItemAttributeEntity.getChildren().size() == 1 ? 1 : 0) != 0, (String)"Expected test steps entity to have exactly one child");
            return (ShallowEntity)workItemAttributeEntity.getChildren().get(0);
        }
        ShallowEntity entity = this.findAdditionalFieldEntity(attributeName, candidates);
        if (entity != null) {
            return entity;
        }
        throw new NoSuchElementException("Unable to find attribute entity for attribute: " + attributeName);
    }

    private ShallowEntity findAdditionalFieldEntity(String attributeName, List<ShallowEntity> candidates) {
        int additionalFieldIndex = WorkItemLocationBuilder.getAdditionalFieldIndex(attributeName, candidates);
        if (additionalFieldIndex < 0) {
            return null;
        }
        return WorkItemLocationBuilder.getAdditionalFieldValueEntity(candidates, additionalFieldIndex);
    }

    private static int getAdditionalFieldIndex(String attributeName, List<ShallowEntity> candidates) {
        ShallowEntity additionalFieldNamesEntity = candidates.stream().filter(candidate -> "additionalFieldNames".equalsIgnoreCase(candidate.getName())).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find additional field names entity within: " + String.valueOf(candidates)));
        CCSMAssert.isTrue((additionalFieldNamesEntity.getChildren().size() == 1 && ((ShallowEntity)additionalFieldNamesEntity.getChildren().get(0)).getType() == EShallowEntityType.META ? 1 : 0) != 0, (String)"Expected additional field names entity to have exactly one child (META: array)");
        UnmodifiableListIterator fieldNamesIterator = ((ShallowEntity)additionalFieldNamesEntity.getChildren().get(0)).getChildren().listIterator();
        while (fieldNamesIterator.hasNext()) {
            ShallowEntity additionalFieldNameEntity = (ShallowEntity)fieldNamesIterator.next();
            if (!attributeName.equalsIgnoreCase(additionalFieldNameEntity.getName())) continue;
            return fieldNamesIterator.previousIndex();
        }
        return -1;
    }

    private static ShallowEntity getAdditionalFieldValueEntity(List<ShallowEntity> candidates, int additionalFieldIndex) {
        ShallowEntity additionalFieldValuesEntity = candidates.stream().filter(candidate -> "additionalFieldValues".equalsIgnoreCase(candidate.getName())).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find additional field values entity within: " + String.valueOf(candidates)));
        CCSMAssert.isTrue((additionalFieldValuesEntity.getChildren().size() == 1 && ((ShallowEntity)additionalFieldValuesEntity.getChildren().get(0)).getType() == EShallowEntityType.META ? 1 : 0) != 0, (String)"Expected additional field values entity to have exactly one child (META: array)");
        UnmodifiableList additionalFieldValues = ((ShallowEntity)additionalFieldValuesEntity.getChildren().get(0)).getChildren();
        CCSMAssert.isTrue((additionalFieldValues.size() > additionalFieldIndex ? 1 : 0) != 0, () -> String.format("Expected additional field value with index %d but has only %d elements: %s", additionalFieldIndex, additionalFieldValues.size(), additionalFieldValues));
        return (ShallowEntity)additionalFieldValues.get(additionalFieldIndex);
    }
}

