/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core.option;

import eu.cqse.check.framework.core.option.ICheckOption;
import org.conqat.lib.commons.assertion.CCSMAssert;

public abstract class CheckOptionBase<T>
implements ICheckOption<T> {
    private final String name;
    private final String description;
    private final boolean multilineText;
    private final Class<T> type;
    private final T defaultValue;

    protected CheckOptionBase(String name, String description, boolean multilineText, Class<T> type, T defaultValue) {
        CCSMAssert.isNotNull((Object)name, () -> String.format("Expected \"%s\" to be not null", "name"));
        CCSMAssert.isNotNull((Object)description, () -> String.format("Expected \"%s\" to be not null", "description"));
        CCSMAssert.isNotNull(type, () -> String.format("Expected \"%s\" to be not null", "type"));
        CCSMAssert.isNotNull(defaultValue, () -> String.format("Expected \"%s\" to be not null", "defaultValue"));
        CCSMAssert.isTrue((boolean)type.isInstance(defaultValue), () -> String.format("Expected \"%s\" to be of type %s but was %s", "defaultValue", type, defaultValue.getClass()));
        this.name = name;
        this.description = description;
        this.multilineText = multilineText;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isMultilineText() {
        return this.multilineText;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }
}

