/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.scanner;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.ILenientScanner;
import eu.cqse.check.framework.scanner.MatlabToken;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.EnumSet;

class MatlabScanner
implements ILenientScanner {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 512;
    public static final int YYINITIAL = 0;
    public static final int SINGLE_QUOTED_STRING = 2;
    public static final int DOUBLE_QUOTED_STRING = 4;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2};
    private static final int[] ZZ_CMAP_TOP = MatlabScanner.zzUnpackcmap_top();
    private static final String ZZ_CMAP_TOP_PACKED_0 = "\u0001\u0000\u10ff\u0100";
    private static final int[] ZZ_CMAP_BLOCKS = MatlabScanner.zzUnpackcmap_blocks();
    private static final String ZZ_CMAP_BLOCKS_PACKED_0 = "\t\u0000\u0001\u0001\u0001\u0002\u0001\u0000\u0001\u0003\u0001\u0004\u0012\u0000\u0001\u0001\u0001\u0005\u0001\u0006\u0002\u0000\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\n\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0003\u001a\u0002\u001b\u0015\u001a\u0001\u001c\u0001\u001d\u0001\u001e\u0001\u001f\u0001 \u0001\u0000\u0001!\u0001\"\u0001#\u0001$\u0001%\u0001&\u0001'\u0001(\u0001)\u0001*\u0001+\u0001,\u0001-\u0001.\u0001/\u00010\u0001\u001a\u00011\u00012\u00013\u00014\u00015\u00016\u0001\u001a\u00017\u0001\u001a\u00018\u00019\u0001:\u0001;\u0181\u0000";
    private static final int[] ZZ_ACTION = MatlabScanner.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0003\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0003\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u001d\u0001\u001e\u000e\u001a\u0001\u001f\u0001 \u0001!\u0001\"\u0001#\u0002$\u0001%\u0001#\u0001&\u0002\u0007\u0001'\u0001(\u0001)\u0001\u0000\u0001*\u0001+\u0001,\u0001-\u0001\u0000\u0001.\u0001/\u00010\u00011\f\u001a\u00012\n\u001a\u00013\u00014\u0001#\u0001\u0000\u0001\u0007\u0001\u0002\u0001\u0000\u0001+\u0007\u001a\u00015\u0003\u001a\u00016\u000b\u001a\u00017\u0001\u001a\u0001\u0000\u0001\u0002\u0002\u001a\u00018\u0003\u001a\u00019\n\u001a\u0001:\u0001\u001a\u0001;\u0001\u001a\u0001<\u0001\u001a\u0001=\u0001>\u000e\u001a\u0001?\u0003\u001a\u0001@\u0001\u001a\u0001A\u0001\u001a\u0001B\u0002\u001a\u0001C\u0002\u001a\u0001D\u0001E\u0005\u001a\u0001F\u0004\u001a\u0001G\u0001H\u0001\u001a\u0001I\u0003\u001a\u0001J\u0001\u001a\u0001K\u0003\u001a\u0001L\u0001M\u0001N";
    private static final int[] ZZ_ROWMAP = MatlabScanner.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000<\u0000x\u0000\u00b4\u0000\u00b4\u0000\u00b4\u0000\u00b4\u0000\u00f0\u0000\u00b4\u0000\u00b4\u0000\u012c\u0000\u0168\u0000\u00b4\u0000\u00b4\u0000\u00b4\u0000\u00b4\u0000\u00b4\u0000\u00b4\u0000\u00b4\u0000\u01a4\u0000\u00b4\u0000\u01e0\u0000\u00b4\u0000\u00b4\u0000\u021c\u0000\u0258\u0000\u0294\u0000\u00b4\u0000\u02d0\u0000\u030c\u0000\u00b4\u0000\u00b4\u0000\u00b4\u0000\u00b4\u0000\u0348\u0000\u0384\u0000\u03c0\u0000\u03fc\u0000\u0438\u0000\u0474\u0000\u04b0\u0000\u04ec\u0000\u0528\u0000\u0564\u0000\u05a0\u0000\u05dc\u0000\u0618\u0000\u0654\u0000\u00b4\u0000\u0690\u0000\u00b4\u0000\u06cc\u0000\u0708\u0000\u00b4\u0000\u0744\u0000\u0780\u0000\u07bc\u0000\u07f8\u0000\u0834\u0000\u0870\u0000\u00b4\u0000\u00b4\u0000\u00b4\u0000\u08ac\u0000\u00b4\u0000\u08e8\u0000\u00b4\u0000\u00b4\u0000\u0924\u0000\u00b4\u0000\u00b4\u0000\u00b4\u0000\u00b4\u0000\u0960\u0000\u099c\u0000\u09d8\u0000\u0a14\u0000\u0a50\u0000\u0a8c\u0000\u0ac8\u0000\u0b04\u0000\u0b40\u0000\u0b7c\u0000\u0bb8\u0000\u0bf4\u0000\u030c\u0000\u0c30\u0000\u0c6c\u0000\u0ca8\u0000\u0ce4\u0000\u0d20\u0000\u0d5c\u0000\u0d98\u0000\u0dd4\u0000\u0e10\u0000\u0e4c\u0000\u00b4\u0000\u00b4\u0000\u00b4\u0000\u0e88\u0000\u0ec4\u0000\u0f00\u0000\u0f3c\u0000\u0f78\u0000\u0fb4\u0000\u0ff0\u0000\u102c\u0000\u1068\u0000\u10a4\u0000\u10e0\u0000\u111c\u0000\u030c\u0000\u1158\u0000\u1194\u0000\u11d0\u0000\u030c\u0000\u120c\u0000\u1248\u0000\u1284\u0000\u12c0\u0000\u12fc\u0000\u1338\u0000\u1374\u0000\u13b0\u0000\u13ec\u0000\u1428\u0000\u1464\u0000\u030c\u0000\u14a0\u0000\u14dc\u0000\u1518\u0000\u1554\u0000\u1590\u0000\u030c\u0000\u15cc\u0000\u1608\u0000\u1644\u0000\u1680\u0000\u16bc\u0000\u16f8\u0000\u1734\u0000\u1770\u0000\u17ac\u0000\u17e8\u0000\u1824\u0000\u1860\u0000\u189c\u0000\u18d8\u0000\u030c\u0000\u1914\u0000\u030c\u0000\u1950\u0000\u00b4\u0000\u198c\u0000\u030c\u0000\u030c\u0000\u19c8\u0000\u1a04\u0000\u1a40\u0000\u1a7c\u0000\u1ab8\u0000\u1af4\u0000\u1b30\u0000\u1b6c\u0000\u1ba8\u0000\u1be4\u0000\u1c20\u0000\u1c5c\u0000\u1c98\u0000\u1cd4\u0000\u030c\u0000\u1d10\u0000\u1d4c\u0000\u1d88\u0000\u030c\u0000\u1dc4\u0000\u030c\u0000\u1e00\u0000\u030c\u0000\u1e3c\u0000\u1e78\u0000\u030c\u0000\u1eb4\u0000\u1ef0\u0000\u030c\u0000\u030c\u0000\u1f2c\u0000\u1f68\u0000\u1fa4\u0000\u1fe0\u0000\u201c\u0000\u030c\u0000\u2058\u0000\u2094\u0000\u20d0\u0000\u210c\u0000\u030c\u0000\u030c\u0000\u2148\u0000\u030c\u0000\u2184\u0000\u21c0\u0000\u21fc\u0000\u030c\u0000\u2238\u0000\u030c\u0000\u2274\u0000\u22b0\u0000\u22ec\u0000\u030c\u0000\u030c\u0000\u030c";
    private static final int[] ZZ_TRANS = MatlabScanner.zzUnpacktrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u001d\u0002\u001e\u0001\u001f\u0001 \u0001!\u0001\"\u0001\u0004\u0001#\u0001$\u0001%\u0001\u001e\u0001&\u0001'\u0001(\u0001\u001e\u0001)\u0003\u001e\u0001*\u0001\u001e\u0001+\u0001,\u0001-\u0001.\u0001/\u0002\u001e\u00010\u0001\u001e\u00011\u00012\u00013\u00014\u00025\u00016\u00015\u00017\u00045\u0001825\u00029\u00016\u00019\u00017\u00019\u0001:59>\u0000\u0001\u00069\u0000\u0002;\u0001\u0000\u0001;\u0001\u00003;\u0001<\u0003;\b\u0000\u0001=<\u0000\u0001>\u0002\u0000\u0001?\u0003\u0000\u0001@\u0001A\u0001B\n\u0000\u0001C\u0001\u0000\u0001D,\u0000\u0001B\u0001\u0000\u0001\u0016\b\u0000\u0001E\b\u0000\u0002E\u0003\u0000\u0002F'\u0000\u0001G;\u0000\u0001H;\u0000\u0001I?\u0000\u0002\u001e\u0005\u0000\u0017\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0018\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0011\u001e\u0001J\u0006\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0011\u001e\u0001K\u0006\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0001\u001e\u0001L\n\u001e\u0001M\u0002\u001e\u0001N\b\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\f\u001e\u0001O\u0001\u001e\u0001P\u0006\u001e\u0001Q\u0002\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0001\u001e\u0001R\r\u001e\u0001S\u0004\u001e\u0001T\u0003\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\f\u001e\u0001U\u000b\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0006\u001e\u0001V\u0011\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0005\u001e\u0001W\u0012\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0013\u001e\u0001X\u0004\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0001\u001e\u0001Y\u0003\u001e\u0001Z\u000b\u001e\u0001[\u0006\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0005\u001e\u0001\\\u0012\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0010\u001e\u0001]\u0005\u001e\u0001^\u0001\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0011\u001e\u0001_\u0006\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\b\u001e\u0001`\u000f\u001e=\u0000\u0001a\u0018\u0000\u0001b%\u0000\u00025\u0001\u0000\u00015\u0001\u0000\u00045\u0001\u000025\u0002\u0000\u00016B\u0000\u0001c2\u0000\u00029\u0001\u0000\u00019\u0001\u0000\u00019\u0001\u000059\u0006\u0000\u0001c5\u0000\u0002;\u0001\u0000\u0001;\u0001\u00007;\u0002<\u0001d\u0001<\u0001d\u0002<\u0001e4<\u0010\u0000\u0001f=\u0000\u0001B\b\u0000\u0001E\b\u0000\u0002E\u0003\u0000\u0002F\u001e\u0000\u0001g\u0001\u0000\u0001g\u0002\u0000\u0001h;\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0007\u001e\u0001i\u0010\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0005\u001e\u0001j\u0012\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0012\u001e\u0001k\u0001l\u0004\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0001\u001e\u0001m\u0016\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u000e\u001e\u0001n\t\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0012\u001e\u0001o\u0005\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0004\u001e\u0001p\u000f\u001e\u0001q\u0003\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0005\u001e\u0001r\u0012\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\f\u001e\u0001s\u000b\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0011\u001e\u0001t\u0006\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u000e\u001e\u0001u\t\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u000f\u001e\u0001v\b\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0013\u001e\u0001w\u0004\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\b\u001e\u0001x\u000f\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0011\u001e\u0001y\u0006\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0011\u001e\u0001z\u0006\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u000f\u001e\u0001{\b\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0013\u001e\u0001|\u0004\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\r\u001e\u0001}\n\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\t\u001e\u0001~\u000e\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0014\u001e\u0001\u007f\u0002\u001e\u0001\u0080\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\t\u001e\u0001\u0081\u000e\u001e\u0004\u0000\u0007d\u0001\u00824d\u0002<\u0001d\u0001<\u0001d\u0002<\u0001e2<\u0001;\u0001<\u0002f\u0001\u0005\u0001\u0000\u0001\u00837f\u0012\u0000\u0001h;\u0000\u0001h\u0016\u0000\u0002F#\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0014\u001e\u0001\u0084\u0003\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0001\u001e\u0001\u0085\u0016\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0005\u001e\u0001\u0086\u0012\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0003\u001e\u0001\u0087\u0014\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0012\u001e\u0001\u0088\u0005\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0013\u001e\u0001\u0089\u0004\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0005\u001e\u0001\u008a\u0012\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\r\u001e\u0001\u008b\n\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u000e\u001e\u0001\u008c\t\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0012\u001e\u0001\u007f\u0005\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0003\u001e\u0001\u008d\u0014\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0002\u001e\u0001\u008e\u0015\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\b\u001e\u0001\u008f\u000f\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0005\u001e\u0001\u0090\u0012\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0006\u001e\u0001\u0091\u0011\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0012\u001e\u0001\u0092\u0005\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0010\u001e\u0001\u0093\u0007\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0014\u001e\u0001\u0094\u0003\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0004\u001e\u0001\u0095\u0013\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0013\u001e\u0001\u0096\u0004\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0005\u001e\u0001\u0097\u0012\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\f\u001e\u0001\u0098\u000b\u001e\u0004\u0000\u0007d\u0001\u00822d\u0001\u0099\u0001d\u0002\u0000\u0001\u0005K\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\r\u001e\u0001\u009a\n\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u000b\u001e\u0001\u009b\f\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\b\u001e\u0001\u009c\u000f\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0012\u001e\u0001\u009d\u0005\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\t\u001e\u0001\u009e\u000e\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\t\u001e\u0001\u009f\u000e\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0005\u001e\u0001\u00a0\u0012\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0013\u001e\u0001\u00a1\u0004\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0013\u001e\u0001\u00a2\u0004\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0001\u001e\u0001\u00a3\u0016\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u000f\u001e\u0001\u00a4\b\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0011\u001e\u0001\u00a5\u0006\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u000f\u001e\u0001\u00a6\b\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\t\u001e\u0001\u00a7\u000e\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0005\u001e\u0001\u00a8\u0012\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0011\u001e\u0001\u00a9\u0006\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0003\u001e\u0001\u00aa\u0014\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0005\u001e\u0001\u00ab\u0012\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0005\u001e\u0001\u00ac\u0012\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0004\u001e\u0001\u00ad\u0013\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u000e\u001e\u0001\u00ae\t\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0006\u001e\u0001\u00af\u0011\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0011\u001e\u0001\u00b0\u0006\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0012\u001e\u0001\u00b1\u0005\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\t\u001e\u0001\u00b2\u000e\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\f\u001e\u0001\u00b3\u000b\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0004\u001e\u0001\u00b4\u0013\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0016\u001e\u0001\u00b5\u0001\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0011\u001e\u0001\u00b6\u0006\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0012\u001e\u0001\u00b7\u0005\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0011\u001e\u0001\u00b8\u0006\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u000e\u001e\u0001\u00b9\t\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\b\u001e\u0001\u00ba\u000f\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u000e\u001e\u0001\u00bb\t\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0005\u001e\u0001\u00bc\u0012\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0014\u001e\u0001\u00bd\u0003\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0001\u001e\u0001\u00be\u0016\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u000f\u001e\u0001\u00bf\b\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0012\u001e\u0001\u00c0\u0005\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\t\u001e\u0001\u00c1\u000e\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0013\u001e\u0001\u00c2\u0004\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0013\u001e\u0001\u00c3\u0004\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0013\u001e\u0001\u00c4\u0004\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0006\u001e\u0001\u00c5\u0011\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0005\u001e\u0001\u00c6\u0012\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0013\u001e\u0001\u00c7\u0004\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u000e\u001e\u0001\u00c8\t\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0012\u001e\u0001\u00c9\u0005\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0005\u001e\u0001\u00ca\u0012\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\t\u001e\u0001\u00cb\u000e\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0012\u001e\u0001\u00cc\u0005\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\t\u001e\u0001\u00cd\u000e\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0005\u001e\u0001\u00ce\u0012\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u000e\u001e\u0001\u00cf\t\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0005\u001e\u0001\u00d0\u0012\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u000f\u001e\u0001\u00d1\b\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0013\u001e\u0001\u00d2\u0004\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u0012\u001e\u0001\u00d3\u0005\u001e\u0016\u0000\u0001\u001e\u0007\u0000\u0002\u001e\u0004\u0000\u000e\u001e\u0001\u00d4\t\u001e\u0004\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = MatlabScanner.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0003\u0000\u0004\t\u0001\u0001\u0002\t\u0002\u0001\u0007\t\u0001\u0001\u0001\t\u0001\u0001\u0002\t\u0003\u0001\u0001\t\u0002\u0001\u0004\t\u000e\u0001\u0001\t\u0001\u0001\u0001\t\u0002\u0001\u0001\t\u0006\u0001\u0003\t\u0001\u0000\u0001\t\u0001\u0001\u0002\t\u0001\u0000\u0004\t\u0017\u0001\u0003\t\u0001\u0000\u0002\u0001\u0001\u0000\u001a\u0001\u0001\u0000\u0016\u0001\u0001\t;\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[Math.min(512, this.zzMaxBufferLen())];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtEOF;
    private int zzFinalHighSurrogate = 0;
    private int yyline;
    private int yycolumn;
    private long yychar;
    private boolean zzAtBOL = true;
    private boolean zzEOFDone;
    private static final EnumSet<ETokenType> TRANSPOSE_TYPES = EnumSet.copyOf(Arrays.asList(ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL, ETokenType.IMAGINARY_LITERAL, ETokenType.IDENTIFIER, ETokenType.TRANSPOSE, ETokenType.COMPLEX_TRANSPOSE, ETokenType.RBRACK, ETokenType.RBRACE, ETokenType.RPAREN));
    private StringBuilder string = new StringBuilder();
    private String originId;
    private ETokenType lastTokenType;
    private int parenDepth;
    private int braceDepth;
    private int brackDepth;
    private boolean whiteSpaceSinceLastToken = false;

    private static int[] zzUnpackcmap_top() {
        int[] result = new int[4352];
        int offset = 0;
        offset = MatlabScanner.zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_top(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackcmap_blocks() {
        int[] result = new int[512];
        int offset = 0;
        offset = MatlabScanner.zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_blocks(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[212];
        int offset = 0;
        offset = MatlabScanner.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[212];
        int offset = 0;
        offset = MatlabScanner.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length() - 1;
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpacktrans() {
        int[] result = new int[9000];
        int offset = 0;
        offset = MatlabScanner.zzUnpacktrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpacktrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[212];
        int offset = 0;
        offset = MatlabScanner.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    @Override
    public void reset(Reader reader, String originId) {
        this.originId = originId;
        this.lastTokenType = null;
        this.parenDepth = 0;
        this.braceDepth = 0;
        this.brackDepth = 0;
        this.whiteSpaceSinceLastToken = false;
        this.yyreset(reader);
    }

    @Override
    public void close() throws IOException {
        this.yyclose();
    }

    private MatlabToken token(ETokenType type) {
        return new MatlabToken(type, this.yychar, this.yyline, this.yytext(), this.originId);
    }

    @Override
    public MatlabToken getNextToken() throws IOException {
        MatlabToken token = this.yyGetNextToken();
        this.lastTokenType = token.getType();
        this.whiteSpaceSinceLastToken = false;
        return token;
    }

    MatlabScanner(Reader in, String originId) {
        this.originId = originId;
        this.zzReader = in;
    }

    private int zzMaxBufferLen() {
        return Integer.MAX_VALUE;
    }

    private boolean zzCanGrow() {
        return true;
    }

    private static int zzCMap(int input) {
        int offset = input & 0xFF;
        return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
    }

    private boolean zzRefill() throws IOException {
        int requested;
        int numRead;
        if (this.zzStartRead > 0) {
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length - this.zzFinalHighSurrogate && this.zzCanGrow()) {
            char[] newBuffer = new char[Math.min(this.zzBuffer.length * 2, this.zzMaxBufferLen())];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, requested = this.zzBuffer.length - this.zzEndRead)) == 0) {
            if (requested == 0) {
                throw new EOFException("Scan buffer limit reached [" + this.zzBuffer.length + "]");
            }
            throw new IOException("Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
        }
        if (numRead > 0) {
            this.zzEndRead += numRead;
            if (Character.isHighSurrogate(this.zzBuffer[this.zzEndRead - 1])) {
                if (numRead == requested) {
                    --this.zzEndRead;
                    this.zzFinalHighSurrogate = 1;
                } else {
                    int c = this.zzReader.read();
                    if (c == -1) {
                        return true;
                    }
                    this.zzBuffer[this.zzEndRead++] = (char)c;
                }
            }
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzEOFDone = false;
        this.yyResetPosition();
        this.zzLexicalState = 0;
        int initBufferSize = Math.min(512, this.zzMaxBufferLen());
        if (this.zzBuffer.length > initBufferSize) {
            this.zzBuffer = new char[initBufferSize];
        }
    }

    private final void yyResetPosition() {
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzCurrentPos = 0;
        this.zzMarkedPos = 0;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzFinalHighSurrogate = 0;
        this.yyline = 0;
        this.yycolumn = 0;
        this.yychar = 0L;
    }

    public final boolean yyatEOF() {
        return this.zzAtEOF;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int position) {
        return this.zzBuffer[this.zzStartRead + position];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private static void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            MatlabScanner.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public MatlabToken yyGetNextToken() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block169: while (true) {
            int zzInput;
            boolean eof;
            int zzCurrentPosL;
            int zzCharCount;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += (long)(zzMarkedPosL - this.zzStartRead);
            boolean zzR = false;
            block170: for (zzCurrentPosL = this.zzStartRead; zzCurrentPosL < zzMarkedPosL; zzCurrentPosL += zzCharCount) {
                int zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
                zzCharCount = Character.charCount(zzCh);
                switch (zzCh) {
                    case 11: 
                    case 12: 
                    case 133: 
                    case 8232: 
                    case 8233: {
                        ++this.yyline;
                        zzR = false;
                        continue block170;
                    }
                    case 13: {
                        ++this.yyline;
                        zzR = true;
                        continue block170;
                    }
                    case 10: {
                        if (zzR) {
                            zzR = false;
                            continue block170;
                        }
                        ++this.yyline;
                        continue block170;
                    }
                    default: {
                        zzR = false;
                    }
                }
            }
            if (zzR) {
                boolean zzPeek;
                if (zzMarkedPosL < zzEndReadL) {
                    zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                } else if (this.zzAtEOF) {
                    zzPeek = false;
                } else {
                    eof = this.zzRefill();
                    zzEndReadL = this.zzEndRead;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    if (eof) {
                        zzPeek = false;
                    } else {
                        boolean bl = zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                    }
                }
                if (zzPeek) {
                    --this.yyline;
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + MatlabScanner.zzCMap(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                switch (this.zzLexicalState) {
                    case 2: {
                        this.yybegin(0);
                        return new MatlabToken(ETokenType.UNTERMINATED_STRING_LITERAL, this.yychar - (long)this.string.length() + 1L, this.yyline, this.string.toString(), this.originId);
                    }
                    case 213: {
                        continue block169;
                    }
                    case 4: {
                        this.yybegin(0);
                        return new MatlabToken(ETokenType.UNTERMINATED_STRING_LITERAL, this.yychar - (long)this.string.length() + 1L, this.yyline, this.string.toString(), this.originId);
                    }
                    case 214: {
                        continue block169;
                    }
                }
                if (this.lastTokenType != null && this.lastTokenType != ETokenType.EOL) {
                    return this.token(ETokenType.EOL);
                }
                return this.token(ETokenType.EOF);
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    return this.token(ETokenType.ILLEGAL_CHARACTER);
                }
                case 79: {
                    continue block169;
                }
                case 2: {
                    this.whiteSpaceSinceLastToken = true;
                }
                case 80: {
                    continue block169;
                }
                case 3: {
                    return this.token(ETokenType.EOL);
                }
                case 81: {
                    continue block169;
                }
                case 4: {
                    --this.yyline;
                }
                case 82: {
                    continue block169;
                }
                case 5: {
                    return this.token(ETokenType.EXCLAMATION);
                }
                case 83: {
                    continue block169;
                }
                case 6: {
                    this.yybegin(4);
                    this.string.setLength(0);
                    this.string.append(this.yytext());
                }
                case 84: {
                    continue block169;
                }
                case 7: {
                    return this.token(ETokenType.END_OF_LINE_COMMENT);
                }
                case 85: {
                    continue block169;
                }
                case 8: {
                    return this.token(ETokenType.AND);
                }
                case 86: {
                    continue block169;
                }
                case 9: {
                    if (TRANSPOSE_TYPES.contains(this.lastTokenType) && !this.whiteSpaceSinceLastToken) {
                        return this.token(ETokenType.COMPLEX_TRANSPOSE);
                    }
                    this.yybegin(2);
                    this.string.setLength(0);
                    this.string.append(this.yytext());
                }
                case 87: {
                    continue block169;
                }
                case 10: {
                    ++this.parenDepth;
                    return this.token(ETokenType.LPAREN);
                }
                case 88: {
                    continue block169;
                }
                case 11: {
                    --this.parenDepth;
                    return this.token(ETokenType.RPAREN);
                }
                case 89: {
                    continue block169;
                }
                case 12: {
                    return this.token(ETokenType.MATRIX_MULT);
                }
                case 90: {
                    continue block169;
                }
                case 13: {
                    return this.token(ETokenType.PLUS);
                }
                case 91: {
                    continue block169;
                }
                case 14: {
                    if (this.braceDepth > 0 || this.brackDepth > 0 || this.parenDepth > 0) {
                        return this.token(ETokenType.ARRAY_SEPARATOR);
                    }
                    return this.token(ETokenType.COMMA);
                }
                case 92: {
                    continue block169;
                }
                case 15: {
                    return this.token(ETokenType.MINUS);
                }
                case 93: {
                    continue block169;
                }
                case 16: {
                    return this.token(ETokenType.DOT);
                }
                case 94: {
                    continue block169;
                }
                case 17: {
                    return this.token(ETokenType.MATRIX_RIGHT_DIV);
                }
                case 95: {
                    continue block169;
                }
                case 18: {
                    return this.token(ETokenType.INTEGER_LITERAL);
                }
                case 96: {
                    continue block169;
                }
                case 19: {
                    return this.token(ETokenType.COLON);
                }
                case 97: {
                    continue block169;
                }
                case 20: {
                    if (this.braceDepth > 0 || this.brackDepth > 0 || this.parenDepth > 0) {
                        return this.token(ETokenType.ARRAY_SEPARATOR);
                    }
                    return this.token(ETokenType.SEMICOLON);
                }
                case 98: {
                    continue block169;
                }
                case 21: {
                    return this.token(ETokenType.LT);
                }
                case 99: {
                    continue block169;
                }
                case 22: {
                    return this.token(ETokenType.EQ);
                }
                case 100: {
                    continue block169;
                }
                case 23: {
                    return this.token(ETokenType.GT);
                }
                case 101: {
                    continue block169;
                }
                case 24: {
                    return this.token(ETokenType.QUESTION);
                }
                case 102: {
                    continue block169;
                }
                case 25: {
                    return this.token(ETokenType.AT);
                }
                case 103: {
                    continue block169;
                }
                case 26: {
                    return this.token(ETokenType.IDENTIFIER);
                }
                case 104: {
                    continue block169;
                }
                case 27: {
                    ++this.brackDepth;
                    return this.token(ETokenType.LBRACK);
                }
                case 105: {
                    continue block169;
                }
                case 28: {
                    return this.token(ETokenType.MATRIX_LEFT_DIV);
                }
                case 106: {
                    continue block169;
                }
                case 29: {
                    --this.brackDepth;
                    return this.token(ETokenType.RBRACK);
                }
                case 107: {
                    continue block169;
                }
                case 30: {
                    return this.token(ETokenType.MATRIX_POWER);
                }
                case 108: {
                    continue block169;
                }
                case 31: {
                    ++this.braceDepth;
                    return this.token(ETokenType.LBRACE);
                }
                case 109: {
                    continue block169;
                }
                case 32: {
                    return this.token(ETokenType.OR);
                }
                case 110: {
                    continue block169;
                }
                case 33: {
                    --this.braceDepth;
                    return this.token(ETokenType.RBRACE);
                }
                case 111: {
                    continue block169;
                }
                case 34: {
                    return this.token(ETokenType.COMP);
                }
                case 112: {
                    continue block169;
                }
                case 35: {
                    this.string.append(this.yytext());
                }
                case 113: {
                    continue block169;
                }
                case 36: {
                    this.yybegin(0);
                    return new MatlabToken(ETokenType.UNTERMINATED_STRING_LITERAL, this.yychar - (long)this.string.length() + 1L, this.yyline, this.string.toString(), this.originId);
                }
                case 114: {
                    continue block169;
                }
                case 37: {
                    this.yybegin(0);
                    this.string.append(this.yytext());
                    return new MatlabToken(ETokenType.STRING_LITERAL, this.yychar - (long)this.string.length() + 1L, this.yyline, this.string.toString(), this.originId);
                }
                case 115: {
                    continue block169;
                }
                case 38: {
                    this.yybegin(0);
                    this.string.append(this.yytext());
                    return new MatlabToken(ETokenType.STRING_LITERAL, this.yychar - (long)this.string.length() + 1L, this.yyline, this.string.toString(), this.originId);
                }
                case 116: {
                    continue block169;
                }
                case 39: {
                    return this.token(ETokenType.ANDAND);
                }
                case 117: {
                    continue block169;
                }
                case 40: {
                    return this.token(ETokenType.TRANSPOSE);
                }
                case 118: {
                    continue block169;
                }
                case 41: {
                    return this.token(ETokenType.MULT);
                }
                case 119: {
                    continue block169;
                }
                case 42: {
                    return this.token(ETokenType.RIGHT_DIV);
                }
                case 120: {
                    continue block169;
                }
                case 43: {
                    return this.token(ETokenType.FLOATING_POINT_LITERAL);
                }
                case 121: {
                    continue block169;
                }
                case 44: {
                    return this.token(ETokenType.LEFT_DIV);
                }
                case 122: {
                    continue block169;
                }
                case 45: {
                    return this.token(ETokenType.POWER);
                }
                case 123: {
                    continue block169;
                }
                case 46: {
                    return this.token(ETokenType.IMAGINARY_LITERAL);
                }
                case 124: {
                    continue block169;
                }
                case 47: {
                    return this.token(ETokenType.LTEQ);
                }
                case 125: {
                    continue block169;
                }
                case 48: {
                    return this.token(ETokenType.EQEQ);
                }
                case 126: {
                    continue block169;
                }
                case 49: {
                    return this.token(ETokenType.GTEQ);
                }
                case 127: {
                    continue block169;
                }
                case 50: {
                    return this.token(ETokenType.IF);
                }
                case 128: {
                    continue block169;
                }
                case 51: {
                    return this.token(ETokenType.OROR);
                }
                case 129: {
                    continue block169;
                }
                case 52: {
                    return this.token(ETokenType.NOTEQ);
                }
                case 130: {
                    continue block169;
                }
                case 53: {
                    if (this.lastTokenType == ETokenType.EOL || this.lastTokenType == ETokenType.SEMICOLON || this.lastTokenType == ETokenType.END_OF_LINE_COMMENT || this.lastTokenType == ETokenType.COMMA) {
                        return this.token(ETokenType.END);
                    }
                    return this.token(ETokenType.IDENTIFIER);
                }
                case 131: {
                    continue block169;
                }
                case 54: {
                    return this.token(ETokenType.FOR);
                }
                case 132: {
                    continue block169;
                }
                case 55: {
                    return this.token(ETokenType.TRY);
                }
                case 133: {
                    continue block169;
                }
                case 56: {
                    return this.token(ETokenType.CASE);
                }
                case 134: {
                    continue block169;
                }
                case 57: {
                    return this.token(ETokenType.ELSE);
                }
                case 135: {
                    continue block169;
                }
                case 58: {
                    return this.token(ETokenType.SPMD);
                }
                case 136: {
                    continue block169;
                }
                case 59: {
                    return this.token(ETokenType.BOOLEAN_LITERAL);
                }
                case 137: {
                    continue block169;
                }
                case 60: {
                    return this.token(ETokenType.TRADITIONAL_COMMENT);
                }
                case 138: {
                    continue block169;
                }
                case 61: {
                    return this.token(ETokenType.BREAK);
                }
                case 139: {
                    continue block169;
                }
                case 62: {
                    return this.token(ETokenType.CATCH);
                }
                case 140: {
                    continue block169;
                }
                case 63: {
                    return this.token(ETokenType.WHILE);
                }
                case 141: {
                    continue block169;
                }
                case 64: {
                    return this.token(ETokenType.ELSEIF);
                }
                case 142: {
                    continue block169;
                }
                case 65: {
                    return this.token(ETokenType.EVENTS);
                }
                case 143: {
                    continue block169;
                }
                case 66: {
                    return this.token(ETokenType.GLOBAL);
                }
                case 144: {
                    continue block169;
                }
                case 67: {
                    return this.token(ETokenType.PARFOR);
                }
                case 145: {
                    continue block169;
                }
                case 68: {
                    return this.token(ETokenType.RETURN);
                }
                case 146: {
                    continue block169;
                }
                case 69: {
                    return this.token(ETokenType.SWITCH);
                }
                case 147: {
                    continue block169;
                }
                case 70: {
                    return this.token(ETokenType.METHODS);
                }
                case 148: {
                    continue block169;
                }
                case 71: {
                    return this.token(ETokenType.CLASSDEF);
                }
                case 149: {
                    continue block169;
                }
                case 72: {
                    return this.token(ETokenType.CONTINUE);
                }
                case 150: {
                    continue block169;
                }
                case 73: {
                    return this.token(ETokenType.FUNCTION);
                }
                case 151: {
                    continue block169;
                }
                case 74: {
                    return this.token(ETokenType.ARGUMENTS);
                }
                case 152: {
                    continue block169;
                }
                case 75: {
                    return this.token(ETokenType.OTHERWISE);
                }
                case 153: {
                    continue block169;
                }
                case 76: {
                    return this.token(ETokenType.PERSISTENT);
                }
                case 154: {
                    continue block169;
                }
                case 77: {
                    return this.token(ETokenType.PROPERTIES);
                }
                case 155: {
                    continue block169;
                }
                case 78: {
                    return this.token(ETokenType.ENUMERATION);
                }
                case 156: {
                    continue block169;
                }
            }
            MatlabScanner.zzScanError(1);
        }
    }
}

