/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.ada;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;

public class AdaShallowParser
extends ShallowParserBase<EAdaParserStates> {
    public AdaShallowParser() {
        super(EAdaParserStates.class, EAdaParserStates.DECLARATIONS);
        this.createMetaRules();
        this.createSpecificationRules();
        this.createBodyAndTypeRules();
        this.createMethodAndAttributeRules();
        this.createTypeRules();
        this.createStatementRules();
    }

    private void createMetaRules() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.GENERIC}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).skipBeforeWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PACKAGE, ETokenType.PROCEDURE, ETokenType.FUNCTION, ETokenType.ENTRY}), ETokenType.WITH, ETokenType.SEMICOLON).endNodeWithContinuation();
        this.inAnyState().sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.WITH, ETokenType.USE, ETokenType.PRAGMA})).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.PREPROCESSOR_DIRECTIVE}).createNode(EShallowEntityType.META, "pragma").endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.END}).createNode(EShallowEntityType.META, "dangling end").skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON});
    }

    private void createSpecificationRules() {
        RecognizerBase packageSpecAlternative = this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.PACKAGE, ETokenType.IDENTIFIER}).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.IS, ETokenType.RENAMES}));
        packageSpecAlternative.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.MODULE, "package specification", INameResolver.ofIndex(-2)).endNode();
        packageSpecAlternative.sequence(new ITokenMatcher[]{ETokenType.RENAMES}).createNode(EShallowEntityType.MODULE, "package renaming", INameResolver.ofIndex(-2)).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        packageSpecAlternative.sequence(new ITokenMatcher[]{ETokenType.IS, ETokenType.NEW}).createNode(EShallowEntityType.TYPE, "generic package instantiation", INameResolver.ofIndex(-3)).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        packageSpecAlternative.sequence(new ITokenMatcher[]{ETokenType.IS}).createNode(EShallowEntityType.MODULE, "package specification", INameResolver.ofIndex(-2)).parseUntil(EAdaParserStates.DECLARATIONS).sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        RecognizerBase taskSpecAlternative = this.inAnyState().sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TASK, ETokenType.PROTECTED}), ETokenType.IDENTIFIER}).createNode(EShallowEntityType.MODULE, INameResolver.concat(INameResolver.firstMatchedTokenText(), INameResolver.ofString("specification")), INameResolver.previousTokenText()).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.IS}));
        taskSpecAlternative.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        taskSpecAlternative.sequence(new ITokenMatcher[]{ETokenType.IS}).parseUntil(EAdaParserStates.DECLARATIONS).sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createBodyAndTypeRules() {
        RecognizerBase<EAdaParserStates> packageBodyAlternative1 = this.inAnyState().sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PACKAGE, ETokenType.TASK, ETokenType.PROTECTED}), ETokenType.BODY, ETokenType.IDENTIFIER}).skipAfter(new ITokenMatcher[]{ETokenType.IS}).createNode(EShallowEntityType.MODULE, INameResolver.ofIndices(0, 1), INameResolver.ofIndex(-2));
        packageBodyAlternative1.sequence(new ITokenMatcher[]{ETokenType.SEPARATE, ETokenType.SEMICOLON}).endNode();
        RecognizerBase<EAdaParserStates> packageBodyAlternative2 = packageBodyAlternative1.parseUntil(EAdaParserStates.DECLARATIONS);
        packageBodyAlternative2.sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        AdaShallowParser.completeBlock(packageBodyAlternative2.sequence(new ITokenMatcher[]{ETokenType.BEGIN}));
        RecognizerBase taskTypeAlternative = this.inAnyState().sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TASK, ETokenType.PROTECTED}), ETokenType.TYPE, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.MODULE, INameResolver.ofIndices(0, 1)).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.IS}));
        taskTypeAlternative.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        taskTypeAlternative.sequence(new ITokenMatcher[]{ETokenType.IS}).parseUntil(EAdaParserStates.DECLARATIONS).sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EAdaParserStates[]{EAdaParserStates.DECLARATIONS}).sequence(new ITokenMatcher[]{ETokenType.NEW}).skipAfter(new ITokenMatcher[]{ETokenType.WITH});
    }

    private void createMethodAndAttributeRules() {
        RecognizerBase functionAlternative = this.inAnyState().sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PROCEDURE, ETokenType.FUNCTION, ETokenType.ENTRY}), ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.STRING_LITERAL})).createNode(EShallowEntityType.METHOD, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.IS}));
        functionAlternative.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        functionAlternative.sequence(new ITokenMatcher[]{ETokenType.IS, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEPARATE, ETokenType.ABSTRACT, ETokenType.NEW})}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        AdaShallowParser.completeBlock(functionAlternative.sequence(new ITokenMatcher[]{ETokenType.IS}).parseUntil(EAdaParserStates.DECLARATIONS).sequence(new ITokenMatcher[]{ETokenType.BEGIN}));
        this.inState(new EAdaParserStates[]{EAdaParserStates.DECLARATIONS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.COLON}).createNode(EShallowEntityType.ATTRIBUTE, "variable", INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createTypeRules() {
        RecognizerBase typeAlternative = this.inAnyState().sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TYPE, ETokenType.SUBTYPE}), ETokenType.IDENTIFIER}).createNode(EShallowEntityType.TYPE, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.IS}));
        typeAlternative.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        typeAlternative.sequence(new ITokenMatcher[]{ETokenType.IS, ETokenType.NULL, ETokenType.RECORD, ETokenType.SEMICOLON}).endNode();
        RecognizerBase typeAlternative2 = typeAlternative.sequence(new ITokenMatcher[]{ETokenType.IS}).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RECORD, ETokenType.NULL}));
        typeAlternative2.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        typeAlternative2.sequence(new ITokenMatcher[]{ETokenType.NULL}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        typeAlternative2.sequence(new ITokenMatcher[]{ETokenType.RECORD}).skipAfter(new ITokenMatcher[]{ETokenType.END, ETokenType.ENDRECORD, ETokenType.SEMICOLON}).endNode();
        RecognizerBase overlayAlternative = this.inState(new EAdaParserStates[]{EAdaParserStates.DECLARATIONS}).sequence(new ITokenMatcher[]{ETokenType.FOR}).createNode(EShallowEntityType.TYPE, "representation clause").skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RECORD}));
        overlayAlternative.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        overlayAlternative.sequence(new ITokenMatcher[]{ETokenType.RECORD}).skipAfter(new ITokenMatcher[]{ETokenType.END, ETokenType.ENDRECORD, ETokenType.SEMICOLON}).endNode();
    }

    private void createStatementRules() {
        RecognizerBase<EAdaParserStates> ifAlternative = this.inState(new EAdaParserStates[]{EAdaParserStates.STATEMENTS}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IF, ETokenType.ELSEIF})).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.THEN}).parseUntil(EAdaParserStates.STATEMENTS).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ELSEIF, ETokenType.ELSE, ETokenType.END}));
        ifAlternative.sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        ifAlternative.endNodeWithContinuation();
        this.inState(new EAdaParserStates[]{EAdaParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.ELSE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(EAdaParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EAdaParserStates[]{EAdaParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.CASE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.IS}).parseUntil(EAdaParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EAdaParserStates[]{EAdaParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.WHEN}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.EQ, ETokenType.GT}).endNode();
        this.inState(new EAdaParserStates[]{EAdaParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.COLON}).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.WHILE, ETokenType.FOR, ETokenType.LOOP, ETokenType.BEGIN})).createNode(EShallowEntityType.META, "Loop name").endNode();
        this.inState(new EAdaParserStates[]{EAdaParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.LOOP}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(EAdaParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EAdaParserStates[]{EAdaParserStates.STATEMENTS}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.WHILE, ETokenType.FOR})).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.LOOP}).parseUntil(EAdaParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        AdaShallowParser.completeBlock(this.inState(new EAdaParserStates[]{EAdaParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.DECLARE}).createNode(EShallowEntityType.STATEMENT, "block").parseUntil(EAdaParserStates.DECLARATIONS).sequence(new ITokenMatcher[]{ETokenType.BEGIN}));
        AdaShallowParser.completeBlock(this.inState(new EAdaParserStates[]{EAdaParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.DECLARE}).createNode(EShallowEntityType.STATEMENT, "block").parseUntil(EAdaParserStates.DECLARATIONS).sequence(new ITokenMatcher[]{ETokenType.BEGIN}));
        AdaShallowParser.completeBlock(this.inState(new EAdaParserStates[]{EAdaParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.BEGIN}).createNode(EShallowEntityType.STATEMENT, "block"));
        this.inState(new EAdaParserStates[]{EAdaParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.ACCEPT}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DO}).parseUntil(EAdaParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        RecognizerBase<EAdaParserStates> selectAlternative = this.inState(new EAdaParserStates[]{EAdaParserStates.STATEMENTS}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SELECT, ETokenType.OR, ETokenType.ELSE})).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(EAdaParserStates.STATEMENTS);
        selectAlternative.sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.OR, ETokenType.ELSE})).endNodeWithContinuation();
        selectAlternative.sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EAdaParserStates[]{EAdaParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.LEFT_LABEL_BRACKET}).skipAfter(new ITokenMatcher[]{ETokenType.RIGHT_LABEL_BRACKET}).createNode(EShallowEntityType.META, "goto label").endNode();
        this.inState(new EAdaParserStates[]{EAdaParserStates.STATEMENTS}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.NULL, ETokenType.RETURN, ETokenType.GOTO, ETokenType.EXIT, ETokenType.ABORT, ETokenType.DELAY, ETokenType.RAISE, ETokenType.TERMINATE})).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private static void completeBlock(RecognizerBase<EAdaParserStates> initialSequence) {
        RecognizerBase<EAdaParserStates> alt = initialSequence.parseUntil(EAdaParserStates.STATEMENTS);
        alt.sequence(new ITokenMatcher[]{ETokenType.EXCEPTION}).parseUntil(EAdaParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        alt.sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    @Override
    protected boolean isFilteredToken(IToken token, IToken previousToken) {
        if (previousToken == null) {
            return super.isFilteredToken(token, null);
        }
        boolean andThen = ETokenType.AND.matches(previousToken) && ETokenType.THEN.matches(token);
        boolean orElse = ETokenType.OR.matches(previousToken) && ETokenType.ELSE.matches(token);
        return andThen || orElse || super.isFilteredToken(token, previousToken);
    }

    public static enum EAdaParserStates {
        DECLARATIONS,
        STATEMENTS;

    }
}

