/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.cpp;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.languages.base.CStyleShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.base.CStyleShallowParserRuleProviderBase;
import eu.cqse.check.framework.shallowparser.languages.base.EGenericParserStates;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppAllUppercaseConstructorRecognizer;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppShallowParser;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppSkipTemplateSpecificationRecognizer;
import eu.cqse.check.framework.shallowparser.languages.cpp.UppercaseIdentifierMatcher;
import java.util.Collections;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class CppShallowParserClassElementRules
extends CStyleShallowParserRuleProviderBase<CStyleShallowParserBase> {
    private static final INameResolver OPERATOR_DECLARATION_NAME_RESOLVER = (state, tokens, startOffset, extractStringContent) -> {
        int startIndex = state.getCurrentReferencePosition();
        int endIndex = TokenStreamUtils.firstTokenMatching(tokens, startIndex, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LPAREN, ETokenType.SEMICOLON}));
        if (endIndex == -1) {
            endIndex = startIndex + 1;
        } else if (CppShallowParserClassElementRules.isFunctionCallOperatorOverloading(tokens, endIndex)) {
            endIndex += 2;
        }
        return StringUtils.concat((Iterable)CollectionUtils.map(tokens.subList(startIndex, endIndex), IToken::getText), (String)"");
    };

    private static boolean isFunctionCallOperatorOverloading(List<IToken> tokens, int endIndex) {
        int tokensCount = tokens.size();
        if (endIndex - 1 < 0 || endIndex + 1 > tokensCount - 1) {
            return false;
        }
        return tokens.get(endIndex - 1).getType() == ETokenType.OPERATOR && tokens.get(endIndex).getType() == ETokenType.LPAREN && tokens.get(endIndex + 1).getType() == ETokenType.RPAREN;
    }

    public CppShallowParserClassElementRules(CStyleShallowParserBase delegateParser) {
        super(delegateParser);
    }

    @Override
    public void contributeRules() {
        this.createOperatorRules();
        this.createNonPreprocessedCodeRules();
        this.createMethodWithMacroReturnTypeRules();
        this.createMethodWithArrayPointerReturnRules();
        RecognizerBase<EGenericParserStates> preprocessorGeneratedCodeAlternative = this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{UppercaseIdentifierMatcher.macroMatcher(), ETokenType.LPAREN}).notPreCondition(new CppAllUppercaseConstructorRecognizer()).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.META, "preprocessor generated code", INameResolver.firstMatchedTokenText());
        preprocessorGeneratedCodeAlternative.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        preprocessorGeneratedCodeAlternative.endNode();
        this.createMethodRules();
        this.createEventRules();
        this.createVariableRule(EGenericParserStates.TOP_LEVEL, "global variable");
        this.createVariableRule(EGenericParserStates.IN_TYPE, "attribute");
        this.createPropertyRules();
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQ, ETokenType.LBRACK})}).createNode(EShallowEntityType.ATTRIBUTE, "global variable", INameResolver.firstMatchedTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.SEMICOLON, ETokenType.LBRACE, ETokenType.RBRACE, this.createSubExpressionRecognizer()).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL}).optional(CppShallowParser.METHOD_AND_TYPE_DECLARATION_MODIFIERS).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.ATTRIBUTE, "global variable", INameResolver.firstMatchedTokenText()).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.IN_METHOD}).optional(CppShallowParser.METHOD_AND_TYPE_DECLARATION_MODIFIERS).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.ATTRIBUTE, "attribute", INameResolver.firstMatchedTokenText()).endNode();
    }

    private void createEventRules() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE}).onLanguage(ELanguage.CPP_MS_CLI).optional(CppShallowParser.CPP_CLI_EVENT_MODIFIERS).repeatedSubRecognizer(this.createScopeRecognizer()).sequence(new ITokenMatcher[]{ETokenType.EVENT}).markStart().sequence(((CStyleShallowParserBase)this.delegateParser).getIdentifierMatcher()).skipNested(ETokenType.LT, ETokenType.GT).sequence(new ITokenMatcher[]{ETokenType.XOR, ((CStyleShallowParserBase)this.delegateParser).getIdentifierMatcher()}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.ATTRIBUTE, "event", INameResolver.firstMatchedTokenText()).parseUntil(EGenericParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createNonPreprocessedCodeRules() {
        RecognizerBase<EGenericParserStates> potentialFunctionMacroCall = this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{UppercaseIdentifierMatcher.macroMatcher(), ETokenType.LPAREN}).notPreCondition(new CppAllUppercaseConstructorRecognizer()).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN);
        potentialFunctionMacroCall.preCondition(this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LBRACE}))).createNode(EShallowEntityType.METHOD, "preprocessor code", INameResolver.firstMatchedTokenText()).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        potentialFunctionMacroCall.notPreCondition(this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LBRACE}))).notPreCondition(this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LPAREN}))).createNode(EShallowEntityType.META, "preprocessor code", INameResolver.firstMatchedTokenText()).endNode();
    }

    private void createMethodWithMacroReturnTypeRules() {
        this.completeMethod("function pointer", this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.TOP_LEVEL}).sequence(UppercaseIdentifierMatcher.macroMatcher()).sequence(new ITokenMatcher[]{ETokenType.LPAREN, ETokenType.MULT}).markStart().skipAfter(new ITokenMatcher[]{ETokenType.RPAREN}).optionalSubRecognizer(new CppSkipTemplateSpecificationRecognizer()).sequence(new ITokenMatcher[]{ETokenType.LPAREN}));
        this.completeMethod("function", this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.TOP_LEVEL}).sequence(UppercaseIdentifierMatcher.macroMatcher()).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).markStart().skipAfter(new ITokenMatcher[]{ETokenType.RPAREN}).optionalSubRecognizer(new CppSkipTemplateSpecificationRecognizer()).sequence(new ITokenMatcher[]{ETokenType.LPAREN}));
    }

    private void createMethodWithArrayPointerReturnRules() {
        this.completeMethod("function", this.typePatternInState(EGenericParserStates.IN_TYPE, EGenericParserStates.TOP_LEVEL).repeatedSubRecognizer(this.createScopeRecognizer()).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).sequence(new ITokenMatcher[]{ETokenType.MULT}).markStart().sequence(CppShallowParser.VALID_IDENTIFIERS).optionalSubRecognizer(new CppSkipTemplateSpecificationRecognizer()).sequence(new ITokenMatcher[]{ETokenType.LPAREN}));
    }

    private void createVariableRule(EGenericParserStates state, String entitySubtypeName) {
        this.typePatternInState(state).repeatedSubRecognizer(CppShallowParser.createAnnotationSubrecognizer()).optional(new ITokenMatcher[]{ETokenType.STATIC}).repeatedSubRecognizer(this.createScopeRecognizer()).markStart().sequence(CppShallowParser.VALID_IDENTIFIERS).createNode(EShallowEntityType.ATTRIBUTE, entitySubtypeName, INameResolver.firstMatchedTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.SEMICOLON, ETokenType.LBRACE, ETokenType.RBRACE, this.createSubExpressionRecognizer()).endNode();
        this.typePatternInState(state).sequence(new ITokenMatcher[]{ETokenType.LPAREN, ETokenType.MULT}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).sequence(new ITokenMatcher[]{ETokenType.LBRACK}).skipAfter(new ITokenMatcher[]{ETokenType.RBRACK}).createNode(EShallowEntityType.ATTRIBUTE, entitySubtypeName, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.typePatternInState(state).sequence(new ITokenMatcher[]{ETokenType.LPAREN, ETokenType.MULT}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.RPAREN}).createNode(EShallowEntityType.ATTRIBUTE, entitySubtypeName, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.typePatternInState(state).sequence(new ITokenMatcher[]{ETokenType.LPAREN, ETokenType.XOR}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).sequence(new ITokenMatcher[]{ETokenType.RPAREN}).createNode(EShallowEntityType.ATTRIBUTE, entitySubtypeName, INameResolver.firstMatchedTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.SEMICOLON, ETokenType.LBRACE, ETokenType.RBRACE, this.createSubExpressionRecognizer()).endNode();
        this.typePatternInState(state).sequence(new ITokenMatcher[]{ETokenType.LPAREN, ETokenType.XOR, ETokenType.LPAREN, ETokenType.MULT}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).sequence(new ITokenMatcher[]{ETokenType.RPAREN, ETokenType.RPAREN}).createNode(EShallowEntityType.ATTRIBUTE, entitySubtypeName, INameResolver.firstMatchedTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.SEMICOLON, ETokenType.LBRACE, ETokenType.RBRACE, this.createSubExpressionRecognizer()).endNode();
        this.typePatternInState(state).sequence(new ITokenMatcher[]{ETokenType.LPAREN, ETokenType.XOR}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).sequence(new ITokenMatcher[]{ETokenType.LBRACK}).skipAfter(new ITokenMatcher[]{ETokenType.RBRACK}).createNode(EShallowEntityType.ATTRIBUTE, entitySubtypeName, INameResolver.firstMatchedTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.SEMICOLON, ETokenType.LBRACE, ETokenType.RBRACE, this.createSubExpressionRecognizer()).endNode();
        this.typePatternInState(state).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).sequence(new ITokenMatcher[]{ETokenType.LBRACK}).skipAfter(new ITokenMatcher[]{ETokenType.RBRACK}).createNode(EShallowEntityType.ATTRIBUTE, entitySubtypeName, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.typePatternInState(state).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).skipAfter(new ITokenMatcher[]{ETokenType.RBRACE}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.ATTRIBUTE, entitySubtypeName, INameResolver.firstMatchedTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.SEMICOLON, ETokenType.LBRACE, ETokenType.RBRACE).endNode();
    }

    private void createPropertyRules() {
        RecognizerBase<EGenericParserStates> propertyRecognizer = ((CStyleShallowParserBase)this.delegateParser).typePattern(this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE}).onLanguage(ELanguage.CPP_MS_CLI).sequence(new ITokenMatcher[]{ETokenType.PROPERTY}));
        RecognizerBase<EGenericParserStates> namedPropertyRecognizer = propertyRecognizer.markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
        namedPropertyRecognizer.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.ATTRIBUTE, "property", INameResolver.firstMatchedTokenText()).endNode();
        RecognizerBase propertyIndexer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LBRACK}).skipAfter(new ITokenMatcher[]{ETokenType.RBRACK}));
        namedPropertyRecognizer.optionalSubRecognizer(propertyIndexer).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.ATTRIBUTE, "property", INameResolver.firstMatchedTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.RBRACE).endNode();
        propertyRecognizer.sequence(new ITokenMatcher[]{ETokenType.DEFAULT}).optionalSubRecognizer(propertyIndexer).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.ATTRIBUTE, "property", "default").skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.RBRACE).endNode();
    }

    private void createOperatorRules() {
        this.completeMethod("operator", this.typePatternInState(EGenericParserStates.IN_TYPE, EGenericParserStates.TOP_LEVEL).repeatedSubRecognizer(this.createScopeRecognizer()).markStart().sequence(new ITokenMatcher[]{ETokenType.OPERATOR}).skipAfter(new ITokenMatcher[]{ETokenType.LPAREN}), OPERATOR_DECLARATION_NAME_RESOLVER);
        this.completeMethod("cast operator", this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.TOP_LEVEL}).repeatedSubRecognizer(this.createScopeRecognizer()).markStart().sequence(new ITokenMatcher[]{ETokenType.OPERATOR}).skipAfter(new ITokenMatcher[]{ETokenType.LPAREN}), INameResolver.ofIndices(0, 1));
    }

    private RecognizerBase<EGenericParserStates> createInitializerListRecognizer() {
        RecognizerBase initializerRule = this.createRecognizer(start -> {
            RecognizerBase<EGenericParserStates> initializerPart = start.repeatedSubRecognizer(this.createScopeRecognizer()).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optionalSubRecognizer(new CppSkipTemplateSpecificationRecognizer());
            initializerPart.sequenceBefore(new ITokenMatcher[]{ETokenType.LPAREN}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).optional(new ITokenMatcher[]{ETokenType.ELLIPSIS});
            initializerPart.sequenceBefore(new ITokenMatcher[]{ETokenType.LBRACE}).skipNested(ETokenType.LBRACE, ETokenType.RBRACE).optional(new ITokenMatcher[]{ETokenType.ELLIPSIS});
        });
        return this.createRecognizer(start -> start.subRecognizer(initializerRule).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LBRACE, ETokenType.COMMA})).optional(new ITokenMatcher[]{ETokenType.COMMA}));
    }

    private void createMethodRules() {
        RecognizerBase<EGenericParserStates> constructorTryRule = this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.TRY, ETokenType.COLON}).subRecognizer(this.createInitializerListRecognizer()).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, this.createSubExpressionRecognizer()).skipBefore(new ITokenMatcher[]{ETokenType.LBRACE});
        this.endConstructorTryRule(constructorTryRule.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}), ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CATCH, ETokenType.FINALLY}));
        this.endConstructorTryRule(constructorTryRule.parseOnce(EGenericParserStates.IN_METHOD), ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CATCH, ETokenType.FINALLY}));
        this.completeMethod("function", this.typePatternInState(EGenericParserStates.IN_TYPE, EGenericParserStates.TOP_LEVEL).repeatedSubRecognizer(this.createScopeRecognizer()).optional(new ITokenMatcher[]{ETokenType.NORETURN}).optional(new ITokenMatcher[]{ETokenType.STATIC}).markStart().sequence(CppShallowParser.VALID_IDENTIFIERS).optionalSubRecognizer(new CppSkipTemplateSpecificationRecognizer()).sequence(new ITokenMatcher[]{ETokenType.LPAREN}));
        this.completeMethod("function", this.typePatternInState(EGenericParserStates.IN_TYPE, EGenericParserStates.TOP_LEVEL).repeatedSubRecognizer(this.createScopeRecognizer()).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).markStart().sequence(CppShallowParser.VALID_IDENTIFIERS).sequence(new ITokenMatcher[]{ETokenType.RPAREN}).optionalSubRecognizer(new CppSkipTemplateSpecificationRecognizer()).sequence(new ITokenMatcher[]{ETokenType.LPAREN}));
        this.completeMethod("function pointer", this.typePatternInState(EGenericParserStates.IN_TYPE, EGenericParserStates.TOP_LEVEL).repeatedSubRecognizer(this.createScopeRecognizer()).repeated(new ITokenMatcher[]{ETokenType.LPAREN, ETokenType.MULT}).markStart().sequence(CppShallowParser.VALID_IDENTIFIERS).repeated(new ITokenMatcher[]{ETokenType.RPAREN}).optionalSubRecognizer(new CppSkipTemplateSpecificationRecognizer()).sequence(new ITokenMatcher[]{ETokenType.LPAREN}));
        this.completeMethod("destructor", this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.TOP_LEVEL}).optional(new ITokenMatcher[]{ETokenType.VIRTUAL}).repeatedSubRecognizer(this.createScopeRecognizer()).sequence(new ITokenMatcher[]{ETokenType.COMP}).markStart().sequence(CppShallowParser.VALID_IDENTIFIERS).optionalSubRecognizer(new CppSkipTemplateSpecificationRecognizer()).sequence(new ITokenMatcher[]{ETokenType.LPAREN}));
        this.completeMethod("constructor", this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.TOP_LEVEL}).skipWhile(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EXPLICIT, ETokenType.CONSTEXPR, ETokenType.INLINE})).repeatedSubRecognizer(this.createScopeRecognizer()).markStart().sequence(((CStyleShallowParserBase)this.delegateParser).getIdentifierMatcher()).optionalSubRecognizer(new CppSkipTemplateSpecificationRecognizer()).sequence(new ITokenMatcher[]{ETokenType.LPAREN}));
        this.completeMethod("function", this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.REQUIRES}).skipBeforeWithNesting(List.of(ETokenType.IDENTIFIER, ETokenType.LPAREN), Collections.singletonList(ETokenType.LPAREN), Collections.singletonList(ETokenType.RPAREN), null).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.LPAREN}), INameResolver.firstMatchedTokenText());
    }

    private void endConstructorTryRule(RecognizerBase<EGenericParserStates> recognizer, ITokenMatcher continuationTokens) {
        ((CStyleShallowParserBase)this.delegateParser).endWithPossibleContinuation(recognizer, continuationTokens);
    }

    private void completeMethod(String entitySubtypeName, RecognizerBase<EGenericParserStates> start) {
        this.completeMethod(entitySubtypeName, start, INameResolver.firstMatchedTokenText());
    }

    private void completeMethod(String entitySubtypeName, RecognizerBase<EGenericParserStates> start, INameResolver methodName) {
        start.subRecognizer(this.createFunctionTryBlockRecognizer()).createNode(EShallowEntityType.METHOD, entitySubtypeName, methodName).parseUntil(EGenericParserStates.IN_METHOD).parseOnce(EGenericParserStates.IN_METHOD).endNode();
        start.subRecognizer(this.createRequiresClauseRecognizer()).sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.METHOD, "function declaration", methodName).endNode();
        start.subRecognizer(this.createRequiresClauseRecognizer()).createNode(EShallowEntityType.METHOD, entitySubtypeName, methodName).parseUntil(EGenericParserStates.IN_METHOD).parseOnce(EGenericParserStates.IN_METHOD).endNode();
        ITokenMatcher krCheck = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LBRACE, ETokenType.SEMICOLON, ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.POINTERTO}).or(new ITokenMatcher[]{CppShallowParser.PRIMITIVE_TYPES});
        RecognizerBase<EGenericParserStates> krStyleAlternative = start.skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).repeatedSubRecognizer(this.createMethodPostDecoratorRecognizer()).skipBeforeWithNesting(krCheck, ETokenType.LPAREN, ETokenType.RPAREN);
        krStyleAlternative.subRecognizer(this.createKrParametersRecognizer(), 1, Integer.MAX_VALUE).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, entitySubtypeName, methodName).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        RecognizerBase<EGenericParserStates> declarationAlternative = krStyleAlternative.sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LBRACE, ETokenType.SEMICOLON, ETokenType.COLON, ETokenType.POINTERTO}));
        CppShallowParserClassElementRules.finishMethod(entitySubtypeName, declarationAlternative.sequence(new ITokenMatcher[]{ETokenType.COLON}).subRecognizer(this.createInitializerListRecognizer(), 1, Integer.MAX_VALUE).sequenceBefore(new ITokenMatcher[]{ETokenType.LBRACE}), methodName);
        CppShallowParserClassElementRules.finishMethod(entitySubtypeName, declarationAlternative.sequence(new ITokenMatcher[]{ETokenType.POINTERTO}).skipBeforeWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LBRACE, ETokenType.SEMICOLON}), ETokenType.LPAREN, ETokenType.RPAREN), methodName);
        CppShallowParserClassElementRules.finishMethod(entitySubtypeName, declarationAlternative, methodName);
    }

    private RecognizerBase<EGenericParserStates> createKrParametersRecognizer() {
        RecognizerBase lBrackRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LBRACK}));
        return this.createRecognizer(start -> ((CStyleShallowParserBase)this.delegateParser).typePattern(start).repeated(new ITokenMatcher[]{ETokenType.MULT}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optionalSubRecognizer(lBrackRecognizer).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}));
    }

    private RecognizerBase<EGenericParserStates> createMethodPostDecoratorRecognizer() {
        return this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.THROW}), ETokenType.LPAREN}).skipAfter(new ITokenMatcher[]{ETokenType.RPAREN}));
    }

    private RecognizerBase<EGenericParserStates> createFunctionTryBlockRecognizer() {
        RecognizerBase noexceptThrowRecognizer = this.createRecognizer(start -> start.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.NOEXCEPT, ETokenType.THROW})).skipNested(ETokenType.LPAREN, ETokenType.RPAREN));
        RecognizerBase requiresRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.REQUIRES}).optional(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optionalSubRecognizer(new CppSkipTemplateSpecificationRecognizer()));
        return this.createRecognizer(start -> start.skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).optionalSubRecognizer(requiresRecognizer).optionalSubRecognizer(noexceptThrowRecognizer).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.OVERRIDE, ETokenType.FINAL, ETokenType.CONST})).optional(new ITokenMatcher[]{ETokenType.VOLATILE}).sequenceBefore(new ITokenMatcher[]{ETokenType.TRY}));
    }

    private RecognizerBase<EGenericParserStates> createRequiresClauseRecognizer() {
        return this.createRecognizer(start -> start.skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.REQUIRES}).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LBRACE, ETokenType.SEMICOLON})));
    }

    private static void finishMethod(String entitySubtypeName, RecognizerBase<EGenericParserStates> recognizer, INameResolver methodName) {
        String declarationSubtype;
        recognizer.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, entitySubtypeName, methodName).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        switch (entitySubtypeName) {
            case "operator": {
                declarationSubtype = "operator declaration";
                break;
            }
            case "function": {
                declarationSubtype = "function declaration";
                break;
            }
            case "function pointer": {
                declarationSubtype = "function pointer declaration";
                break;
            }
            case "destructor": {
                declarationSubtype = "destructor declaration";
                break;
            }
            case "constructor": {
                declarationSubtype = "constructor declaration";
                break;
            }
            default: {
                return;
            }
        }
        recognizer.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.METHOD, declarationSubtype, methodName).endNode();
    }

    private RecognizerBase<EGenericParserStates> createScopeRecognizer() {
        return ((CStyleShallowParserBase)this.delegateParser).createScopeRecognizer();
    }

    private RecognizerBase<EGenericParserStates> createSubExpressionRecognizer() {
        return ((CStyleShallowParserBase)this.delegateParser).getSubExpressionRecognizer();
    }
}

