/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.visualbasic;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.PropertyAccessNameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.visualbasic.EVisualBasicParserState;
import java.util.Arrays;
import java.util.List;

public class VisualBasicShallowParser
extends ShallowParserBase<EVisualBasicParserState> {
    private static final List<ETokenType> OPENING_TYPES = Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACE, ETokenType.LBRACK);
    private static final List<ETokenType> CLOSING_TYPES = Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACE, ETokenType.RBRACK);
    private static final ITokenMatcher NO_NEW_LINE = ITokenMatcher.noneOfType((ETokenType[])new ETokenType[]{ETokenType.EOL, ETokenType.COLON});
    private static final ITokenMatcher DECLARATION_MODIFIER = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PRIVATE, ETokenType.PUBLIC, ETokenType.PROTECTED, ETokenType.MUSTINHERIT, ETokenType.NOTINHERITABLE, ETokenType.OVERLOADS, ETokenType.SHARED, ETokenType.OVERRIDES, ETokenType.SHADOWS, ETokenType.NOTOVERRIDABLE, ETokenType.FRIEND, ETokenType.READONLY, ETokenType.ASYNC, ETokenType.WITHEVENTS, ETokenType.PARTIAL, ETokenType.WIDENING, ETokenType.NARROWING, ETokenType.CONST, ETokenType.STATIC, ETokenType.DEFAULT, ETokenType.DIM});
    private static final ITokenMatcher STATEMENT_START = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.DIM, ETokenType.RETURN, ETokenType.ME, ETokenType.MYBASE, ETokenType.THROW, ETokenType.AWAIT, ETokenType.RAISEEVENT, ETokenType.REDIM, ETokenType.ADDHANDLER, ETokenType.REMOVEHANDLER, ETokenType.EXIT_DO, ETokenType.EXIT_FOR, ETokenType.EXIT_SUB, ETokenType.EXIT_WHILE, ETokenType.RESUME, ETokenType.ONERROR, ETokenType.STOP, ETokenType.GOTO, ETokenType.YIELD, ETokenType.ERROR, ETokenType.CALL, ETokenType.CONTINUE, ETokenType.END, ETokenType.ERASE, ETokenType.CTYPE});
    private static final ITokenMatcher STATEMENT_CONTINUATION_BOTH_ONLY = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COMMA, ETokenType.EQ, ETokenType.ANDEQ, ETokenType.PLUSEQ, ETokenType.MINUSEQ, ETokenType.MULTEQ, ETokenType.DIVEQ, ETokenType.INTDIVEQ, ETokenType.POWEREQ, ETokenType.LSHIFTEQ, ETokenType.RSHIFTEQ, ETokenType.PLUS, ETokenType.MINUS, ETokenType.DIV, ETokenType.INTDIV, ETokenType.MULT, ETokenType.MOD, ETokenType.NOT, ETokenType.GT, ETokenType.LTEQ, ETokenType.GTEQ, ETokenType.POWER, ETokenType.LSHIFT, ETokenType.RSHIFT, ETokenType.ANDALSO, ETokenType.OR, ETokenType.ORELSE, ETokenType.LIKE, ETokenType.XOR, ETokenType.IS, ETokenType.IS_NOT, ETokenType.AGGREGATE, ETokenType.GROUPBY, ETokenType.GROUPJOIN, ETokenType.JOIN, ETokenType.LET, ETokenType.ORDERBY, ETokenType.SELECT, ETokenType.SKIP, ETokenType.SKIPWHILE, ETokenType.TAKE, ETokenType.TAKEWHILE, ETokenType.WHERE, ETokenType.IN, ETokenType.INTO, ETokenType.ON, ETokenType.ASCENDING, ETokenType.DESCENDING, ETokenType.FROM, ETokenType.EQUALS});
    private static final ITokenMatcher STATEMENT_CONTINUATION_PRECEDING_ONLY = ETokenType.DISTINCT;
    private static final ITokenMatcher STATEMENT_CONTINUATION_FOLLOWING_ONLY = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.LT, ETokenType.AND});
    private static final ITokenMatcher STATEMENT_INTERRUPT_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EOL, ETokenType.COLON, ETokenType.ELSE, ETokenType.END_IF, ETokenType.END_WHILE, ETokenType.END_SUB, ETokenType.END_FUNCTION, ETokenType.END_NAMESPACE, ETokenType.END_USING, ETokenType.END_WITH, ETokenType.END_TRY, ETokenType.END_EVENT, ETokenType.END_SYNCLOCK, ETokenType.END_SELECT, ETokenType.END_ENUM, ETokenType.END_CLASS, ETokenType.END_TYPE, ETokenType.END_GET, ETokenType.END_SET, ETokenType.END_OPERATOR, ETokenType.END_INTERFACE, ETokenType.END_STRUCTURE});
    private static final ITokenMatcher STATEMENT_CONTINUATION_BOTH = STATEMENT_CONTINUATION_BOTH_ONLY.or(new ITokenMatcher[]{STATEMENT_CONTINUATION_FOLLOWING_ONLY, STATEMENT_CONTINUATION_PRECEDING_ONLY});
    private static final ITokenMatcher STATEMENT_CONTINUATION_PRECEDING = STATEMENT_CONTINUATION_PRECEDING_ONLY.or(new ITokenMatcher[]{STATEMENT_CONTINUATION_BOTH_ONLY});
    private static final ITokenMatcher STATEMENT_CONTINUATION_FOLLOWING = STATEMENT_CONTINUATION_FOLLOWING_ONLY.or(new ITokenMatcher[]{STATEMENT_CONTINUATION_BOTH_ONLY});
    private static final ITokenMatcher STATEMENT_CONTINUATION_CANDIDATES = STATEMENT_INTERRUPT_TYPES.or(new ITokenMatcher[]{STATEMENT_CONTINUATION_FOLLOWING_ONLY, STATEMENT_CONTINUATION_PRECEDING_ONLY, STATEMENT_CONTINUATION_BOTH_ONLY});

    public VisualBasicShallowParser() {
        super(EVisualBasicParserState.class, EVisualBasicParserState.TOP_LEVEL);
        this.createMetaRules();
        this.createNamespaceRule();
        this.createTypeLikeRules();
        this.createMethodRules();
        this.createEventRules();
        this.createPropertyRules();
        this.createAttributeRules();
        this.createEnumRules();
        this.createSelectCaseRules();
        this.createConditionalsRules();
        this.createLoopRules();
        this.createTryCatchFinallyRules();
        this.createComplexStatementRules();
        this.createSimpleStatementRule();
        this.hideLineSeparators();
    }

    @Override
    protected boolean isFilteredToken(IToken token, IToken previousToken) {
        if (super.isFilteredToken(token, previousToken)) {
            return true;
        }
        return previousToken != null && previousToken.getType() == ETokenType.EOL && token.getType() == ETokenType.EOL;
    }

    private void hideLineSeparators() {
        this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.TOP_LEVEL, EVisualBasicParserState.IN_TYPE, EVisualBasicParserState.IN_ENUM, EVisualBasicParserState.IN_EVENT_DECLARATION, EVisualBasicParserState.IN_INTERFACE, EVisualBasicParserState.IN_METHOD}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EOL, ETokenType.COLON}));
    }

    private void createEventRules() {
        this.skipToEndOfStatement(this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.IN_TYPE}).repeated(DECLARATION_MODIFIER).sequence(new ITokenMatcher[]{ETokenType.EVENT}).markStart().createNode(EShallowEntityType.ATTRIBUTE, "event", INameResolver.firstMatchedTokenText())).endNode();
        RecognizerBase<EVisualBasicParserState> base = this.skipToEndOfStatement(this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.IN_TYPE}).repeated(DECLARATION_MODIFIER).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.EVENT}).markStart().createNode(EShallowEntityType.ATTRIBUTE, "event", INameResolver.firstMatchedTokenText()));
        base.parseUntil(EVisualBasicParserState.IN_EVENT_DECLARATION).sequence(new ITokenMatcher[]{ETokenType.END_EVENT}).endNode();
        EVisualBasicParserState[] states = new EVisualBasicParserState[]{EVisualBasicParserState.IN_EVENT_DECLARATION};
        this.createComplexStatementRule(states, ETokenType.ADDHANDLER, new ITokenMatcher[]{ETokenType.END, ETokenType.ADDHANDLER});
        this.createComplexStatementRule(states, ETokenType.REMOVEHANDLER, new ITokenMatcher[]{ETokenType.END, ETokenType.REMOVEHANDLER});
        this.createComplexStatementRule(states, ETokenType.RAISEEVENT, new ITokenMatcher[]{ETokenType.END, ETokenType.RAISEEVENT});
    }

    private void createSelectCaseRules() {
        this.skipToEndOfStatement(this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.IN_METHOD, EVisualBasicParserState.IN_SINGLE_LINE_IF}).sequence(new ITokenMatcher[]{ETokenType.SELECTCASE}).createNode(EShallowEntityType.STATEMENT, "select")).parseUntil(EVisualBasicParserState.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END_SELECT}).endNode();
        this.skipToEndOfStatement(this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.IN_METHOD, EVisualBasicParserState.IN_SINGLE_LINE_IF}).sequence(new ITokenMatcher[]{ETokenType.CASE}).createNode(EShallowEntityType.META, "case")).optional(new ITokenMatcher[]{ETokenType.ELSE}).endNode();
    }

    private void createLoopRules() {
        RecognizerBase<EVisualBasicParserState> baseRecognizerDoWhile = this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.IN_METHOD, EVisualBasicParserState.IN_SINGLE_LINE_IF}).sequence(new ITokenMatcher[]{ETokenType.DO}).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.WHILE, ETokenType.UNTIL}));
        baseRecognizerDoWhile = this.skipToEndOfStatement(baseRecognizerDoWhile.createNode(EShallowEntityType.STATEMENT, "do")).parseUntil(EVisualBasicParserState.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.LOOP});
        this.skipToEndOfStatement(baseRecognizerDoWhile).endNode();
        this.skipToEndOfStatement(this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.IN_METHOD, EVisualBasicParserState.IN_SINGLE_LINE_IF}).sequence(new ITokenMatcher[]{ETokenType.WHILE}).createNode(EShallowEntityType.STATEMENT, "while")).parseUntil(EVisualBasicParserState.IN_METHOD).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.END_WHILE, ETokenType.WEND})).endNode();
        RecognizerBase<EVisualBasicParserState> baseRecognizerFor = this.skipToEndOfStatement(this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.IN_METHOD, EVisualBasicParserState.IN_SINGLE_LINE_IF}).sequence(new ITokenMatcher[]{ETokenType.FOR}).createNode(EShallowEntityType.STATEMENT, "for")).parseUntil(EVisualBasicParserState.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.NEXT});
        this.skipToEndOfStatement(baseRecognizerFor).endNode();
    }

    private void createBlockRuleWithContinuation(ITokenMatcher possibleStartTypes, ITokenMatcher continuationIndicators, ETokenType terminationType) {
        RecognizerBase<EVisualBasicParserState> base = this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.IN_METHOD, EVisualBasicParserState.IN_SINGLE_LINE_IF}).sequence(possibleStartTypes).createNode(EShallowEntityType.STATEMENT, INameResolver.previousTokenText());
        base = this.skipToEndOfStatement(base).parseUntil(EVisualBasicParserState.IN_METHOD);
        base.sequenceBefore(continuationIndicators).endNodeWithContinuation();
        base.sequence(new ITokenMatcher[]{terminationType}).endNode();
    }

    private void createTryCatchFinallyRules() {
        this.createBlockRuleWithContinuation(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TRY, ETokenType.CATCH, ETokenType.FINALLY}), ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CATCH, ETokenType.FINALLY}), ETokenType.END_TRY);
    }

    private void createComplexStatementRules() {
        EVisualBasicParserState[] states = new EVisualBasicParserState[]{EVisualBasicParserState.IN_METHOD, EVisualBasicParserState.IN_SINGLE_LINE_IF};
        this.createComplexStatementRule(states, ETokenType.USING, new ITokenMatcher[]{ETokenType.END_USING});
        this.createComplexStatementRule(states, ETokenType.WITH, new ITokenMatcher[]{ETokenType.END_WITH});
        this.createComplexStatementRule(states, ETokenType.SYNCLOCK, new ITokenMatcher[]{ETokenType.END_SYNCLOCK});
    }

    private void createComplexStatementRule(EVisualBasicParserState[] states, ETokenType startTokenType, ITokenMatcher ... endTokenType) {
        RecognizerBase<EVisualBasicParserState> base = this.inState(states).sequence(new ITokenMatcher[]{startTokenType}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText());
        this.skipToEndOfStatement(base).parseUntil(EVisualBasicParserState.IN_METHOD).sequence(endTokenType).endNode();
    }

    private void createEnumRules() {
        RecognizerBase<EVisualBasicParserState> base = this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.TOP_LEVEL, EVisualBasicParserState.IN_TYPE}).repeated(DECLARATION_MODIFIER).sequence(new ITokenMatcher[]{ETokenType.ENUM}).createNode(EShallowEntityType.TYPE, "enum", INameResolver.secondMatchedTokenText());
        this.skipToEndOfStatement(base).parseUntil(EVisualBasicParserState.IN_ENUM).sequence(new ITokenMatcher[]{ETokenType.END_ENUM}).endNode();
        RecognizerBase<EVisualBasicParserState> enumLiteralBase = this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.IN_ENUM}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.ATTRIBUTE, "enum literal", INameResolver.firstMatchedTokenText());
        this.skipToEndOfStatement(enumLiteralBase).endNode();
    }

    private void createPropertyRules() {
        RecognizerBase<EVisualBasicParserState> base = this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.IN_TYPE}).repeated(DECLARATION_MODIFIER).sequence(new ITokenMatcher[]{ETokenType.PROPERTY, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.ATTRIBUTE, "property", INameResolver.previousTokenText());
        base = this.skipToEndOfStatement(base);
        base.sequence(new ITokenMatcher[]{ETokenType.EOL}).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GET, ETokenType.SET})).parseUntil(EVisualBasicParserState.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.END_PROPERTY}).endNode();
        base.optional(new ITokenMatcher[]{ETokenType.END_PROPERTY}).endNode();
    }

    private void createConditionalsRules() {
        RecognizerBase singleLineIfSelector = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.IF}).skipAfter(new ITokenMatcher[]{ETokenType.THEN}).repeated(new ITokenMatcher[]{ETokenType.COLON}).sequence(NO_NEW_LINE));
        RecognizerBase<EVisualBasicParserState> base = this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.IN_METHOD, EVisualBasicParserState.IN_SINGLE_LINE_IF}).preCondition(singleLineIfSelector).sequence(new ITokenMatcher[]{ETokenType.IF}).createNode(EShallowEntityType.STATEMENT, INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.THEN}).parseUntil(EVisualBasicParserState.IN_SINGLE_LINE_IF).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EOL, ETokenType.ELSE}));
        base.sequenceBefore(new ITokenMatcher[]{ETokenType.ELSE}).endNodeWithContinuation();
        base.sequence(new ITokenMatcher[]{ETokenType.EOL}).endNode();
        RecognizerBase elseRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.ELSE}).repeated(new ITokenMatcher[]{ETokenType.COLON}).sequenceBefore(NO_NEW_LINE));
        this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.IN_METHOD, EVisualBasicParserState.IN_SINGLE_LINE_IF}).preCondition(elseRecognizer).sequence(new ITokenMatcher[]{ETokenType.ELSE}).createNode(EShallowEntityType.STATEMENT, INameResolver.previousTokenText()).parseUntil(EVisualBasicParserState.IN_SINGLE_LINE_IF).sequence(new ITokenMatcher[]{ETokenType.EOL}).optional(new ITokenMatcher[]{ETokenType.END_IF}).endNode();
        this.createBlockRuleWithContinuation(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IF, ETokenType.ELSEIF, ETokenType.ELSE}), ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ELSEIF, ETokenType.ELSE}), ETokenType.END_IF);
    }

    private void createNamespaceRule() {
        RecognizerBase<EVisualBasicParserState> base = this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.NAMESPACE}).createNode(EShallowEntityType.MODULE, "namespace", INameResolver.secondMatchedTokenText());
        this.skipToEndOfStatement(base).parseUntil(EVisualBasicParserState.TOP_LEVEL).sequence(new ITokenMatcher[]{ETokenType.END_NAMESPACE}).endNode();
    }

    private void createSimpleStatementRule() {
        RecognizerBase<EVisualBasicParserState> localVariable = this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.IN_METHOD, EVisualBasicParserState.IN_SINGLE_LINE_IF}).sequence(DECLARATION_MODIFIER).repeated(DECLARATION_MODIFIER).markStart().createNode(EShallowEntityType.STATEMENT, "local variable", INameResolver.firstMatchedTokenText());
        this.skipToEndOfStatement(localVariable).endNode();
        RecognizerBase<EVisualBasicParserState> simpleStatement = this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.TOP_LEVEL, EVisualBasicParserState.IN_TYPE, EVisualBasicParserState.IN_METHOD, EVisualBasicParserState.IN_SINGLE_LINE_IF}).optional(new ITokenMatcher[]{ETokenType.DOT}).repeated(DECLARATION_MODIFIER).sequence(STATEMENT_START).createNode(EShallowEntityType.STATEMENT, "simple statement", INameResolver.previousTokenText());
        this.skipToEndOfStatement(simpleStatement).endNode();
    }

    private void createMethodRules() {
        this.createMethodRule(ETokenType.FUNCTION, ETokenType.END_FUNCTION, (ITokenMatcher)ETokenType.IDENTIFIER, "method");
        this.createMethodRule(ETokenType.SUB, ETokenType.END_SUB, (ITokenMatcher)ETokenType.IDENTIFIER, "method");
        this.createMethodRule(ETokenType.SUB, ETokenType.END_SUB, (ITokenMatcher)ETokenType.NEW, "constructor");
        this.createGetSetRule(ETokenType.GET, ETokenType.END_GET);
        this.createGetSetRule(ETokenType.SET, ETokenType.END_SET);
        this.createOperatorRule();
        RecognizerBase<EVisualBasicParserState> baseRecognizerDeclare = this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.TOP_LEVEL, EVisualBasicParserState.IN_TYPE}).repeated(DECLARATION_MODIFIER).sequence(new ITokenMatcher[]{ETokenType.DECLARE}).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ANSI, ETokenType.AUTO, ETokenType.UNICODE, ETokenType.IDENTIFIER})).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SUB, ETokenType.FUNCTION})).markStart().createNode(EShallowEntityType.METHOD, "declaration", INameResolver.firstMatchedTokenText());
        this.skipToEndOfStatement(baseRecognizerDeclare).endNode();
    }

    private void createOperatorRule() {
        RecognizerBase<EVisualBasicParserState> base = this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.IN_TYPE}).repeated(DECLARATION_MODIFIER).sequence(new ITokenMatcher[]{ETokenType.OPERATOR}).markStart().createNode(EShallowEntityType.METHOD, "operator", INameResolver.firstMatchedTokenText());
        this.skipToEndOfStatement(base).parseUntil(EVisualBasicParserState.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END_OPERATOR}).endNode();
    }

    private void createGetSetRule(ETokenType startTokenType, ETokenType endTokenType) {
        RecognizerBase<EVisualBasicParserState> base = this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.IN_TYPE}).repeated(DECLARATION_MODIFIER).markStart().sequence(new ITokenMatcher[]{startTokenType}).createNode(EShallowEntityType.METHOD, INameResolver.previousTokenText(), (INameResolver)PropertyAccessNameResolver.propertyName());
        this.skipToEndOfStatement(base).parseUntil(EVisualBasicParserState.IN_METHOD).sequence(new ITokenMatcher[]{endTokenType}).endNode();
    }

    private void createMethodRule(ETokenType startTokenType, ETokenType endTokenType, ITokenMatcher identifierTokenType, String subtypeName) {
        RecognizerBase<EVisualBasicParserState> abstractTypeBase = this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.TOP_LEVEL, EVisualBasicParserState.IN_TYPE}).repeated(DECLARATION_MODIFIER).sequence(new ITokenMatcher[]{ETokenType.MUSTOVERRIDE}).repeated(DECLARATION_MODIFIER).sequence(new ITokenMatcher[]{startTokenType}).sequence(identifierTokenType).createNode(EShallowEntityType.METHOD, subtypeName, INameResolver.previousTokenText());
        this.skipToEndOfStatement(abstractTypeBase).endNode();
        RecognizerBase<EVisualBasicParserState> typeBase = this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.TOP_LEVEL, EVisualBasicParserState.IN_TYPE});
        typeBase = VisualBasicShallowParser.appendMethodNode(typeBase, startTokenType, identifierTokenType, subtypeName);
        this.skipToEndOfStatement(typeBase).parseUntil(EVisualBasicParserState.IN_METHOD).sequence(new ITokenMatcher[]{endTokenType}).endNode();
        RecognizerBase<EVisualBasicParserState> interfaceBase = this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.IN_INTERFACE});
        interfaceBase = VisualBasicShallowParser.appendMethodNode(interfaceBase, startTokenType, identifierTokenType, subtypeName);
        this.skipToEndOfStatement(interfaceBase).endNode();
    }

    private static RecognizerBase<EVisualBasicParserState> appendMethodNode(RecognizerBase<EVisualBasicParserState> base, ETokenType startTokenType, ITokenMatcher identifierTokenType, String subtypeName) {
        return base.repeated(DECLARATION_MODIFIER).sequence(new ITokenMatcher[]{startTokenType}).sequence(identifierTokenType).createNode(EShallowEntityType.METHOD, subtypeName, INameResolver.previousTokenText());
    }

    private void createAttributeRules() {
        RecognizerBase<EVisualBasicParserState> baseRecognizerAttribute = this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.TOP_LEVEL, EVisualBasicParserState.IN_TYPE}).repeated(DECLARATION_MODIFIER).optional(new ITokenMatcher[]{ETokenType.DIM}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.ATTRIBUTE, "attribute", INameResolver.previousTokenText());
        this.skipToEndOfStatement(baseRecognizerAttribute).endNode();
        RecognizerBase<EVisualBasicParserState> baseRecognizerDelegate = this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.TOP_LEVEL, EVisualBasicParserState.IN_TYPE}).repeated(DECLARATION_MODIFIER).sequence(new ITokenMatcher[]{ETokenType.DELEGATE}).markStart().createNode(EShallowEntityType.ATTRIBUTE, "delegate", INameResolver.secondMatchedTokenText());
        this.skipToEndOfStatement(baseRecognizerDelegate).endNode();
    }

    private void createTypeLikeRules() {
        this.createTypeLikeRule(EShallowEntityType.TYPE, EVisualBasicParserState.IN_TYPE, ETokenType.CLASS, ETokenType.END_CLASS, "class");
        this.createTypeLikeRule(EShallowEntityType.MODULE, EVisualBasicParserState.IN_TYPE, ETokenType.MODULE, ETokenType.END_MODULE, "module");
        this.createTypeLikeRule(EShallowEntityType.TYPE, EVisualBasicParserState.IN_INTERFACE, ETokenType.INTERFACE, ETokenType.END_INTERFACE, "interface");
        this.createTypeLikeRule(EShallowEntityType.TYPE, EVisualBasicParserState.IN_TYPE, ETokenType.STRUCTURE, ETokenType.END_STRUCTURE, "structure");
        this.createTypeLikeRule(EShallowEntityType.TYPE, EVisualBasicParserState.IN_TYPE, ETokenType.TYPE, ETokenType.END_TYPE, "type alias");
    }

    private RecognizerBase<EVisualBasicParserState> appendSkipToEndOfTypeRecognizer(RecognizerBase<EVisualBasicParserState> base) {
        RecognizerBase<EVisualBasicParserState> extendedTypeRecognizer = this.createRecognizer(start -> start.repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.INHERITS, ETokenType.IMPLEMENTS})));
        this.skipToEndOfStatement(extendedTypeRecognizer);
        return base.repeatedSubRecognizer(extendedTypeRecognizer);
    }

    private void createTypeLikeRule(EShallowEntityType shallowEntityType, EVisualBasicParserState subParseState, ETokenType startTokenType, ETokenType endTokenType, String subtypeName) {
        RecognizerBase<EVisualBasicParserState> base = this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.TOP_LEVEL, EVisualBasicParserState.IN_TYPE}).repeated(DECLARATION_MODIFIER).sequence(new ITokenMatcher[]{startTokenType, ETokenType.IDENTIFIER}).createNode(shallowEntityType, subtypeName, INameResolver.previousTokenText());
        this.appendSkipToEndOfTypeRecognizer(this.skipToEndOfStatement(base)).parseUntil(subParseState).sequence(new ITokenMatcher[]{endTokenType}).endNode();
    }

    private void createMetaRules() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.LT}).createNode(EShallowEntityType.META, "annotation", INameResolver.secondMatchedTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.GT, OPENING_TYPES, CLOSING_TYPES).endNode();
        this.skipToEndOfStatement(this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, INameResolver.previousTokenText())).endNode();
        RecognizerBase<EVisualBasicParserState> baseRecognizerImports = this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.IMPORTS}).createNode(EShallowEntityType.META, "import");
        this.skipToEndOfStatement(baseRecognizerImports).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.HASH}).createNode(EShallowEntityType.META, "preprocessor directive").skipAfter(new ITokenMatcher[]{ETokenType.EOL}).endNode();
        this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.IN_METHOD, EVisualBasicParserState.IN_SINGLE_LINE_IF}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.COLON}).createNode(EShallowEntityType.META, "label", INameResolver.ofIndex(-2)).endNode();
        this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.OPTION}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).skipForward(1).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ON, ETokenType.IDENTIFIER})).optional(new ITokenMatcher[]{ETokenType.COLON}).endNode();
        this.inState(new EVisualBasicParserState[]{EVisualBasicParserState.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.BEGIN}).createNode(EShallowEntityType.META, "form").skipAfterWithNesting((ITokenMatcher)ETokenType.END, ETokenType.BEGIN, ETokenType.END).endNode();
    }

    private RecognizerBase<EVisualBasicParserState> skipToEndOfStatement(RecognizerBase<EVisualBasicParserState> base) {
        RecognizerBase statementContinuationRecognizer = this.createRecognizer(start -> {
            RecognizerBase prefix = start.skipBeforeWithNesting(STATEMENT_CONTINUATION_CANDIDATES, OPENING_TYPES, CLOSING_TYPES);
            prefix.sequence(new ITokenMatcher[]{STATEMENT_CONTINUATION_FOLLOWING, ETokenType.EOL});
            prefix.sequence(STATEMENT_CONTINUATION_BOTH);
            prefix.sequence(new ITokenMatcher[]{ETokenType.EOL}).sequenceBefore(STATEMENT_CONTINUATION_PRECEDING);
        });
        return base.repeatedSubRecognizer(statementContinuationRecognizer).skipBeforeWithNesting(STATEMENT_INTERRUPT_TYPES, OPENING_TYPES, CLOSING_TYPES);
    }
}

