/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.xtend;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.xtend.XtendSkipToEndOfStatementRecognizer;

public class XtendShallowParser
extends ShallowParserBase<EXtendShallowParserState> {
    private static final ITokenMatcher TYPE_MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PUBLIC, ETokenType.PRIVATE, ETokenType.PROTECTED, ETokenType.PACKAGE, ETokenType.STRICTFP, ETokenType.ABSTRACT, ETokenType.STATIC});
    private static final ITokenMatcher FIELD_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BOOLEAN, ETokenType.BYTE, ETokenType.CHAR, ETokenType.DOUBLE, ETokenType.FLOAT, ETokenType.INT, ETokenType.LONG, ETokenType.SHORT, ETokenType.VOID});
    private static final ITokenMatcher FIELD_MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PUBLIC, ETokenType.PRIVATE, ETokenType.PROTECTED, ETokenType.PACKAGE, ETokenType.STATIC, ETokenType.FINAL, ETokenType.EXTENSION, ETokenType.VOLATILE, ETokenType.TRANSIENT});
    private static final ITokenMatcher METHOD_MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PUBLIC, ETokenType.PRIVATE, ETokenType.PROTECTED, ETokenType.PACKAGE, ETokenType.STATIC, ETokenType.ABSTRACT, ETokenType.DISPATCH, ETokenType.FINAL, ETokenType.STRICTFP, ETokenType.NATIVE, ETokenType.SYNCHRONIZED});

    public XtendShallowParser() {
        super(EXtendShallowParserState.class, EXtendShallowParserState.IN_TOP_LEVEL);
        this.createMetaRules();
        this.createTypeDefRules();
        this.createEnumBodyRule();
        this.createMethodDefRule();
        this.createConstructorDefRule();
        this.createLoopRules();
        this.createSwitchCaseRules();
        this.createContinuationRules();
        this.createAnonymousBlock();
        this.createFieldRules();
        this.createSingleStatementRule();
        this.createLambdaExpressionRule();
        this.createEmptyStatementRule();
    }

    private void createMetaRules() {
        this.createImportRule();
        this.createPackageRule();
        this.createAnnotationRule();
    }

    private void createImportRule() {
        this.inState(new EXtendShallowParserState[]{EXtendShallowParserState.IN_TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.IMPORT}).optional(new ITokenMatcher[]{ETokenType.STATIC}).optional(new ITokenMatcher[]{ETokenType.EXTENSION}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).repeated(new ITokenMatcher[]{ETokenType.DOT, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.MULT})}).createNode(EShallowEntityType.META, "import", INameResolver.ofRange(0, -1)).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createPackageRule() {
        this.inState(new EXtendShallowParserState[]{EXtendShallowParserState.IN_TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.PACKAGE}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).repeated(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText(), INameResolver.ofRange(1, -1)).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createAnnotationRule() {
        this.inState(new EXtendShallowParserState[]{EXtendShallowParserState.IN_TOP_LEVEL, EXtendShallowParserState.IN_TYPE, EXtendShallowParserState.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.AT_OPERATOR, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, "annotation", INameResolver.previousTokenText()).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).endNode();
    }

    private void createTypeDefRules() {
        this.createTypeDefRule(ETokenType.ENUM, "enum", EXtendShallowParserState.IN_ENUM, EXtendShallowParserState.IN_TOP_LEVEL, EXtendShallowParserState.IN_TYPE);
        this.createTypeDefRule(ETokenType.INTERFACE, "interface", EXtendShallowParserState.IN_TYPE, EXtendShallowParserState.IN_TOP_LEVEL, EXtendShallowParserState.IN_TYPE);
        this.createTypeDefRule(ETokenType.ANNOTATION, "annotation", EXtendShallowParserState.IN_TYPE, EXtendShallowParserState.IN_TOP_LEVEL, EXtendShallowParserState.IN_TYPE);
        this.createTypeDefRule(ETokenType.CLASS, "class", EXtendShallowParserState.IN_TYPE, EXtendShallowParserState.IN_TOP_LEVEL, EXtendShallowParserState.IN_TYPE, EXtendShallowParserState.IN_METHOD);
    }

    private void createTypeDefRule(ETokenType type, String subtypeName, EXtendShallowParserState substate, EXtendShallowParserState ... states) {
        this.inState(states).repeated(TYPE_MODIFIERS).sequence(new ITokenMatcher[]{type}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.TYPE, subtypeName, INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(substate).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createEnumBodyRule() {
        this.inState(new EXtendShallowParserState[]{EXtendShallowParserState.IN_ENUM}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).sequenceBefore(new ITokenMatcher[]{ETokenType.COMMA}).createNode(EShallowEntityType.ATTRIBUTE, "enum literal", INameResolver.firstMatchedTokenText()).endNode();
        this.inState(new EXtendShallowParserState[]{EXtendShallowParserState.IN_ENUM}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).sequenceBefore(new ITokenMatcher[]{ETokenType.RBRACE}).createNode(EShallowEntityType.ATTRIBUTE, "enum literal", INameResolver.firstMatchedTokenText()).endNode();
    }

    private void createMethodDefRule() {
        RecognizerBase<EXtendShallowParserState> baseRecognizer = this.inState(new EXtendShallowParserState[]{EXtendShallowParserState.IN_TYPE}).repeated(METHOD_MODIFIERS).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DEF, ETokenType.OVERRIDE})).repeated(METHOD_MODIFIERS).optional(FIELD_TYPES).repeated(METHOD_MODIFIERS);
        RecognizerBase<EXtendShallowParserState> baseWithSimpleCreate = baseRecognizer.optional(new ITokenMatcher[]{ETokenType.IDENTIFIER}).sequence(new ITokenMatcher[]{ETokenType.CREATE}).skipAfter(new ITokenMatcher[]{ETokenType.NEW}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        XtendShallowParser.appendMethodNode(baseWithSimpleCreate);
        XtendShallowParser.appendMethodNode(baseRecognizer);
        this.inState(new EXtendShallowParserState[]{EXtendShallowParserState.IN_METHOD_WITH_TEMPLATE}).sequence(new ITokenMatcher[]{ETokenType.TEMPLATE_LITERAL}).createNode(EShallowEntityType.STATEMENT, "simple statement", INameResolver.previousTokenText()).endNode();
    }

    private static void appendMethodNode(RecognizerBase<EXtendShallowParserState> baseRecognizer) {
        RecognizerBase<EXtendShallowParserState> newBaseRecognizer = baseRecognizer.skipBefore(new ITokenMatcher[]{ETokenType.LPAREN}).createNode(EShallowEntityType.METHOD, "method", INameResolver.previousTokenText()).skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        RecognizerBase<EXtendShallowParserState> withThrowsException = newBaseRecognizer.sequence(new ITokenMatcher[]{ETokenType.THROWS}).subRecognizer(new XtendSkipToEndOfStatementRecognizer(), 0, 1);
        XtendShallowParser.appendRecognizeMethodBody(newBaseRecognizer);
        XtendShallowParser.appendRecognizeMethodBody(withThrowsException);
        withThrowsException.endNode();
        newBaseRecognizer.endNode();
    }

    private static void appendRecognizeMethodBody(RecognizerBase<EXtendShallowParserState> baseRecognizer) {
        baseRecognizer.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EXtendShallowParserState.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        baseRecognizer.sequenceBefore(new ITokenMatcher[]{ETokenType.TEMPLATE_LITERAL}).parseOnce(EXtendShallowParserState.IN_METHOD_WITH_TEMPLATE).endNode();
    }

    private void createConstructorDefRule() {
        this.inState(new EXtendShallowParserState[]{EXtendShallowParserState.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.NEW}).createNode(EShallowEntityType.METHOD, "constructor").skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EXtendShallowParserState.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createLoopRules() {
        this.createForRule();
        this.createDoWhileRule();
        this.createWhileRule();
    }

    private void createForRule() {
        RecognizerBase<EXtendShallowParserState> baseRecognizer = this.inState(new EXtendShallowParserState[]{EXtendShallowParserState.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.FOR}).createNode(EShallowEntityType.STATEMENT, "for").skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        XtendShallowParser.appendEndNodeWithBlockOrSingleStatement(baseRecognizer);
    }

    private void createDoWhileRule() {
        RecognizerBase<EXtendShallowParserState> baseRecognizer = this.inState(new EXtendShallowParserState[]{EXtendShallowParserState.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.DO}).createNode(EShallowEntityType.STATEMENT, "do");
        XtendShallowParser.appendWhileRuleInDoWhile(baseRecognizer.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EXtendShallowParserState.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}));
        XtendShallowParser.appendWhileRuleInDoWhile(baseRecognizer.parseOnce(EXtendShallowParserState.IN_SINGLE_STATEMENT));
    }

    private static void appendWhileRuleInDoWhile(RecognizerBase<EXtendShallowParserState> baseRecognizer) {
        baseRecognizer.sequence(new ITokenMatcher[]{ETokenType.WHILE}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).endNode();
    }

    private void createWhileRule() {
        RecognizerBase<EXtendShallowParserState> baseRecognizer = this.inState(new EXtendShallowParserState[]{EXtendShallowParserState.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.WHILE}).createNode(EShallowEntityType.STATEMENT, "while").skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        XtendShallowParser.appendEndNodeWithBlockOrSingleStatement(baseRecognizer);
    }

    private void createSwitchCaseRules() {
        this.inState(new EXtendShallowParserState[]{EXtendShallowParserState.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.SWITCH}).createNode(EShallowEntityType.STATEMENT, "switch").skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EXtendShallowParserState.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.createCaseRules();
    }

    private void createCaseRules() {
        this.inState(new EXtendShallowParserState[]{EXtendShallowParserState.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.DEFAULT}).sequence(new ITokenMatcher[]{ETokenType.COLON}).createNode(EShallowEntityType.META, "default").endNode();
        this.inState(new EXtendShallowParserState[]{EXtendShallowParserState.IN_METHOD}).repeated(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.DOT}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).skipNested(ETokenType.LT, ETokenType.GT).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COMMA, ETokenType.COLON, ETokenType.CASE})).skipAfter(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COMMA, ETokenType.COLON})).createNode(EShallowEntityType.META, "case").endNode();
        this.inState(new EXtendShallowParserState[]{EXtendShallowParserState.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.CASE}).skipAfterWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COMMA, ETokenType.COLON}), ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.META, "case").endNode();
    }

    private void createContinuationRules() {
        this.createRuleWithContinuation(ETokenType.IF, ETokenType.ELSE, ETokenType.ELSE, ETokenType.IF);
        this.createRuleWithContinuation(ETokenType.TRY, ETokenType.FINALLY, ETokenType.CATCH);
    }

    private void createRuleWithContinuation(ETokenType first, ETokenType last, ETokenType ... middle) {
        RecognizerBase<EXtendShallowParserState> baseMid = this.inState(new EXtendShallowParserState[]{EXtendShallowParserState.IN_METHOD}).sequence((ITokenMatcher[])middle).createNode(EShallowEntityType.STATEMENT, INameResolver.ofRange(0, -1)).skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        XtendShallowParser.appendSingleStatementAndBlockForContinuationNode(baseMid, last, middle);
        RecognizerBase<EXtendShallowParserState> baseFirst = this.inState(new EXtendShallowParserState[]{EXtendShallowParserState.IN_METHOD}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{first, last})).createNode(EShallowEntityType.STATEMENT, INameResolver.ofRange(0, -1)).skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        XtendShallowParser.appendSingleStatementAndBlockForContinuationNode(baseFirst, last, middle);
    }

    private static void appendSingleStatementAndBlockForContinuationNode(RecognizerBase<EXtendShallowParserState> baseRecognizer, ETokenType last, ETokenType ... middle) {
        RecognizerBase<EXtendShallowParserState> baseBlock = baseRecognizer.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EXtendShallowParserState.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE});
        RecognizerBase<EXtendShallowParserState> baseSingleStatement = baseRecognizer.parseOnce(EXtendShallowParserState.IN_SINGLE_STATEMENT);
        XtendShallowParser.appendEndOfNodeInContinuationConstructs(baseBlock, last, middle);
        XtendShallowParser.appendEndOfNodeInContinuationConstructs(baseSingleStatement, last, middle);
    }

    private static void appendEndOfNodeInContinuationConstructs(RecognizerBase<EXtendShallowParserState> baseRecognizer, ETokenType last, ETokenType ... middle) {
        baseRecognizer.sequenceBefore(new ITokenMatcher[]{last}).endNodeWithContinuation();
        baseRecognizer.sequenceBefore((ITokenMatcher[])middle).endNodeWithContinuation();
        baseRecognizer.optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createAnonymousBlock() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.STATEMENT, "anonymous block").parseUntil(EXtendShallowParserState.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createFieldRules() {
        this.createFieldRule(EShallowEntityType.ATTRIBUTE, "attribute", EXtendShallowParserState.IN_TYPE);
        this.createFieldRule(EShallowEntityType.STATEMENT, "local variable", EXtendShallowParserState.IN_METHOD);
        RecognizerBase<EXtendShallowParserState> baseWithIdentifier = this.inState(new EXtendShallowParserState[]{EXtendShallowParserState.IN_TYPE}).repeated(FIELD_MODIFIERS).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).skipNested(ETokenType.LT, ETokenType.GT).repeated(new ITokenMatcher[]{ETokenType.LBRACK, ETokenType.RBRACK}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
        XtendShallowParser.appendFieldNodeAndSkipToEnd(baseWithIdentifier, EShallowEntityType.ATTRIBUTE, "attribute");
    }

    private void createFieldRule(EShallowEntityType type, String subtype, EXtendShallowParserState ... states) {
        RecognizerBase<EXtendShallowParserState> baseWithValOrVar = this.inState(states).repeated(FIELD_MODIFIERS).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VAL, ETokenType.VAR})).repeated(FIELD_MODIFIERS).optional(FIELD_TYPES).repeated(new ITokenMatcher[]{ETokenType.LBRACK, ETokenType.RBRACK}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).skipNested(ETokenType.LT, ETokenType.GT).repeated(new ITokenMatcher[]{ETokenType.LBRACK, ETokenType.RBRACK}).optional(new ITokenMatcher[]{ETokenType.IDENTIFIER});
        RecognizerBase<EXtendShallowParserState> baseWithFieldType = this.inState(states).repeated(FIELD_MODIFIERS).sequence(FIELD_TYPES).repeated(new ITokenMatcher[]{ETokenType.LBRACK, ETokenType.RBRACK}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
        RecognizerBase<EXtendShallowParserState> baseWithLambda = this.inState(states).repeated(FIELD_MODIFIERS).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VAL, ETokenType.VAR})).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.DOUBLE, ETokenType.FLOAT, ETokenType.BYTE, ETokenType.SHORT, ETokenType.LONG, ETokenType.CHAR, ETokenType.INT, ETokenType.BOOLEAN})).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
        XtendShallowParser.appendFieldNodeAndSkipToEnd(baseWithValOrVar, type, subtype);
        XtendShallowParser.appendFieldNodeAndSkipToEnd(baseWithFieldType, type, subtype);
        XtendShallowParser.appendFieldNodeAndSkipToEnd(baseWithLambda, type, subtype);
    }

    private static void appendFieldNodeAndSkipToEnd(RecognizerBase<EXtendShallowParserState> baseRecognizer, EShallowEntityType type, String subtype) {
        RecognizerBase<EXtendShallowParserState> alternative = baseRecognizer.createNode(type, subtype, INameResolver.previousTokenText());
        alternative.sequence(new ITokenMatcher[]{ETokenType.EQ}).subRecognizer(new XtendSkipToEndOfStatementRecognizer(), 0, 1).endNode();
        alternative.optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createSingleStatementRule() {
        RecognizerBase<EXtendShallowParserState> baseClasses = this.inState(new EXtendShallowParserState[]{EXtendShallowParserState.IN_METHOD, EXtendShallowParserState.IN_SINGLE_STATEMENT}).sequence(ITokenMatcher.anyOfClass((ETokenType.ETokenClass[])new ETokenType.ETokenClass[]{ETokenType.ETokenClass.KEYWORD, ETokenType.ETokenClass.IDENTIFIER, ETokenType.ETokenClass.LITERAL, ETokenType.ETokenClass.OPERATOR}));
        RecognizerBase<EXtendShallowParserState> baseLparen = this.inState(new EXtendShallowParserState[]{EXtendShallowParserState.IN_METHOD, EXtendShallowParserState.IN_SINGLE_STATEMENT}).sequenceBefore(new ITokenMatcher[]{ETokenType.LPAREN});
        XtendShallowParser.appendSingleStatementNode(baseClasses);
        XtendShallowParser.appendSingleStatementNode(baseLparen);
    }

    private static void appendSingleStatementNode(RecognizerBase<EXtendShallowParserState> baseRecognizer) {
        baseRecognizer.createNode(EShallowEntityType.STATEMENT, "simple statement", INameResolver.firstMatchedTokenText()).subRecognizer(new XtendSkipToEndOfStatementRecognizer(), 0, 1).endNode();
    }

    private void createLambdaExpressionRule() {
        RecognizerBase<EXtendShallowParserState> alternative = this.inState(new EXtendShallowParserState[]{EXtendShallowParserState.IN_LAMBDA}).sequence(new ITokenMatcher[]{ETokenType.LBRACK}).createNode(EShallowEntityType.METHOD, "lambda expression");
        alternative.skipBeforeWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RBRACK, ETokenType.OR}), ETokenType.LBRACK, ETokenType.RBRACK).sequence(new ITokenMatcher[]{ETokenType.OR}).parseUntil(EXtendShallowParserState.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACK}).endNode();
        alternative.parseUntil(EXtendShallowParserState.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACK}).endNode();
    }

    private void createEmptyStatementRule() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.STATEMENT, "empty statement", INameResolver.firstMatchedTokenText()).endNode();
    }

    private static void appendEndNodeWithBlockOrSingleStatement(RecognizerBase<EXtendShallowParserState> baseRecognizer) {
        baseRecognizer.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EXtendShallowParserState.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        baseRecognizer.parseOnce(EXtendShallowParserState.IN_SINGLE_STATEMENT).endNode();
    }

    @Override
    protected boolean isFilteredToken(IToken token, IToken previousToken) {
        return super.isFilteredToken(token, previousToken) || token.getType() == ETokenType.EOL;
    }

    public static enum EXtendShallowParserState {
        IN_TOP_LEVEL,
        IN_TYPE,
        IN_METHOD,
        IN_METHOD_WITH_TEMPLATE,
        IN_SINGLE_STATEMENT,
        IN_ENUM,
        IN_LAMBDA;

    }
}

