/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.xtend;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.languages.xtend.XtendShallowParser;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class XtendSkipToEndOfStatementRecognizer
extends RecognizerBase<XtendShallowParser.EXtendShallowParserState> {
    private static final ITokenMatcher LITERAL_OR_IDENTIFIER = ITokenMatcher.anyOfClass((ETokenType.ETokenClass[])new ETokenType.ETokenClass[]{ETokenType.ETokenClass.LITERAL, ETokenType.ETokenClass.IDENTIFIER});
    private static final ITokenMatcher VAL_OR_VAR = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VAL, ETokenType.VAR});
    private static final ITokenMatcher CLOSING_PARENTHESIS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RPAREN, ETokenType.RBRACK, ETokenType.RBRACE});
    private static final ITokenMatcher THROW_OR_NEW = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.THROW, ETokenType.NEW});
    private static final ITokenMatcher IDENTIFIER_OR_KEYWORD = ITokenMatcher.anyOfClass((ETokenType.ETokenClass[])new ETokenType.ETokenClass[]{ETokenType.ETokenClass.IDENTIFIER, ETokenType.ETokenClass.KEYWORD});
    private static final ITokenMatcher ALLOWED_IN_FRONT_OF_KEYWORD = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQ, ETokenType.AS_OPERATOR, ETokenType.DOT});
    private static final Map<ETokenType, ETokenType> XTEND_NESTING_MATCH = new EnumMap<ETokenType, ETokenType>(ETokenType.class);

    @Override
    protected int matchesLocally(ParserState<XtendShallowParser.EXtendShallowParserState> parserState, List<IToken> tokens, int offset) {
        if (offset <= 0) {
            return -1;
        }
        IToken lastToken = tokens.get(offset - 1);
        Stack<ETokenType> expectedClosing = new Stack<ETokenType>();
        while (offset < tokens.size()) {
            IToken token = tokens.get(offset);
            ETokenType tokenType = token.getType();
            if (!expectedClosing.isEmpty() && tokenType == expectedClosing.peek()) {
                expectedClosing.pop();
            } else {
                if (expectedClosing.isEmpty() && tokenType == ETokenType.SEMICOLON) {
                    return offset + 1;
                }
                if (expectedClosing.isEmpty() && XtendSkipToEndOfStatementRecognizer.startsNewStatement(token, lastToken)) {
                    return offset;
                }
                if (XTEND_NESTING_MATCH.containsKey(tokenType)) {
                    expectedClosing.push(XTEND_NESTING_MATCH.get(tokenType));
                } else if (tokenType == ETokenType.LBRACK && lastToken.getType() == ETokenType.HASH_OPERATOR) {
                    expectedClosing.push(ETokenType.RBRACK);
                } else {
                    int next = XtendSkipToEndOfStatementRecognizer.startSubParse(parserState, tokens, offset, tokenType);
                    if (next == -1) {
                        return -1;
                    }
                    if (next != offset) {
                        offset = next;
                        lastToken = tokens.get(offset - 1);
                        continue;
                    }
                }
            }
            lastToken = token;
            ++offset;
        }
        return offset;
    }

    private static boolean startsNewStatement(IToken token, IToken lastToken) {
        if (VAL_OR_VAR.matches(token)) {
            return true;
        }
        if (VAL_OR_VAR.matches(lastToken)) {
            return false;
        }
        if (LITERAL_OR_IDENTIFIER.matches(token) && LITERAL_OR_IDENTIFIER.matches(lastToken)) {
            return true;
        }
        if (CLOSING_PARENTHESIS.matches(lastToken) && LITERAL_OR_IDENTIFIER.matches(token)) {
            return true;
        }
        if (CLOSING_PARENTHESIS.matches(token)) {
            return true;
        }
        if (LITERAL_OR_IDENTIFIER.matches(lastToken) && ETokenType.LBRACE.matches(token)) {
            return true;
        }
        if (ETokenType.RETURN.matches(lastToken) && (LITERAL_OR_IDENTIFIER.matches(token) || ETokenType.ETokenClass.KEYWORD.matches(token))) {
            return false;
        }
        if (THROW_OR_NEW.matches(lastToken) && IDENTIFIER_OR_KEYWORD.matches(token)) {
            return false;
        }
        if (ETokenType.ETokenClass.KEYWORD.matches(lastToken) && LITERAL_OR_IDENTIFIER.matches(token)) {
            return true;
        }
        return !ALLOWED_IN_FRONT_OF_KEYWORD.matches(lastToken) && !ETokenType.ETokenClass.OPERATOR.matches(lastToken) && ETokenType.ETokenClass.KEYWORD.matches(token);
    }

    private static int startSubParse(ParserState<XtendShallowParser.EXtendShallowParserState> parserState, List<IToken> tokens, int startOffset, ETokenType tokenType) {
        if (tokenType == ETokenType.TRY || tokenType == ETokenType.SWITCH || tokenType == ETokenType.IF) {
            return parserState.parse(XtendShallowParser.EXtendShallowParserState.IN_METHOD, tokens, startOffset);
        }
        if (tokenType == ETokenType.LBRACK && tokens.get(startOffset - 1).getType() != ETokenType.HASH_OPERATOR && tokens.get(startOffset + 1).getType() != ETokenType.RBRACK) {
            return parserState.parse(XtendShallowParser.EXtendShallowParserState.IN_LAMBDA, tokens, startOffset);
        }
        return startOffset;
    }

    static {
        XTEND_NESTING_MATCH.put(ETokenType.LPAREN, ETokenType.RPAREN);
        XTEND_NESTING_MATCH.put(ETokenType.LBRACE, ETokenType.RBRACE);
    }
}

