/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import com.google.common.collect.Iterables;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.variable.CLikeVariableUseExtractor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;

abstract class ObjectiveCLanguageFeatureParserBase
extends CLikeLanguageFeatureParserBase {
    private static final ITokenMatcher ADDITIONAL_TYPE_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.ID, ETokenType.AUTO});
    protected static final ITokenMatcher VALID_IDENTIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.OPERATOR});

    protected ObjectiveCLanguageFeatureParserBase(ELanguage language, ITokenMatcher primitiveTypeTokens, CLikeVariableUseExtractor useExtractor) {
        super(language, VALID_IDENTIFIERS, primitiveTypeTokens, ADDITIONAL_TYPE_TOKENS, ETokenType.SCOPE, "::", useExtractor, ETokenType.COLON);
    }

    @Override
    public String getImportName(ShallowEntity entity) {
        return TokenStreamTextUtils.concatTokenTexts(TokenStreamUtils.tokensBetween((List<IToken>)entity.ownStartTokens(), ETokenType.IMPORT, ETokenType.SEMICOLON));
    }

    protected static List<IToken> extractObjectiveCParameterTokens(List<IToken> methodStartTokens) {
        List<IToken> tokensAfterMethodName = TokenStreamUtils.tokensBetween(methodStartTokens, ETokenType.COLON, ETokenType.LBRACE);
        if (tokensAfterMethodName.isEmpty()) {
            tokensAfterMethodName = TokenStreamUtils.tokensBetween(methodStartTokens, ETokenType.COLON, ETokenType.SEMICOLON);
        }
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        for (int index = 0; index < tokensAfterMethodName.size(); ++index) {
            if (index - 1 >= 0 && index + 1 < tokensAfterMethodName.size() && TokenStreamUtils.containsSequence(tokensAfterMethodName, index - 1, index + 2, ETokenType.IDENTIFIER, ETokenType.IDENTIFIER, ETokenType.COLON)) continue;
            tokens.add(tokensAfterMethodName.get(index));
        }
        return tokens.stream().filter(x -> x.getType() != ETokenType.LPAREN && x.getType() != ETokenType.RPAREN).collect(Collectors.toList());
    }

    public Pair<List<IToken>, String> getObjectiveCReturnTypeAndModifiers(ShallowEntity method) {
        CCSMAssert.isTrue((method.getType() == EShallowEntityType.METHOD ? 1 : 0) != 0, (String)"method.getType() must be \"METHOD\"");
        List filteredTokens = method.ownStartTokens().stream().filter(token -> token.getType() != ETokenType.LPAREN && token.getType() != ETokenType.RPAREN).collect(Collectors.toList());
        int endIndex = Iterables.indexOf(filteredTokens, token -> token.getType() == ETokenType.COLON);
        if (endIndex == -1) {
            endIndex = filteredTokens.size() - 1;
        }
        return this.getModifiersAndTypeFromTokens(filteredTokens.subList(1, endIndex));
    }
}

