/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.cpp.alignment;

import com.google.common.base.Preconditions;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppShallowParser;
import eu.cqse.check.framework.typetracker.ITypeInfoExtractor;
import eu.cqse.check.framework.typetracker.TypeInfoExtractorFactory;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.util.cpp.BinarySizeCheckUtils;
import eu.cqse.check.framework.util.cpp.alignment.AttributeEntityAlignmentInfo;
import eu.cqse.check.framework.util.cpp.alignment.DataAlignmentInfo;
import eu.cqse.check.framework.util.cpp.alignment.IAlignmentInfoExtractor;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttributeEntityAlignmentInfoExtractor
implements IAlignmentInfoExtractor<AttributeEntityAlignmentInfo> {
    private static AttributeEntityAlignmentInfoExtractor singletonInstance;
    private static final Logger LOGGER;
    private static final int DIMENSION_INTEGER_GROUP = 1;
    private static final TokenPattern ARRAY_DIMENSIONS_PATTERN;

    private AttributeEntityAlignmentInfoExtractor() {
    }

    @Override
    public boolean isApplicable(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.ATTRIBUTE;
    }

    @Override
    public AttributeEntityAlignmentInfo extract(ShallowEntity attribute, List<IToken> nonPreprocessedTokens, int architectureWordSizeInBytes) {
        Preconditions.checkArgument((boolean)this.isApplicable(attribute), (String)"Extractor is not applicable on entity: %s", (Object)attribute);
        ELanguage language = ((IToken)attribute.includedTokens().getFirst()).getLanguage();
        ITypeInfoExtractor extractor = TypeInfoExtractorFactory.getTypeInfoExtractor(language, null);
        List<TypedVariable> types = extractor.extract(attribute);
        List<DataAlignmentInfo> dataAlignmentInfos = types.isEmpty() ? Collections.singletonList(DataAlignmentInfo.createUnknown()) : types.stream().map(type -> AttributeEntityAlignmentInfoExtractor.extractForType(attribute, type, architectureWordSizeInBytes)).toList();
        return new AttributeEntityAlignmentInfo(attribute, dataAlignmentInfos);
    }

    private static DataAlignmentInfo extractForType(ShallowEntity attribute, TypedVariable type, int architectureWordSizeInBytes) {
        String typeName = type.getTypeName();
        int size = BinarySizeCheckUtils.determineSizeOfType(typeName, architectureWordSizeInBytes).orElse(-1);
        if (size == -1) {
            return DataAlignmentInfo.createUnknown(typeName);
        }
        int alignment = Math.min(size, architectureWordSizeInBytes);
        if (typeName.endsWith("[]")) {
            return AttributeEntityAlignmentInfoExtractor.extractForArray(attribute, type, size, alignment);
        }
        return new DataAlignmentInfo(typeName, size, alignment);
    }

    private static DataAlignmentInfo extractForArray(ShallowEntity arrayEntity, TypedVariable type, int typeSize, int alignment) {
        List<IToken> arrayTokens = AttributeEntityAlignmentInfoExtractor.filterRelevantTokensForDetectingArrayDimensions(arrayEntity, type.getVariableName());
        String typeName = type.getTypeName();
        TokenPatternMatch dimensionMatch = ARRAY_DIMENSIONS_PATTERN.findFirstMatch(arrayTokens);
        if (dimensionMatch == null) {
            return DataAlignmentInfo.createUnknown(typeName);
        }
        List<Integer> dimensions = dimensionMatch.groupTokens(1).stream().map(IToken::getText).map(Integer::parseInt).toList();
        int numberOfElements = dimensions.getFirst();
        for (int i = 1; i < dimensions.size(); ++i) {
            numberOfElements *= dimensions.get(i).intValue();
        }
        if (numberOfElements == 0) {
            return new DataAlignmentInfo(typeName, 0, 1);
        }
        return new DataAlignmentInfo(typeName, numberOfElements * typeSize, alignment);
    }

    private static List<IToken> filterRelevantTokensForDetectingArrayDimensions(ShallowEntity arrayEntity, String arrayVariableName) {
        Object arrayTokens = arrayEntity.ownStartTokens();
        int relevantTokensEndIndex = TokenStreamUtils.firstTokenMatching((List<IToken>)arrayEntity.includedTokens(), ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQ, ETokenType.SEMICOLON}));
        if (relevantTokensEndIndex == -1) {
            relevantTokensEndIndex = arrayTokens.size();
        }
        if (!TokenStreamUtils.contains((List<IToken>)(arrayTokens = arrayTokens.subList(0, relevantTokensEndIndex)), ETokenType.COMMA)) {
            return arrayTokens;
        }
        int variableIdentifierIndex = TokenStreamUtils.firstTokenMatchingIndexPredicate((List<IToken>)arrayTokens, 0, (index, tokens) -> {
            IToken token = (IToken)tokens.get((int)index);
            return CppShallowParser.VALID_IDENTIFIERS.matches(token) && token.getText().equals(arrayVariableName);
        });
        if (variableIdentifierIndex == -1) {
            LOGGER.debug("Could not find variable identifier {} in {}", (Object)arrayVariableName, arrayTokens);
            return Collections.emptyList();
        }
        relevantTokensEndIndex = TokenStreamUtils.firstTokenMatching((List<IToken>)arrayTokens, variableIdentifierIndex, (ITokenMatcher)ETokenType.COMMA);
        if (relevantTokensEndIndex == -1) {
            relevantTokensEndIndex = arrayTokens.size();
        }
        return arrayTokens.subList(variableIdentifierIndex, relevantTokensEndIndex);
    }

    public static AttributeEntityAlignmentInfoExtractor getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new AttributeEntityAlignmentInfoExtractor();
        }
        return singletonInstance;
    }

    static {
        LOGGER = LogManager.getLogger();
        ARRAY_DIMENSIONS_PATTERN = new TokenPattern().repeatedAtLeastOnce(new TokenPattern().sequence(ETokenType.LBRACK).sequence(ETokenType.INTEGER_LITERAL).group(1).sequence(ETokenType.RBRACK));
    }
}

