/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.filter;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaAnnotatedEntityFilter {
    private final Map<String, List<String>> filteringAnnotations = new HashMap<String, List<String>>();

    public void addAnnotations(Collection<String> filteringAnnotations) {
        for (String annotation : filteringAnnotations) {
            this.addAnnotation(annotation, new String[0]);
        }
    }

    public void addAnnotation(String annotation, String ... parameters) {
        this.filteringAnnotations.put(annotation, Arrays.asList(parameters));
    }

    public void addAnnotationAndVariants(Collection<String> annotationVariants, String ... parameters) {
        for (String variant : annotationVariants) {
            this.addAnnotation(variant, parameters);
        }
    }

    public Map<String, List<IToken>> getAnnotations(ShallowEntity entity) {
        HashMap<String, List<IToken>> annotationMap = new HashMap<String, List<IToken>>();
        List<ShallowEntity> annotations = LanguageFeatureParser.JAVA.getAnnotations(entity, true);
        for (ShallowEntity annotation : annotations) {
            List<IToken> parameters = TokenStreamUtils.tokensBetween((List<IToken>)annotation.ownStartTokens(), ETokenType.LPAREN, ETokenType.RPAREN);
            annotationMap.put(annotation.getName(), parameters);
        }
        return annotationMap;
    }

    private boolean matchesFilteringAnnotation(String filteringAnnotation, Map<String, List<IToken>> entityAnnotations) {
        if (entityAnnotations.containsKey(filteringAnnotation)) {
            List<String> filteringParameters = this.filteringAnnotations.get(filteringAnnotation);
            if (!filteringParameters.isEmpty()) {
                return JavaAnnotatedEntityFilter.matchesFilteringParameters(filteringParameters, entityAnnotations.get(filteringAnnotation));
            }
            return true;
        }
        return false;
    }

    private static boolean matchesFilteringParameters(List<String> filteringParameters, List<IToken> parameters) {
        return filteringParameters.stream().anyMatch(filteringParameter -> parameters.stream().anyMatch(parameter -> parameter.getText().equals(filteringParameter)));
    }

    public final boolean isFiltered(ShallowEntity entity) {
        Map<String, List<IToken>> entityAnnotations = this.getAnnotations(entity);
        for (String filteringAnnotation : this.filteringAnnotations.keySet()) {
            if (!this.matchesFilteringAnnotation(filteringAnnotation, entityAnnotations)) continue;
            return true;
        }
        return false;
    }
}

