/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.tokens;

import eu.cqse.check.framework.scanner.IToken;
import java.util.List;

public class TokenStream {
    private final List<IToken> tokens;
    private int position;

    public TokenStream(List<IToken> tokens, int position) {
        this.tokens = tokens;
        this.position = position;
    }

    public List<IToken> getTokens() {
        return this.tokens;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void advancePosition(int increment) {
        this.position += increment;
    }

    public boolean isAtBeginning() {
        return this.position == 0;
    }

    public boolean isExhausted() {
        return this.position >= this.tokens.size();
    }

    public List<IToken> getTokensSince(int startPosition) {
        return this.tokens.subList(startPosition, this.position);
    }

    public IToken next() {
        if (this.position >= this.tokens.size()) {
            return null;
        }
        ++this.position;
        return this.getAtPosition(this.position - 1);
    }

    private IToken getAtPosition(int position) {
        if (position >= this.tokens.size() || position < 0) {
            return null;
        }
        return this.tokens.get(position);
    }

    public IToken peekBackward() {
        return this.getAtPosition(this.position - 1);
    }

    public IToken peekCurrent() {
        return this.getAtPosition(this.position);
    }

    public int getPosition() {
        return this.position;
    }

    public IToken moveBack() {
        if (this.position <= 0) {
            return null;
        }
        --this.position;
        return this.peekCurrent();
    }
}

