/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.util.clang.misra;

import eu.cqse.check.util.clang.ClangUtils;
import eu.cqse.check.util.clang.misra.EEssentialTypeCategory;
import eu.cqse.clang.CXCursor;
import eu.cqse.clang.CXCursorKind;
import eu.cqse.clang.CXString;
import eu.cqse.clang.CXType;
import eu.cqse.clang.CXTypeKind;
import eu.cqse.clang.Clang;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;

public enum EEssentialType {
    BOOL(EEssentialTypeCategory.BOOLEAN),
    CHAR(EEssentialTypeCategory.CHARACTER),
    SIGNED_CHAR(EEssentialTypeCategory.SIGNED),
    SIGNED_SHORT(EEssentialTypeCategory.SIGNED),
    SIGNED_INT(EEssentialTypeCategory.SIGNED),
    SIGNED_LONG(EEssentialTypeCategory.SIGNED),
    SIGNED_LONG_LONG(EEssentialTypeCategory.SIGNED),
    UNSIGNED_CHAR(EEssentialTypeCategory.UNSIGNED),
    UNSIGNED_SHORT(EEssentialTypeCategory.UNSIGNED),
    UNSIGNED_INT(EEssentialTypeCategory.UNSIGNED),
    UNSIGNED_LONG(EEssentialTypeCategory.UNSIGNED),
    UNSIGNED_LONG_LONG(EEssentialTypeCategory.UNSIGNED),
    NAMED_ENUM(EEssentialTypeCategory.ENUM),
    FLOAT(EEssentialTypeCategory.FLOATING),
    DOUBLE(EEssentialTypeCategory.FLOATING),
    LONG_DOUBLE(EEssentialTypeCategory.FLOATING);

    private final EEssentialTypeCategory category;
    private static final Map<String, EEssentialType> CLANG_TYPENAME_TO_ESSENTIAL_TYPE;
    private static final List<String> SORTED_CLANG_TYPE_NAMES;

    private EEssentialType(EEssentialTypeCategory category) {
        this.category = category;
    }

    public static EEssentialType getHighestRankType(EEssentialType type1, EEssentialType type2) {
        CCSMAssert.isTrue((type1.category == type2.category ? 1 : 0) != 0, () -> "Essential types must be of same category for comparison (" + String.valueOf((Object)type1) + " vs " + String.valueOf((Object)type2) + ")");
        if (type1.ordinal() > type2.ordinal()) {
            return type1;
        }
        return type2;
    }

    public static Optional<EEssentialType> getEssentialTypeOfCursor(CXCursor cursor) {
        CXCursorKind kind = Clang.clang_getCursorKind((CXCursor)cursor);
        if (CXCursorKind.CXCursor_FirstExpr.equals(kind) || CXCursorKind.CXCursor_UnaryOperator.equals(kind)) {
            List<CXCursor> childCursors = ClangUtils.getDirectChildren(cursor);
            if (childCursors.isEmpty()) {
                return Optional.empty();
            }
            return EEssentialType.getEssentialTypeOfCursor(childCursors.get(0));
        }
        if (CXCursorKind.CXCursor_BinaryOperator.equals(kind)) {
            List<CXCursor> children = ClangUtils.getDirectChildren(cursor);
            Optional<EEssentialType> essentialLeft = EEssentialType.getEssentialTypeOfCursor(children.get(0));
            Optional<EEssentialType> essentialRight = EEssentialType.getEssentialTypeOfCursor(children.get(1));
            if (essentialLeft.isPresent() && essentialRight.isPresent() && essentialLeft.get().category == essentialRight.get().category) {
                return Optional.of(EEssentialType.getHighestRankType(essentialLeft.get(), essentialRight.get()));
            }
        } else {
            if (CXCursorKind.CXCursor_CharacterLiteral.equals(kind) || CXCursorKind.CXCursor_StringLiteral.equals(kind)) {
                return Optional.of(CHAR);
            }
            if (CXCursorKind.CXCursor_IntegerLiteral.equals(kind)) {
                return EEssentialType.getIntegerLiteralType(cursor);
            }
            if (CXCursorKind.CXCursor_FloatingLiteral.equals(kind) || CXCursorKind.CXCursor_FixedPointLiteral.equals(kind)) {
                return Optional.of(FLOAT);
            }
            if (CXCursorKind.CXCursor_DeclRefExpr.equals(kind) || CXCursorKind.CXCursor_ArraySubscriptExpr.equals(kind)) {
                return EEssentialType.getTypeFromReferenceExpression(cursor);
            }
            if (CXCursorKind.CXCursor_CallExpr.equals(kind)) {
                String type = EEssentialType.getTypeForExpression(cursor);
                return Optional.ofNullable(CLANG_TYPENAME_TO_ESSENTIAL_TYPE.get(type));
            }
        }
        return EEssentialType.getClangResolvedType(cursor);
    }

    private static Optional<EEssentialType> getIntegerLiteralType(CXCursor cursor) {
        CXTypeKind cxType = Clang.clang_getCursorType((CXCursor)cursor).getKind();
        if (cxType.equals(CXTypeKind.CXType_Int)) {
            return Optional.of(SIGNED_INT);
        }
        if (cxType.equals(CXTypeKind.CXType_UInt)) {
            return Optional.of(UNSIGNED_INT);
        }
        if (cxType.equals(CXTypeKind.CXType_Long)) {
            return Optional.of(SIGNED_LONG);
        }
        if (cxType.equals(CXTypeKind.CXType_ULong)) {
            return Optional.of(UNSIGNED_LONG);
        }
        if (cxType.equals(CXTypeKind.CXType_ULongLong)) {
            return Optional.of(UNSIGNED_LONG_LONG);
        }
        if (cxType.equals(CXTypeKind.CXType_LongLong)) {
            return Optional.of(SIGNED_LONG_LONG);
        }
        return Optional.empty();
    }

    private static String getTypeForExpression(CXCursor cursor) {
        String cursorType = Clang.clang_getCString((CXString)Clang.clang_getTypeSpelling((CXType)Clang.clang_getCursorType((CXCursor)cursor)));
        return cursorType.replace("const", "").replace("*", "").trim();
    }

    private static Optional<EEssentialType> getClangResolvedType(CXCursor cursor) {
        CXType resolvedType = ClangUtils.resolveTypedefs(Clang.clang_getCursorType((CXCursor)cursor));
        return EEssentialType.fromClangResolvedType(resolvedType);
    }

    private static Optional<EEssentialType> getTypeFromReferenceExpression(CXCursor cursor) {
        String cursorType = EEssentialType.getTypeForExpression(cursor);
        for (String typeName : SORTED_CLANG_TYPE_NAMES) {
            if (!cursorType.equalsIgnoreCase(typeName)) continue;
            return Optional.of(CLANG_TYPENAME_TO_ESSENTIAL_TYPE.get(typeName));
        }
        return EEssentialType.getClangResolvedType(cursor);
    }

    public static Optional<EEssentialType> fromClangResolvedType(CXType resolvedType) {
        String typeName = Clang.clang_getCString((CXString)Clang.clang_getTypeSpelling((CXType)resolvedType)).toLowerCase();
        if (typeName.startsWith("enum ")) {
            return Optional.of(NAMED_ENUM);
        }
        return Optional.ofNullable(CLANG_TYPENAME_TO_ESSENTIAL_TYPE.get(typeName));
    }

    public boolean isWiderThan(EEssentialType other) {
        if (this.category != other.category) {
            return false;
        }
        return this.ordinal() > other.ordinal();
    }

    public EEssentialTypeCategory getCategory() {
        return this.category;
    }

    static {
        CLANG_TYPENAME_TO_ESSENTIAL_TYPE = CollectionUtils.asMap((Pair[])new Pair[]{Pair.createPair((Object)"_bool", (Object)((Object)BOOL)), Pair.createPair((Object)"char", (Object)((Object)CHAR)), Pair.createPair((Object)"signed char", (Object)((Object)SIGNED_CHAR)), Pair.createPair((Object)"short", (Object)((Object)SIGNED_SHORT)), Pair.createPair((Object)"signed short", (Object)((Object)SIGNED_SHORT)), Pair.createPair((Object)"int", (Object)((Object)SIGNED_INT)), Pair.createPair((Object)"signed int", (Object)((Object)SIGNED_INT)), Pair.createPair((Object)"long", (Object)((Object)SIGNED_LONG)), Pair.createPair((Object)"signed long", (Object)((Object)SIGNED_LONG)), Pair.createPair((Object)"long long", (Object)((Object)SIGNED_LONG_LONG)), Pair.createPair((Object)"signed long long", (Object)((Object)SIGNED_LONG_LONG)), Pair.createPair((Object)"unsigned char", (Object)((Object)UNSIGNED_CHAR)), Pair.createPair((Object)"unsigned short", (Object)((Object)UNSIGNED_SHORT)), Pair.createPair((Object)"unsigned int", (Object)((Object)UNSIGNED_INT)), Pair.createPair((Object)"unsigned long", (Object)((Object)UNSIGNED_LONG)), Pair.createPair((Object)"unsigned long long", (Object)((Object)UNSIGNED_LONG_LONG)), Pair.createPair((Object)"float", (Object)((Object)FLOAT)), Pair.createPair((Object)"double", (Object)((Object)DOUBLE)), Pair.createPair((Object)"long double", (Object)((Object)LONG_DOUBLE))});
        SORTED_CLANG_TYPE_NAMES = CLANG_TYPENAME_TO_ESSENTIAL_TYPE.keySet().stream().sorted(Comparator.comparing(String::length).reversed()).collect(Collectors.toList());
    }
}

