/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.logging.google;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.logging.google.MonitoredResourceKubernetesContainer;
import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import retrofit2.http.Body;
import retrofit2.http.POST;

public interface IGoogleCloudLoggingRestClient
extends IRetrofitApi {
    public static final String LOGGING_API_BASE_URL = "https://logging.googleapis.com/";

    @POST(value="v2/entries:write")
    public LoggingApiRequestBody write(@Body LoggingApiRequestBody var1) throws ServiceCallException;

    public static class Timestamp {
        @JsonProperty(value="seconds")
        private final long seconds;
        @JsonProperty(value="nanos")
        private final int nanos;

        @JsonCreator
        public Timestamp(LogEvent logEvent) {
            this.seconds = logEvent.getInstant().getEpochSecond();
            this.nanos = logEvent.getInstant().getNanoOfSecond();
        }
    }

    public static class StructuredJsonPayload {
        @JsonProperty(value="originalLog4JEvent")
        private final LogEvent logEvent;
        @JsonProperty(value="message")
        private final String message;

        @JsonCreator
        public StructuredJsonPayload(LogEvent logEvent) {
            this.logEvent = logEvent;
            this.message = logEvent.getMessage().getFormattedMessage();
        }
    }

    public static class LogEntry {
        @JsonProperty(value="logName")
        private final String logName;
        @JsonProperty(value="resource")
        private final MonitoredResourceKubernetesContainer resource;
        @JsonProperty(value="severity")
        private final int severity;
        @JsonProperty(value="timestamp")
        private final Timestamp timestamp;
        @JsonProperty(value="jsonPayload")
        private final StructuredJsonPayload jsonPayload;

        @JsonCreator
        public LogEntry(String logName, MonitoredResourceKubernetesContainer resource, int severity, LogEvent logEvent, StructuredJsonPayload jsonPayload) {
            this.logName = logName;
            this.resource = resource;
            this.severity = severity;
            this.timestamp = new Timestamp(logEvent);
            this.jsonPayload = jsonPayload;
        }
    }

    public static class LoggingApiRequestBody {
        @JsonProperty(value="entries")
        private final List<LogEntry> entries;

        @JsonCreator
        public LoggingApiRequestBody(@JsonProperty(value="entries") List<LogEntry> entries) {
            this.entries = entries;
        }
    }
}

