/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.cache4j.backend;

import org.conqat.lib.commons.cache4j.backend.ICacheBackend;
import org.conqat.lib.commons.cache4j.backend.LRUCacheBackend;
import org.conqat.lib.commons.cache4j.backend.NoneCacheBackend;
import org.conqat.lib.commons.cache4j.backend.SingleElementCacheBackend;
import org.conqat.lib.commons.cache4j.backend.SoftRefCacheBackend;
import org.conqat.lib.commons.cache4j.backend.UnlimitedCacheBackend;

public enum ECachingStrategy {
    OFF,
    SINGLE,
    LRU,
    MEMORY,
    UNLIMITED;


    public <K, V> ICacheBackend<K, V> getBackend(int parameter) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new NoneCacheBackend();
            case 1 -> new SingleElementCacheBackend();
            case 2 -> {
                if (parameter < 1) {
                    parameter = 10;
                }
                yield new LRUCacheBackend(parameter);
            }
            case 3 -> new SoftRefCacheBackend();
            case 4 -> new UnlimitedCacheBackend();
        };
    }
}

