/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.color;

import java.awt.Color;
import java.util.IntSummaryStatistics;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ColorUtils {
    public static Pattern HTML_COLOR_PATTERN = Pattern.compile("#[0-9a-f]{6}", 2);

    public static String toHtmlString(Color color) {
        return String.format("#%06X", color.getRGB() & 0xFFFFFF);
    }

    public static Color fromString(String s) {
        if (HTML_COLOR_PATTERN.matcher(s).matches()) {
            return Color.decode("0x" + s.substring(1));
        }
        EAWTColors color = EnumUtils.valueOfIgnoreCase(EAWTColors.class, s);
        if (color != null) {
            return color.getColor();
        }
        return null;
    }

    public static String toHexString(Color color) {
        return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Color computeColorGradient(int value, int lowerBound, Color lowerBoundColor, int upperBound, Color upperBoundColor, IntSummaryStatistics valueSummaryStatistics, Color unityColor) {
        int rangeLowerBound;
        int rangeUpperBound = upperBound < 0 ? valueSummaryStatistics.getMax() : upperBound;
        int n = rangeLowerBound = lowerBound < 0 ? valueSummaryStatistics.getMin() : lowerBound;
        if (rangeLowerBound > rangeUpperBound) {
            throw new IllegalArgumentException(String.format("Minimum value (%d) must not be greater than maximum value (%d)", rangeLowerBound, rangeUpperBound));
        }
        int normalizedRangeUpperBound = rangeUpperBound - rangeLowerBound;
        if (normalizedRangeUpperBound == 0) {
            return unityColor;
        }
        int valueWithinBounds = Math.min(Math.max(value, rangeLowerBound), rangeUpperBound);
        int normalizedValue = valueWithinBounds - rangeLowerBound;
        double relativeValue = (double)normalizedValue / (double)normalizedRangeUpperBound;
        return ColorUtils.blend(relativeValue, upperBoundColor, lowerBoundColor);
    }

    public static Color blend(double factor, Color color1, Color color2) {
        CCSMAssert.isTrue(factor >= 0.0 && factor <= 1.0, "Factor must be between 0 and 1 but is: " + factor);
        if (factor > 0.0) {
            factor = Math.max(factor, 0.005);
        }
        int r = ColorUtils.getColorComponent(factor, color1, color2, Color::getRed);
        int g = ColorUtils.getColorComponent(factor, color1, color2, Color::getGreen);
        int b = ColorUtils.getColorComponent(factor, color1, color2, Color::getBlue);
        return new Color(r, g, b);
    }

    protected static int getColorComponent(double factor, Color color1, Color color2, Function<Color, Integer> function) {
        return (int)Math.round(factor * (double)function.apply(color1).intValue() + (1.0 - factor) * (double)function.apply(color2).intValue());
    }

    private ColorUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    private static enum EAWTColors {
        RED(Color.RED),
        GREEN(Color.GREEN),
        BLUE(Color.BLUE),
        YELLOW(Color.YELLOW),
        ORANGE(Color.ORANGE),
        WHITE(Color.WHITE),
        BLACK(Color.BLACK),
        GRAY(Color.GRAY),
        CYAN(Color.CYAN),
        MAGENTA(Color.MAGENTA);

        private final Color color;

        private EAWTColors(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

