/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.concurrent;

import java.time.Duration;
import java.util.function.BooleanSupplier;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NonNull;

public final class ThreadUtils {
    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean cancelableSleep(@NonNull Duration delay, @NonNull Duration pollingInterval, @NonNull BooleanSupplier cancelTokenSupplier) throws InterruptedException {
        CCSMAssert.isNotNull((Object)delay, () -> String.format("Expected \"%s\" to be not null", "delay"));
        CCSMAssert.isNotNull((Object)pollingInterval, () -> String.format("Expected \"%s\" to be not null", "pollingInterval"));
        CCSMAssert.isNotNull((Object)cancelTokenSupplier, () -> String.format("Expected \"%s\" to be not null", "cancelTokenSupplier"));
        if (delay.isZero() || delay.isNegative()) {
            throw new IllegalArgumentException("delay must be positive");
        }
        if (pollingInterval.isZero() || pollingInterval.isNegative()) {
            throw new IllegalArgumentException("pollingInterval must be positive");
        }
        Duration remainingDelay = delay;
        while (!remainingDelay.isZero() && !remainingDelay.isNegative()) {
            if (remainingDelay.compareTo(pollingInterval) < 0) {
                ThreadUtils.sleep(remainingDelay);
            } else {
                ThreadUtils.sleep(pollingInterval);
            }
            if (cancelTokenSupplier.getAsBoolean()) {
                return false;
            }
            remainingDelay = remainingDelay.minus(pollingInterval);
        }
        return true;
    }

    public static void sleep(Duration duration) throws InterruptedException {
        Thread.sleep(duration.toMillis());
    }

    private ThreadUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

