/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.enums;

import java.util.HashMap;
import java.util.Map;

public class EnumValueMap<E extends Enum<E>> {
    private final Map<String, E> nameToValues = new HashMap<String, E>();
    private final boolean caseSensisitve;

    public EnumValueMap(Class<E> enumType) {
        this(enumType, true);
    }

    public EnumValueMap(Class<E> enumType, boolean caseSensisitve) {
        this.caseSensisitve = caseSensisitve;
        for (Enum e : (Enum[])enumType.getEnumConstants()) {
            this.nameToValues.put(this.getKey(e.name()), e);
        }
    }

    private String getKey(String name) {
        if (this.caseSensisitve) {
            return name;
        }
        return name.toLowerCase();
    }

    public E valueOf(String name) {
        return (E)((Enum)this.nameToValues.get(this.getKey(name)));
    }
}

