/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.error;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public class MultiIOException
extends IOException {
    private static final long serialVersionUID = 1L;
    private final List<IOException> exceptions = new ArrayList<IOException>();

    public MultiIOException(Collection<? extends IOException> exceptions) {
        CCSMAssert.isFalse(exceptions.isEmpty(), "Must have at least one exception.");
        this.exceptions.addAll(exceptions);
    }

    @Override
    public String getMessage() {
        StringBuilder result = new StringBuilder();
        for (IOException ex : this.exceptions) {
            result.append(ex.getMessage());
            result.append(StringUtils.LINE_SEPARATOR);
        }
        return result.toString();
    }

    public UnmodifiableList<IOException> getExceptions() {
        return CollectionUtils.asUnmodifiable(this.exceptions);
    }
}

