/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.BasicPatternList;
import org.conqat.lib.commons.filesystem.AntPatternUtils;
import org.conqat.lib.commons.string.StringUtils;

public class AntPatternDirectoryScanner {
    private final File baseDir;
    private final boolean caseSensitive;
    private final List<String> filesFound = new ArrayList<String>();
    private final BasicPatternList fileIncludes = new BasicPatternList();
    private final BasicPatternList fileExcludes = new BasicPatternList();
    private final BasicPatternList greedyExcludes = new BasicPatternList();
    private final String[] requiredPrefixes;

    private AntPatternDirectoryScanner(File baseDir, boolean caseSensitive, String[] includePatterns, String[] excludePatterns) throws PatternSyntaxException {
        CCSMAssert.isTrue(baseDir.isDirectory(), "Can only scan in directories: " + String.valueOf(baseDir));
        this.baseDir = baseDir;
        this.caseSensitive = caseSensitive;
        boolean hadStarPrefix = false;
        ArrayList<String> prefixes = new ArrayList<String>();
        for (String include : includePatterns) {
            this.fileIncludes.add(AntPatternUtils.convertPattern(include, caseSensitive));
            if (include.startsWith("*")) {
                hadStarPrefix = true;
                continue;
            }
            prefixes.add(AntPatternDirectoryScanner.extractPlainPrefix(include, caseSensitive));
        }
        this.requiredPrefixes = hadStarPrefix || prefixes.isEmpty() ? null : prefixes.toArray(new String[prefixes.size()]);
        for (String exclude : excludePatterns) {
            Pattern pattern = AntPatternUtils.convertPattern(exclude, caseSensitive);
            this.fileExcludes.add(pattern);
            if (!exclude.endsWith("**")) continue;
            this.greedyExcludes.add(pattern);
        }
    }

    private static String extractPlainPrefix(String include, boolean caseSensitive) {
        String prefix = include.replaceFirst("([\\*/\\?]|" + Pattern.quote(File.separator) + ").*$", "");
        if (!caseSensitive) {
            prefix = prefix.toLowerCase();
        }
        return prefix;
    }

    private String[] scan() throws IOException {
        Iterator<String> iterator = AntPatternDirectoryScanner.listChildren(this.baseDir).iterator();
        while (iterator.hasNext()) {
            String path;
            String testPath = path = iterator.next();
            if (!this.caseSensitive) {
                testPath = testPath.toLowerCase();
            }
            if (this.requiredPrefixes != null && !StringUtils.startsWithOneOf(testPath, this.requiredPrefixes)) continue;
            this.doScan(path);
        }
        return this.filesFound.toArray(new String[this.filesFound.size()]);
    }

    private void doScan(String relativePath) throws IOException {
        File file = new File(this.baseDir, relativePath);
        if (file.isDirectory()) {
            if (!this.skipDirectory(relativePath)) {
                for (String name : AntPatternDirectoryScanner.listChildren(file)) {
                    this.doScan(relativePath + "/" + name);
                }
            }
        } else if (this.isIncluded(relativePath) && !this.isExcluded(relativePath)) {
            String foundFile = relativePath.replace('/', File.separatorChar);
            this.filesFound.add(foundFile);
        }
    }

    private static Set<String> listChildren(File dir) throws IOException {
        String[] list = dir.list();
        if (list == null) {
            throw new IOException("Cannot scan in directory " + String.valueOf(dir) + "! Maybe read permissions are missing?");
        }
        return new HashSet<String>(Arrays.asList(list));
    }

    private boolean skipDirectory(String relativePath) {
        return this.greedyExcludes.matchesAny(relativePath);
    }

    private boolean isIncluded(String relativePath) {
        return this.fileIncludes.isEmpty() || this.fileIncludes.matchesAny(relativePath);
    }

    private boolean isExcluded(String relativePath) {
        return this.fileExcludes.matchesAny(relativePath);
    }

    public static String[] scan(String baseDir, boolean caseSensitive, String[] includePatterns, String[] excludePatterns) throws IOException {
        if (includePatterns == null) {
            includePatterns = new String[]{};
        }
        if (excludePatterns == null) {
            excludePatterns = new String[]{};
        }
        return new AntPatternDirectoryScanner(new File(baseDir), caseSensitive, includePatterns, excludePatterns).scan();
    }
}

