/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.math;

import java.util.Collection;
import org.conqat.lib.commons.math.IAggregator;
import org.conqat.lib.commons.math.VarianceAggregator;

public class StdDevAggregator
implements IAggregator {
    private final VarianceAggregator varianceAggregator;

    public StdDevAggregator(boolean sample) {
        this.varianceAggregator = new VarianceAggregator(sample);
    }

    @Override
    public double aggregate(Collection<? extends Number> values) {
        if (values.isEmpty()) {
            return Double.NaN;
        }
        double variance = this.varianceAggregator.aggregate(values);
        return Math.sqrt(variance);
    }

    @Override
    public double getNeutralElement() {
        return Double.NaN;
    }
}

