/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index;

import org.conqat.engine.persistence.cache.IndexWithCache;
import org.conqat.engine.persistence.cache.StorageCacheBase;
import org.conqat.engine.persistence.cache.StorageCacheProvider;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;

public class IndexCreator {
    private final StorageCacheProvider.StorageSystemCacheProvider cacheProvider;

    public IndexCreator(StorageCacheProvider.StorageSystemCacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public <T extends IStorageIndex> T createIndex(Class<T> indexClass, IStore store) throws StorageException {
        try {
            IndexWithCache indexWithCache = indexClass.getAnnotation(IndexWithCache.class);
            if (indexWithCache == null) {
                return (T)((IStorageIndex)indexClass.getConstructor(IStore.class).newInstance(store));
            }
            Class<? extends StorageCacheBase>[] cacheClasses = indexWithCache.value();
            Class[] constructorArgumentTypes = new Class[cacheClasses.length + 1];
            Object[] constructorArguments = new Object[cacheClasses.length + 1];
            constructorArgumentTypes[0] = IStore.class;
            constructorArguments[0] = store;
            for (int i = 0; i < cacheClasses.length; ++i) {
                constructorArgumentTypes[i + 1] = SynchronizedCacheAccess.class;
                constructorArguments[i + 1] = this.cacheProvider.getCacheAccess(cacheClasses[i]);
            }
            return (T)((IStorageIndex)indexClass.getConstructor(constructorArgumentTypes).newInstance(constructorArguments));
        }
        catch (NoSuchMethodException e) {
            throw new StorageException("Failed to create index for class " + String.valueOf(indexClass) + ". Could not find public constructor Index(IStore) or Index(IStore,SynchronizedCacheAccess).", e);
        }
        catch (Exception e) {
            throw new StorageException("Failed to create index for class " + String.valueOf(indexClass) + ". public constructor missing?", e);
        }
    }
}

