/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.collections;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.IUtilityIndex;
import org.conqat.engine.persistence.index.KeysOnlyIndex;
import org.conqat.engine.persistence.index.collections.DurableCounterSet;
import org.conqat.engine.persistence.index.collections.DurableDistributedList;
import org.conqat.engine.persistence.index.collections.DurableIdGenerator;
import org.conqat.engine.persistence.index.collections.DurableSet;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.lib.commons.string.StringUtils;

public final class DurableCollectionIndex<T extends Serializable>
implements IUtilityIndex {
    private final DelegatingPartitionStore valueStore;
    private final KeysOnlyIndex metaIndex;

    public DurableCollectionIndex(IStore store) {
        this.valueStore = new DelegatingPartitionStore(store, "v");
        this.metaIndex = new KeysOnlyIndex(new DelegatingPartitionStore(store, "m"));
    }

    public DurableSet<T> createLocalDurableSet(String name) throws StorageException {
        this.metaIndex.storeKey(name);
        return new DurableSet(this.valueStore, StringUtils.stringToBytes((String)name));
    }

    public Map<String, DurableSet<T>> getCreatedLocalDurableSets(String prefix) throws StorageException {
        List<String> names = this.metaIndex.streamKeysStartingWith(prefix).toList();
        HashMap result = Maps.newHashMapWithExpectedSize((int)names.size());
        for (String name : names) {
            result.put(name, this.createLocalDurableSet(name));
        }
        return result;
    }

    public DurableCounterSet<T> createLocalDurableCounterSet(String name) throws StorageException {
        return new DurableCounterSet(this.valueStore, StringUtils.stringToBytes((String)name));
    }

    public DurableDistributedList<T> createDistributedDurableList(String name, InternalProjectId projectId, IMessageBroker messageBroker) {
        return new DurableDistributedList(this.valueStore, name, projectId, messageBroker);
    }

    public DurableIdGenerator createDistributedDurableIdGenerator(String name) {
        return new DurableIdGenerator(this.valueStore, name + "-idgen");
    }

    @Override
    public IStore getWrappedStore() {
        return this.valueStore.getBaseStore();
    }
}

